/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTransformRecipe.class})
public class SmithingTransformRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private void onAssemble(SmithingRecipeInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        String swordType;
        ModDataComponents.SwordTrimComponent oldTrim;
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack base = input.base();
        ItemStack addition = input.addition();
        if (!result.isEmpty() && this.better_sword_trims$isSword(result) && addition.is(Items.CRYING_OBSIDIAN) && (oldTrim = (ModDataComponents.SwordTrimComponent)base.get((DataComponentType)ModDataComponents.TRIM.get())) != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && (swordType = this.better_sword_trims$getSwordType(result)) != null) {
            String configKey = swordType + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            int currentMaxDurability = result.getMaxDamage();
            int baseDurability = (int)((double)currentMaxDurability / cfg.durabilityMultiplier);
            int currentDamage = result.getDamageValue();
            float damageRatio = currentMaxDurability > 0 ? (float)currentDamage / (float)currentMaxDurability : 0.0f;
            result.set(DataComponents.MAX_DAMAGE, (Object)baseDurability);
            result.setDamageValue((int)((float)baseDurability * damageRatio));
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.getItem() == Items.IRON_SWORD || stack.getItem() == Items.GOLDEN_SWORD || stack.getItem() == Items.DIAMOND_SWORD || stack.getItem() == Items.NETHERITE_SWORD;
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        if (stack.getItem() == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (stack.getItem() == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (stack.getItem() == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (stack.getItem() == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }
}

