/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTrimRecipe.class})
public class SmithingTrimRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private void onAssemble(SmithingRecipeInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        String trimMaterial;
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack template = input.template();
        ItemStack addition = input.addition();
        ItemStack base = input.base();
        if (!result.isEmpty() && this.better_sword_trims$isSword(result) && !template.isEmpty() && template.getItem().toString().contains("spike_armor_trim_smithing_template") && (trimMaterial = this.better_sword_trims$getTrimMaterialFromItem(addition)) != null) {
            String swordType;
            int baseDurability;
            String swordType2;
            ModDataComponents.SwordTrimComponent oldTrim = (ModDataComponents.SwordTrimComponent)base.get((DataComponentType)ModDataComponents.TRIM.get());
            if (oldTrim != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && (swordType2 = this.better_sword_trims$getSwordType(result)) != null) {
                String configKey = swordType2 + "_copper";
                SwordConfig cfg = ConfigManager.getConfig(configKey);
                int currentMaxDurability = result.getMaxDamage();
                baseDurability = (int)((double)currentMaxDurability / cfg.durabilityMultiplier);
                int currentDamage = result.getDamageValue();
                float damageRatio = currentMaxDurability > 0 ? (float)currentDamage / (float)currentMaxDurability : 0.0f;
                result.set(DataComponents.MAX_DAMAGE, (Object)baseDurability);
                result.setDamageValue((int)((float)baseDurability * damageRatio));
            }
            ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(trimMaterial);
            result.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)trimComponent);
            if (trimMaterial.equals("minecraft:copper_ingot") && (swordType = this.better_sword_trims$getSwordType(result)) != null) {
                String configKey = swordType + "_copper";
                SwordConfig cfg = ConfigManager.getConfig(configKey);
                baseDurability = result.getMaxDamage();
                int newMaxDurability = (int)((double)baseDurability * cfg.durabilityMultiplier);
                int currentDamage = result.getDamageValue();
                float damageRatio = baseDurability > 0 ? (float)currentDamage / (float)baseDurability : 0.0f;
                result.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
                result.setDamageValue((int)((float)newMaxDurability * damageRatio));
            }
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.getItem() == Items.IRON_SWORD || stack.getItem() == Items.GOLDEN_SWORD || stack.getItem() == Items.DIAMOND_SWORD || stack.getItem() == Items.NETHERITE_SWORD;
    }

    @Unique
    private String better_sword_trims$getTrimMaterialFromItem(ItemStack item) {
        if (item.isEmpty()) {
            return null;
        }
        if (item.is(Items.COPPER_INGOT)) {
            return "minecraft:copper_ingot";
        }
        if (item.is(Items.EMERALD)) {
            return "minecraft:emerald";
        }
        if (item.is(Items.LAPIS_LAZULI)) {
            return "minecraft:lapis_lazuli";
        }
        if (item.is(Items.QUARTZ)) {
            return "minecraft:quartz";
        }
        if (item.is(Items.REDSTONE)) {
            return "minecraft:redstone";
        }
        if (item.is(Items.CRYING_OBSIDIAN)) {
            return "minecraft:crying_obsidian";
        }
        return null;
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        if (stack.getItem() == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (stack.getItem() == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (stack.getItem() == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (stack.getItem() == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }
}

