/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimmedSwordItem
extends class_1829 {
    private final ModItems.TrimMaterial trimMaterial;
    private final String configKey;
    private final SwordConfig cfg;

    public TrimmedSwordItem(int baseDurability, int actualDurability, float attackDamage, float attackSpeed, ModItems.TrimMaterial trimMaterial, String configKey, class_1792.class_1793 properties) {
        super((class_1832)new CustomTier(actualDurability, 0.0f), properties.method_57348(class_1829.method_57394((class_1832)new CustomTier(actualDurability, 0.0f), (int)((int)attackDamage - 1), (float)attackSpeed)));
        this.trimMaterial = trimMaterial;
        this.configKey = configKey;
        this.cfg = ConfigManager.getConfig(configKey);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!target.method_37908().field_9236) {
            this.applyTrimEffect(stack, target, attacker);
        }
        return super.method_7873(stack, target, attacker);
    }

    private void applyTrimEffect(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_3218 level = (class_3218)target.method_37908();
        switch (this.trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(this.cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.method_6092(new class_1293(class_1294.field_5912, glowTicks, this.cfg.highlights == null ? 0 : 0));
                }
                this.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.method_5780("better_sword_trims:quartz_kill");
                int extraXp = this.cfg == null ? 0 : this.cfg.experience;
                target.method_5780("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(this.cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = this.cfg == null ? 0 : this.cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.method_6092(new class_1293(class_1294.field_5902, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(this.cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = this.cfg == null ? 0 : this.cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.method_6092(new class_1293(class_1294.field_5909, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                this.applyAreaDamage(stack, target, attacker, level);
            }
        }
    }

    private void highlightSameTypeEntities(class_1309 target, class_3218 level, int glowTicks) {
        class_1299 targetType = target.method_5864();
        class_238 searchArea = target.method_5829().method_1014(32.0);
        List nearbyEntities = level.method_8390(class_1309.class, searchArea, entity -> entity.method_5864() == targetType && entity != target);
        for (class_1309 entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.method_6092(new class_1293(class_1294.field_5912, glowTicks, 0));
        }
    }

    private void applyAreaDamage(class_1799 stack, class_1309 target, class_1309 attacker, class_3218 level) {
        class_238 damageArea = target.method_5829().method_1014(3.0);
        float baseDamage = (float)attacker.method_45325(class_5134.field_23721);
        List nearbyEntities = level.method_8390(class_1309.class, damageArea, entity -> entity != target && entity != attacker && entity.method_5805());
        double configured = this.cfg == null ? 0.0 : this.cfg.areaDamage.amount;
        for (class_1309 entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.method_5739((class_1297)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.method_5643(level.method_48963().method_48812(attacker), damage);
            level.method_14199((class_2394)class_2398.field_11227, entity2.method_23317(), entity2.method_23318() + (double)entity2.method_17682() * 0.5, entity2.method_23321(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Upgrade:").method_27692(class_124.field_1080));
        String materialName = switch (this.trimMaterial) {
            default -> throw new MatchException(null, null);
            case ModItems.TrimMaterial.QUARTZ -> "Quartz";
            case ModItems.TrimMaterial.EMERALD -> "Emerald";
            case ModItems.TrimMaterial.LAPIS -> "Lapis Lazuli";
            case ModItems.TrimMaterial.WEEPING_OBSIDIAN -> "Crying Obsidian";
            case ModItems.TrimMaterial.REDSTONE -> "Redstone";
            case ModItems.TrimMaterial.COPPER -> "Copper";
        };
        tooltipComponents.add((class_2561)class_2561.method_43470((String)(" " + materialName + " Material")).method_27692(this.trimMaterial.getColor()));
        tooltipComponents.add((class_2561)class_2561.method_43470((String)(" " + this.trimMaterial.getDescription())).method_27692(this.trimMaterial.getColor()));
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    public ModItems.TrimMaterial getTrimMaterial() {
        return this.trimMaterial;
    }

    private static class CustomTier
    implements class_1832 {
        private final int durability;
        private final float attackDamage;

        public CustomTier(int durability, float attackDamage) {
            this.durability = durability;
            this.attackDamage = attackDamage;
        }

        public int method_8025() {
            return this.durability;
        }

        public float method_8027() {
            return 8.0f;
        }

        public float method_8028() {
            return this.attackDamage;
        }

        public class_6862<class_2248> method_58419() {
            return null;
        }

        public int method_8026() {
            return 14;
        }

        public class_1856 method_8023() {
            return class_1856.field_9017;
        }
    }
}

