/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9697;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModRecipes;

public class SwordTrimTransformRecipe
implements class_8059 {
    private final class_1856 template;
    private final class_1856 base;
    private final class_1856 addition;
    private final String ingredientId;

    public SwordTrimTransformRecipe(class_1856 template, class_1856 base, class_1856 addition, String ingredientId) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.ingredientId = ingredientId;
    }

    public boolean matches(class_9697 input, class_1937 level) {
        return this.template.method_8093(input.comp_2677()) && this.base.method_8093(input.comp_2678()) && this.addition.method_8093(input.comp_2679());
    }

    public class_1799 assemble(class_9697 input, class_7225.class_7874 registries) {
        String swordType;
        class_1799 baseStack = input.comp_2678();
        class_1799 resultStack = baseStack.method_7972();
        int originalBaseDurability = this.getOriginalDurability(resultStack);
        int baseDamage = baseStack.method_7919();
        int baseMaxDurability = baseStack.method_7936();
        float damageRatio = baseMaxDurability > 0 ? (float)baseDamage / (float)baseMaxDurability : 0.0f;
        ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(this.ingredientId);
        resultStack.method_57379(ModDataComponents.TRIM, (Object)trimComponent);
        int newMaxDurability = originalBaseDurability;
        if ("minecraft:copper_ingot".equals(this.ingredientId) && (swordType = this.getSwordType(resultStack)) != null) {
            String configKey = swordType + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            newMaxDurability = (int)((double)originalBaseDurability * cfg.durabilityMultiplier);
        }
        resultStack.method_57379(class_9334.field_50072, (Object)newMaxDurability);
        resultStack.method_7974((int)((float)newMaxDurability * damageRatio));
        return resultStack;
    }

    private int getOriginalDurability(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_22022) {
            return 2031;
        }
        if (stack.method_7909() == class_1802.field_8802) {
            return 1561;
        }
        if (stack.method_7909() == class_1802.field_8845) {
            return 32;
        }
        if (stack.method_7909() == class_1802.field_8371) {
            return 250;
        }
        return 0;
    }

    private String getSwordType(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_22022) {
            return "netherite";
        }
        if (stack.method_7909() == class_1802.field_8802) {
            return "diamond";
        }
        if (stack.method_7909() == class_1802.field_8845) {
            return "golden";
        }
        if (stack.method_7909() == class_1802.field_8371) {
            return "iron";
        }
        return null;
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public boolean method_48453(class_1799 stack) {
        return this.template.method_8093(stack);
    }

    public boolean method_48454(class_1799 stack) {
        return this.base.method_8093(stack);
    }

    public boolean method_30029(class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.SWORD_TRIM_TRANSFORM_RECIPE;
    }

    public class_3956<?> method_17716() {
        return class_3956.field_25388;
    }

    public boolean method_31584() {
        return this.template.method_8103() || this.base.method_8103() || this.addition.method_8103();
    }

    public static class Serializer
    implements class_1865<SwordTrimTransformRecipe> {
        private static final MapCodec<SwordTrimTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("template").forGetter(recipe -> recipe.template), (App)class_1856.field_46095.fieldOf("base").forGetter(recipe -> recipe.base), (App)class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)Codec.STRING.fieldOf("ingredient_id").forGetter(recipe -> recipe.ingredientId)).apply((Applicative)instance, SwordTrimTransformRecipe::new));
        private static final class_9139<class_9129, SwordTrimTransformRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SwordTrimTransformRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SwordTrimTransformRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static SwordTrimTransformRecipe fromNetwork(class_9129 buffer) {
            class_1856 template = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_1856 base = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_1856 addition = (class_1856)class_1856.field_48355.decode((Object)buffer);
            String ingredientId = buffer.method_19772();
            return new SwordTrimTransformRecipe(template, base, addition, ingredientId);
        }

        private static void toNetwork(class_9129 buffer, SwordTrimTransformRecipe recipe) {
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.template);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.base);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.addition);
            buffer.method_10814(recipe.ingredientId);
        }
    }
}

