/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.util;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimEffectHelper {
    public static ModItems.TrimMaterial getTrimMaterialFromIngredient(String ingredient) {
        return switch (ingredient) {
            case "minecraft:crying_obsidian" -> ModItems.TrimMaterial.WEEPING_OBSIDIAN;
            case "minecraft:lapis_lazuli" -> ModItems.TrimMaterial.LAPIS;
            case "minecraft:emerald" -> ModItems.TrimMaterial.EMERALD;
            case "minecraft:quartz" -> ModItems.TrimMaterial.QUARTZ;
            case "minecraft:redstone" -> ModItems.TrimMaterial.REDSTONE;
            case "minecraft:copper_ingot" -> ModItems.TrimMaterial.COPPER;
            default -> null;
        };
    }

    public static String getSwordTypeFromItem(class_1799 stack) {
        String itemId = stack.method_7909().toString();
        if (itemId.contains("netherite_sword")) {
            return "netherite";
        }
        if (itemId.contains("diamond_sword")) {
            return "diamond";
        }
        if (itemId.contains("golden_sword")) {
            return "golden";
        }
        if (itemId.contains("iron_sword")) {
            return "iron";
        }
        return null;
    }

    public static void applyTrimEffect(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1937 class_19372;
        ModDataComponents.SwordTrimComponent trimComponent = (ModDataComponents.SwordTrimComponent)stack.method_57824(ModDataComponents.TRIM);
        if (trimComponent == null) {
            return;
        }
        ModItems.TrimMaterial trimMaterial = TrimEffectHelper.getTrimMaterialFromIngredient(trimComponent.getIngredient());
        if (trimMaterial == null) {
            return;
        }
        String swordType = TrimEffectHelper.getSwordTypeFromItem(stack);
        if (swordType == null) {
            return;
        }
        String configKey = swordType + "_" + trimMaterial.getName();
        SwordConfig cfg = ConfigManager.getConfig(configKey);
        if (!target.method_37908().field_9236 && (class_19372 = target.method_37908()) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            TrimEffectHelper.applyEffect(trimMaterial, cfg, stack, target, attacker, level);
        }
    }

    private static void applyEffect(ModItems.TrimMaterial trimMaterial, SwordConfig cfg, class_1799 stack, class_1309 target, class_1309 attacker, class_3218 level) {
        switch (trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.method_6092(new class_1293(class_1294.field_5912, glowTicks, 0));
                }
                TrimEffectHelper.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.method_5780("better_sword_trims:quartz_kill");
                int extraXp = cfg == null ? 0 : cfg.experience;
                target.method_5780("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = cfg == null ? 0 : cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.method_6092(new class_1293(class_1294.field_5902, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = cfg == null ? 0 : cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.method_6092(new class_1293(class_1294.field_5909, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                TrimEffectHelper.applyAreaDamage(stack, target, attacker, level, cfg);
            }
        }
    }

    private static void highlightSameTypeEntities(class_1309 target, class_3218 level, int glowTicks) {
        class_1299 targetType = target.method_5864();
        class_238 searchArea = target.method_5829().method_1014(32.0);
        List nearbyEntities = level.method_8390(class_1309.class, searchArea, entity -> entity.method_5864() == targetType && entity != target);
        for (class_1309 entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.method_6092(new class_1293(class_1294.field_5912, glowTicks, 0));
        }
    }

    private static void applyAreaDamage(class_1799 stack, class_1309 target, class_1309 attacker, class_3218 level, SwordConfig cfg) {
        class_238 damageArea = target.method_5829().method_1014(3.0);
        float baseDamage = (float)attacker.method_45325(class_5134.field_23721);
        List nearbyEntities = level.method_8390(class_1309.class, damageArea, entity -> entity != target && entity != attacker && entity.method_5805());
        double configured = cfg == null ? 0.0 : cfg.areaDamage.amount;
        for (class_1309 entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.method_5739((class_1297)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.method_5643(level.method_48963().method_48812(attacker), damage);
            level.method_14199((class_2394)class_2398.field_11227, entity2.method_23317(), entity2.method_23318() + (double)entity2.method_17682() * 0.5, entity2.method_23321(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

