/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.library.inventory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    public static boolean hasAllItems(Container target, Container items) {
        int i;
        target = InventoryUtil.copy(target);
        HashMap<StackHolder, Integer> itemsMap = new HashMap<StackHolder, Integer>();
        for (i = 0; i < items.m_6643_(); ++i) {
            ItemStack stack = items.m_8020_(i);
            if (stack.m_41619_()) continue;
            StackHolder holder = new StackHolder(stack);
            itemsMap.put(holder, itemsMap.getOrDefault(holder, 0) + stack.m_41613_());
        }
        block1: for (i = 0; i < target.m_6643_(); ++i) {
            ItemStack targetStack = target.m_8020_(i);
            for (Map.Entry entry : itemsMap.entrySet()) {
                StackHolder stack = (StackHolder)entry.getKey();
                int neededCount = (Integer)entry.getValue();
                if (!stack.areEqual(targetStack)) continue;
                int count = targetStack.m_41613_();
                if (count >= neededCount) {
                    itemsMap.put(stack, 0);
                    continue block1;
                }
                itemsMap.put(stack, neededCount - count);
                continue block1;
            }
        }
        Iterator iterator = itemsMap.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean removeItems(Container target, Container items) {
        int i;
        HashMap<StackHolder, Integer> itemsMap = new HashMap<StackHolder, Integer>();
        for (i = 0; i < items.m_6643_(); ++i) {
            ItemStack stack = items.m_8020_(i);
            if (stack.m_41619_()) continue;
            StackHolder holder = new StackHolder(stack);
            itemsMap.put(holder, itemsMap.getOrDefault(holder, 0) + stack.m_41613_());
        }
        block1: for (i = 0; i < target.m_6643_(); ++i) {
            ItemStack targetStack = target.m_8020_(i);
            for (Map.Entry entry : itemsMap.entrySet()) {
                StackHolder stack = (StackHolder)entry.getKey();
                int neededCount = (Integer)entry.getValue();
                if (!stack.areEqual(targetStack)) continue;
                int count = targetStack.m_41613_();
                if (count >= neededCount) {
                    targetStack.m_41774_(neededCount);
                    itemsMap.put(stack, 0);
                    continue block1;
                }
                itemsMap.put(stack, neededCount - count);
                targetStack.m_41764_(0);
            }
        }
        Iterator iterator = itemsMap.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean canFitItems(Container inventory, Container in, Container out) {
        return InventoryUtil.removeItems(inventory = InventoryUtil.copy(inventory), out) && InventoryUtil.insertItems(inventory, in);
    }

    public static boolean insertItems(Container inventory, Container insert) {
        for (int i = 0; i < insert.m_6643_(); ++i) {
            ItemStack insertStack = insert.m_8020_(i);
            if (insertStack == null || InventoryUtil.tryAddItemToInventory(inventory, insertStack.m_41777_())) continue;
            return false;
        }
        return true;
    }

    private static boolean tryAddItemToInventory(Container inventory, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (inventoryStack != null && !ItemStack.m_150942_((ItemStack)inventoryStack, (ItemStack)stack) || stack.m_41741_() - (inventoryStack != null ? inventoryStack.m_41613_() : 0) <= 0) continue;
            int countToAdd = Math.min(stack.m_41613_(), stack.m_41741_() - (inventoryStack != null ? inventoryStack.m_41613_() : 0));
            if (inventoryStack == null) {
                inventory.m_6836_(i, stack.m_41777_());
            } else {
                inventoryStack.m_41769_(countToAdd);
            }
            stack.m_41774_(countToAdd);
            if (stack.m_41613_() != 0) continue;
            return true;
        }
        if (inventory instanceof Inventory) {
            Inventory playerInventory = (Inventory)inventory;
            playerInventory.m_150079_(stack);
            return true;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            inventory.m_6836_(i, stack);
            return true;
        }
        return false;
    }

    public static Container copy(Container another) {
        SimpleContainer inventory = new SimpleContainer(another.m_6643_());
        for (int i = 0; i < another.m_6643_(); ++i) {
            inventory.m_6836_(i, another.m_8020_(i).m_41777_());
        }
        return inventory;
    }

    public record StackHolder(Item item, @Nullable CompoundTag nbt) {
        public StackHolder(ItemStack stack) {
            this(stack.m_41720_(), stack.m_41783_());
        }

        public boolean areEqual(ItemStack stack) {
            return stack.m_150930_(this.item) && Objects.equals(stack.m_41783_(), this.nbt);
        }
    }
}

