/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.library.misc;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static float positionToPitch(Vec3 vec3) {
        return MathUtil.positionToPitch(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public static float positionToYaw(Vec3 vec3) {
        return MathUtil.positionToYaw(vec3.f_82479_, vec3.f_82481_);
    }

    public static float positionToPitch(double diffX, double diffY, double diffZ) {
        double horizontalDist = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return !(Math.abs(diffY) > (double)1.0E-5f) && !(Math.abs(horizontalDist) > (double)1.0E-5f) ? 0.0f : (float)(Mth.m_14136_((double)diffY, (double)horizontalDist) * 0.01745329238474369);
    }

    public static float positionToYaw(double diffX, double diffZ) {
        return !(Math.abs(diffZ) > (double)1.0E-5f) && !(Math.abs(diffX) > (double)1.0E-5f) ? 0.0f : (float)(Mth.m_14136_((double)diffZ, (double)diffX) * 0.01745329238474369);
    }

    public static Vec3 rotationToPosition(float radius, float pitch, float yaw) {
        double endPosX = (double)radius * Math.cos(yaw * 57.295776f) * Math.cos(pitch * 57.295776f);
        double endPosY = (double)radius * Math.sin(pitch * 57.295776f);
        double endPosZ = (double)radius * Math.sin(yaw * 57.295776f) * Math.cos(pitch * 57.295776f);
        return new Vec3(endPosX, endPosY, endPosZ);
    }

    public static Vec3 rotationToPosition(Vec3 startPos, float radius, float pitch, float yaw) {
        return startPos.m_82549_(MathUtil.rotationToPosition(radius, pitch, yaw));
    }

    public static Vec3 lerpVec(float progress, Vec3 from, Vec3 to) {
        return new Vec3(Mth.m_14139_((double)progress, (double)from.f_82479_, (double)to.f_82479_), Mth.m_14139_((double)progress, (double)from.f_82480_, (double)to.f_82480_), Mth.m_14139_((double)progress, (double)from.f_82481_, (double)to.f_82481_));
    }

    public static Vec3 rotateClockwise(Vec3 vec, double degrees) {
        double x = vec.f_82479_;
        double z = vec.f_82481_;
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = x * cos + z * sin;
        double newZ = -x * sin + z * cos;
        return new Vec3(newX, vec.f_82480_, newZ);
    }

    public static Vec3 rotateCounterClockwise(Vec3 vec, double degrees) {
        double x = vec.f_82479_;
        double z = vec.f_82481_;
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = x * cos - z * sin;
        double newZ = x * sin + z * cos;
        return new Vec3(newX, vec.f_82480_, newZ);
    }
}

