package dev.thomasglasser.bundleweight.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.thomasglasser.bundleweight.BundleWeight;
import dev.thomasglasser.tommylib.api.registration.DeferredHolder;
import dev.thomasglasser.tommylib.api.registration.DeferredRegister;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.apache.commons.lang3.math.Fraction;

public class BundleWeightDataComponents {
    public static final DeferredRegister<class_9331<?>> DATA_COMPONENTS = DeferredRegister.create(class_7924.field_49659, BundleWeight.MOD_ID);

    /**
     * Codecs for the {@link Fraction} class.
     */
    private static final Codec<Fraction> FRACTION_CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Codec.INT.fieldOf("numerator").forGetter(Fraction::getNumerator),
            Codec.INT.fieldOf("denominator").forGetter(Fraction::getDenominator)).apply(instance, Fraction::getFraction));
    private static final class_9139<ByteBuf, Fraction> FRACTION_STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675, Fraction::getNumerator,
            class_9135.field_49675, Fraction::getDenominator,
            Fraction::getFraction);

    /**
     * Used to determine the weight of an item in a bundle separately from the stack size.
     */
    public static final DeferredHolder<class_9331<?>, class_9331<Fraction>> BUNDLE_WEIGHT = DATA_COMPONENTS.register("bundle_weight", () -> class_9331.<Fraction>method_57873().method_57881(FRACTION_CODEC).method_57882(FRACTION_STREAM_CODEC).method_57880());

    public static void init() {}
}
