package dev.thomasglasser.bundleweight.mixin.minecraft.world.item.component;

import dev.thomasglasser.bundleweight.api.BundleWeightDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_9276.class)
public class BundleContentsMixin {
    @Inject(method = "getWeight", at = @At("HEAD"), cancellable = true)
    private static void getWeight(class_1799 stack, CallbackInfoReturnable<Fraction> cir) {
        Fraction bundleWeight = stack.method_58694(BundleWeightDataComponents.BUNDLE_WEIGHT.get());
        if (bundleWeight != null) {
            class_9276 bundleContents = stack.method_58694(class_9334.field_49650);
            if (bundleContents != null) {
                cir.setReturnValue(bundleWeight.add(bundleContents.method_57428()));
            } else {
                cir.setReturnValue(bundleWeight);
            }
        }
    }
}
