/*
 * Decompiled with CFR 0.152.
 */
package dev.thomasglasser.bundleweight.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.thomasglasser.tommylib.api.registration.DeferredHolder;
import dev.thomasglasser.tommylib.api.registration.DeferredRegister;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import org.apache.commons.lang3.math.Fraction;

public class BundleWeightDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"bundleweight");
    private static final StreamCodec<ByteBuf, Fraction> FRACTION_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Fraction::getNumerator, (StreamCodec)ByteBufCodecs.VAR_INT, Fraction::getDenominator, Fraction::getFraction);
    private static final Codec<Fraction> DIRECT_FRACTION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("numerator").forGetter(Fraction::getNumerator), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("denominator").forGetter(Fraction::getDenominator)).apply((Applicative)instance, Fraction::getFraction));
    private static final Codec<Fraction> VALIDATED_FRACTION_CODEC = DIRECT_FRACTION_CODEC.validate(fraction -> {
        double value = fraction.doubleValue();
        if (value < 0.0 || value > 1.0) {
            return DataResult.error(() -> "Fraction must be between 0 and 1 inclusive.");
        }
        return DataResult.success((Object)fraction);
    });
    private static final Codec<Fraction> FRACTION_OR_DOUBLE_CODEC = Codec.withAlternative(VALIDATED_FRACTION_CODEC, (Codec)Codec.doubleRange((double)0.0, (double)1.0).xmap(Fraction::getFraction, Fraction::doubleValue));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Fraction>> BUNDLE_WEIGHT = DATA_COMPONENTS.register("bundle_weight", () -> DataComponentType.builder().persistent(FRACTION_OR_DOUBLE_CODEC).networkSynchronized(FRACTION_STREAM_CODEC).build());

    public static void init() {
    }
}

