/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class FurnaceBlockEntityMixin {
    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void serverTick(ServerLevel level, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity blockEntity, CallbackInfo ci) {
        ItemStack stack = blockEntity.getItem(0);
        Direction dir = (Direction)state.getValue((Property)AbstractFurnaceBlock.FACING);
        if (level.getServer().getWorldData().getLevelName().equals("Renovating Villager Houses") || level.getServer().getWorldData().getLevelName().equals("Traps")) {
            return;
        }
        if (stack.is(Items.BEDROCK)) {
            blockEntity.setItem(0, Items.AIR.getDefaultInstance());
            level.setBlockAndUpdate(pos.relative(dir.getOpposite()), Blocks.COBBLESTONE_STAIRS.withPropertiesOf(state));
            level.setBlockAndUpdate(pos, Blocks.COBBLESTONE.defaultBlockState());
        }
        if (stack.is(Items.STRUCTURE_VOID)) {
            blockEntity.setItem(0, Items.AIR.getDefaultInstance());
            level.setBlockAndUpdate(pos.relative(dir.getOpposite()), Blocks.OAK_STAIRS.withPropertiesOf(state));
            level.setBlockAndUpdate(pos, Blocks.COBBLESTONE.defaultBlockState());
        }
        if (stack.is(Items.STRUCTURE_BLOCK)) {
            blockEntity.setItem(0, Items.AIR.getDefaultInstance());
            level.setBlockAndUpdate(pos.relative(dir.getOpposite()), Blocks.OAK_STAIRS.withPropertiesOf(state));
            level.setBlockAndUpdate(pos, Blocks.OAK_PLANKS.defaultBlockState());
        }
        if (stack.is(Items.JIGSAW)) {
            blockEntity.setItem(0, Items.AIR.getDefaultInstance());
            level.setBlockAndUpdate(pos, (BlockState)Blocks.OBSERVER.withPropertiesOf(state).setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)AbstractFurnaceBlock.FACING))));
        }
        if (stack.is(Items.BARRIER)) {
            blockEntity.setItem(0, Items.AIR.getDefaultInstance());
            level.setBlockAndUpdate(pos, Blocks.TORCH.defaultBlockState());
        }
    }
}

