/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.SavedDataHorror;
import com.mars.serversidehorror.ServersideHorrorConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
CommandSource,
AutoCloseable {
    @Shadow
    private int f_129766_;
    @Shadow
    @Final
    private RandomSource f_129758_;
    @Unique
    private static int last_torch_breaking = 0;
    @Unique
    private static int last_torch_replaced = 0;
    @Unique
    private static int last_fake_block_broken = 0;
    @Unique
    private static int last_fake_block_stepped_on = 0;

    @Shadow
    public abstract PlayerList m_6846_();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Inject(at={@At(value="HEAD")}, method={"tickServer"})
    private void tickServer(BooleanSupplier hasTimeLeft, CallbackInfo info) {
        List<String> playerNames;
        MinecraftServer self = (MinecraftServer)this;
        Iterator<Map.Entry<ServerPlayer, Integer>> lifeTimeIt = CommonClass.FAKE_PLAYERS.entrySet().iterator();
        while (lifeTimeIt.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = lifeTimeIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                CommonClass.removeFakePlayer(self, fake);
                lifeTimeIt.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
        Iterator<Map.Entry<ServerPlayer, Integer>> joinerIt = CommonClass.FAKE_JOINERS.entrySet().iterator();
        while (joinerIt.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = joinerIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                CommonClass.removeFakeJoiner(self, fake);
                joinerIt.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
        Iterator<Map.Entry<ServerPlayer, Object[]>> talkerIt = CommonClass.FAKE_JOINERS_TALKERS.entrySet().iterator();
        while (talkerIt.hasNext()) {
            Map.Entry<ServerPlayer, Object[]> entry = talkerIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = (Integer)entry.getValue()[1] - 1;
            String msg = (String)entry.getValue()[0];
            if (ticksLeft <= 0) {
                self.m_6846_().m_243049_(PlayerChatMessage.m_247306_((String)msg), fake, ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)fake));
                talkerIt.remove();
                continue;
            }
            entry.setValue(new Object[]{msg, ticksLeft});
        }
        if (!CommonClass.TORCHES_TO_BE_BROKEN.isEmpty()) {
            if (last_torch_breaking == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextTorch = CommonClass.TORCHES_TO_BE_BROKEN.entrySet().iterator().next();
                ServerLevel level = nextTorch.getValue().m_284548_();
                BlockPos target = nextTorch.getKey();
                level.m_46961_(target, true);
                CommonClass.TORCHES_TO_BE_BROKEN.remove(target);
                last_torch_breaking = 10;
            } else {
                --last_torch_breaking;
            }
        }
        if (!CommonClass.TORCHES_TO_BE_REPLACED.isEmpty()) {
            if (last_torch_replaced == 0) {
                BlockPos target;
                Map.Entry<BlockPos, ServerPlayer> nextTorch = CommonClass.TORCHES_TO_BE_REPLACED.entrySet().iterator().next();
                ServerLevel level = nextTorch.getValue().m_284548_();
                if (level.m_8055_(target = nextTorch.getKey()).m_60713_(Blocks.f_50082_)) {
                    level.m_7731_(target, Blocks.f_50123_.m_152465_(level.m_8055_(target)), 3);
                } else {
                    level.m_7731_(target, Blocks.f_50174_.m_49966_(), 3);
                }
                level.m_5594_(null, target, SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 0.8f);
                CommonClass.TORCHES_TO_BE_REPLACED.remove(target);
                last_torch_replaced = 10;
            } else {
                --last_torch_replaced;
            }
        }
        if (!CommonClass.BLOCKS_TO_BE_MINED_FAKE.isEmpty()) {
            if (last_fake_block_broken == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextBlock = CommonClass.BLOCKS_TO_BE_MINED_FAKE.entrySet().iterator().next();
                BlockPos target = nextBlock.getKey();
                ServerLevel level = nextBlock.getValue().m_284548_();
                level.m_5594_(null, target, level.m_8055_(target).m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                CommonClass.BLOCKS_TO_BE_MINED_FAKE.remove(target);
                last_fake_block_broken = 10;
            } else {
                --last_fake_block_broken;
            }
        }
        if (!CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.isEmpty()) {
            if (last_fake_block_stepped_on == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextBlock = CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.entrySet().iterator().next();
                BlockPos target = nextBlock.getKey();
                ServerLevel level = nextBlock.getValue().m_284548_();
                level.m_5594_(null, target, level.m_8055_(target).m_60827_().m_56776_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.remove(target);
                last_fake_block_stepped_on = 7;
            } else {
                --last_fake_block_stepped_on;
            }
        }
        for (ServerPlayer real : this.m_6846_().m_11314_()) {
            for (ServerPlayer fake : CommonClass.FAKE_PLAYERS.keySet()) {
                if (!MinecraftServerMixin.isLookingAt(real, fake) || CommonClass.FAKE_PLAYERS.get(fake) <= 10) continue;
                CommonClass.FAKE_PLAYERS.put(fake, 10);
            }
        }
        if (!CommonClass.isGracePeriodUp(self.m_129783_())) {
            return;
        }
        if (ServersideHorrorConfig.fake_joiner_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.fake_joiner_chance)) {
            playerNames = CommonClass.getSeenPlayers(self);
            playerNames.removeAll(List.of(self.m_6846_().m_11291_()));
            if (!playerNames.isEmpty()) {
                CommonClass.addFakeJoiner(self, playerNames.get(this.f_129758_.m_188503_(playerNames.size())), true);
            }
        }
        if (ServersideHorrorConfig.random_fake_joiner_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.random_fake_joiner_chance)) {
            playerNames = CommonClass.getSeenPlayers(self);
            playerNames.removeAll(List.of(self.m_6846_().m_11291_()));
            String[] name_msg = ServersideHorrorConfig.random_fake_joiner_list.get(this.f_129758_.m_188503_(ServersideHorrorConfig.random_fake_joiner_list.size())).split(";");
            CommonClass.addFakeJoiner(self, name_msg[0], name_msg[this.f_129758_.m_216339_(1, name_msg.length)]);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"logChatMessage"})
    private void logChatMessage(Component content, ChatType.Bound boundChatType, String header, CallbackInfo ci) {
        try {
            DimensionDataStorage storage = ((MinecraftServer)this).m_129783_().m_8895_();
            SavedDataHorror savedData = (SavedDataHorror)storage.m_164861_(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
            savedData.addMessage(content.getString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isLookingAt(ServerPlayer real, ServerPlayer fake) {
        Vec3 vec3 = real.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(fake.m_20185_() - real.m_20185_(), fake.m_20188_() - real.m_20188_(), fake.m_20189_() - real.m_20189_());
        double distanceBetween = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 1.5 / distanceBetween && real.m_142582_((Entity)fake);
    }
}

