/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.ServersideHorrorConfig;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Unique
    private double lastX;
    @Unique
    private double lastY;
    @Unique
    private double lastZ;
    @Unique
    private double lastLastX;
    @Unique
    private double lastLastY;
    @Unique
    private double lastLastZ;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        if (CommonClass.isGracePeriodUp(self.m_284548_())) {
            if (ServersideHorrorConfig.herobrine_starer_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.herobrine_starer_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.spawnFakePlayer(self, "MarsThePlanet_", 40, true);
            }
            if (ServersideHorrorConfig.starer_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.starer_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                String fakeName = ServersideHorrorConfig.starer_list.get(CommonClass.random.m_188503_(ServersideHorrorConfig.starer_list.size()));
                CommonClass.spawnFakePlayer(self, fakeName, 40, false);
            }
            if (ServersideHorrorConfig.jumpscare_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.jumpscare_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.TO_BE_JUMP_SCARED.add(self);
            }
            if (ServersideHorrorConfig.break_torches_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.break_torches_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.breakTorches(self, 10, 30);
            }
            if (ServersideHorrorConfig.replace_torches_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.replace_torches_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.replaceTorches(self, 30, 60);
            }
            if (ServersideHorrorConfig.random_lightning_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.random_lightning_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.TO_BE_HIT_BY_LIGHTNING.add(self);
            }
            if (ServersideHorrorConfig.fake_mining_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.fake_mining_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.fakeMining(self);
            }
            if (ServersideHorrorConfig.fake_steps_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.fake_steps_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.fakeSteps(self);
            }
            if (ServersideHorrorConfig.setting_up_new_traps_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.setting_up_new_traps_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.placeSmallTrap(self);
            }
            if (ServersideHorrorConfig.removing_leaves_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.removing_leaves_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.removeLeaves(self, 100, 30);
            }
            if (ServersideHorrorConfig.random_signs_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.random_signs_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.placeSign(self, 30, 10);
            }
            if (ServersideHorrorConfig.heads_from_list_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.heads_from_list_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.placeHead(self, ServersideHorrorConfig.heads_from_list_list.get(CommonClass.random.m_188503_(ServersideHorrorConfig.heads_from_list_list.size() - 1)), 30, 10);
            }
            if (ServersideHorrorConfig.scary_sound_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.scary_sound_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                CommonClass.playScarySound(self, 16);
            }
            if (ServersideHorrorConfig.random_heads_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.random_heads_chance) && !CommonClass.FAKE_PLAYERS.containsKey(self)) {
                List<String> playerNames = CommonClass.getSeenPlayers(self.m_20194_());
                CommonClass.placeHead(self, playerNames.get(CommonClass.random.m_188503_(playerNames.size() - 1)), 30, 10);
            }
        }
        if (CommonClass.TO_BE_HIT_BY_LIGHTNING.contains(self) && CommonClass.hitPlayerLightning(self)) {
            CommonClass.TO_BE_HIT_BY_LIGHTNING.remove(self);
        }
        double x = self.m_20185_();
        double y = self.m_20186_();
        double z = self.m_20189_();
        if (x - this.lastX == 0.0 && y - this.lastY == 0.0 && z - this.lastZ == 0.0 && this.lastLastX - this.lastX == 0.0 && this.lastLastY - this.lastY == 0.0 && this.lastLastZ - this.lastZ == 0.0 && CommonClass.TO_BE_JUMP_SCARED.contains(self)) {
            CommonClass.particleJumpScare(self);
            CommonClass.TO_BE_JUMP_SCARED.remove(self);
        }
        this.lastLastX = this.lastX;
        this.lastLastY = this.lastY;
        this.lastLastZ = this.lastZ;
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="TAIL")})
    private void stopSleepInBed(boolean wakeImmediately, boolean updateLevelForSleepingPlayers, CallbackInfo ci) {
        if (wakeImmediately || !ServersideHorrorConfig.burn_down_house_enable || !CommonClass.chanceOneIn(ServersideHorrorConfig.burn_down_house_chance_per_wake_up)) {
            return;
        }
        ServerPlayer self = (ServerPlayer)this;
        CommonClass.startFire(self, 8);
        CommonClass.spawnFakePlayer(self, "MarsThePlanet_", 20, true);
    }
}

