/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class SavedDataHorror
extends SavedData {
    private List<String> player_messages;
    private boolean long_night;
    public static final Codec<SavedDataHorror> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("long_night").forGetter(SavedDataHorror::getLongNight), (App)Codec.STRING.listOf().fieldOf("player_messages").forGetter(SavedDataHorror::getPlayerMessages)).apply((Applicative)builder, SavedDataHorror::new));
    public static final SavedDataType<SavedDataHorror> TYPE = new SavedDataType("saved_data_horror", SavedDataHorror::new, CODEC, null);

    public SavedDataHorror() {
        this(false, new ArrayList<String>());
    }

    public SavedDataHorror(boolean long_night, List<String> player_messages) {
        this.long_night = long_night;
        this.player_messages = new ArrayList<String>(player_messages);
    }

    public static SavedDataHorror get(MinecraftServer server) {
        ServerLevel overworld = server.overworld();
        DimensionDataStorage storage = overworld.getDataStorage();
        SavedDataHorror data = (SavedDataHorror)storage.computeIfAbsent(TYPE);
        return data;
    }

    public void addMessage(String msg) {
        if (!this.player_messages.contains(msg)) {
            this.player_messages.add(msg);
            this.setDirty();
        }
    }

    public void setPlayerMessages(List<String> value) {
        this.player_messages = new ArrayList<String>(value);
        this.setDirty();
    }

    public boolean getLongNight() {
        return this.long_night;
    }

    public void setLongNight(boolean value) {
        this.long_night = value;
        this.setDirty();
    }

    public List<String> getPlayerMessages() {
        return this.player_messages;
    }
}

