/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.SavedDataHorror;
import com.mars.serversidehorror.ServersideHorrorConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
ChunkIOErrorReporter,
CommandSource,
AutoCloseable {
    @Shadow
    private int tickCount;
    @Shadow
    @Final
    private RandomSource random;
    @Unique
    private static int last_torch_breaking = 0;
    @Unique
    private static int last_torch_replaced = 0;
    @Unique
    private static int last_fake_block_broken = 0;
    @Unique
    private static int last_fake_block_stepped_on = 0;

    @Shadow
    public abstract PlayerList getPlayerList();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Inject(at={@At(value="HEAD")}, method={"tickServer"})
    private void tickServer(BooleanSupplier hasTimeLeft, CallbackInfo info) {
        List<String> playerNames;
        MinecraftServer self = (MinecraftServer)this;
        Iterator<Map.Entry<ServerPlayer, Integer>> lifeTimeIt = CommonClass.FAKE_PLAYERS.entrySet().iterator();
        while (lifeTimeIt.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = lifeTimeIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                CommonClass.removeFakePlayer(self, fake);
                lifeTimeIt.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
        Iterator<Map.Entry<ServerPlayer, Integer>> joinerIt = CommonClass.FAKE_JOINERS.entrySet().iterator();
        while (joinerIt.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = joinerIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                CommonClass.removeFakeJoiner(self, fake);
                joinerIt.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
        Iterator<Map.Entry<ServerPlayer, Object[]>> talkerIt = CommonClass.FAKE_JOINERS_TALKERS.entrySet().iterator();
        while (talkerIt.hasNext()) {
            Map.Entry<ServerPlayer, Object[]> entry = talkerIt.next();
            ServerPlayer fake = entry.getKey();
            int ticksLeft = (Integer)entry.getValue()[1] - 1;
            String msg = (String)entry.getValue()[0];
            if (ticksLeft <= 0) {
                self.getPlayerList().broadcastChatMessage(PlayerChatMessage.system((String)msg), fake, ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)fake));
                talkerIt.remove();
                continue;
            }
            entry.setValue(new Object[]{msg, ticksLeft});
        }
        if (!CommonClass.TORCHES_TO_BE_BROKEN.isEmpty()) {
            if (last_torch_breaking == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextTorch = CommonClass.TORCHES_TO_BE_BROKEN.entrySet().iterator().next();
                ServerLevel level = nextTorch.getValue().serverLevel();
                BlockPos target = nextTorch.getKey();
                level.destroyBlock(target, true);
                CommonClass.TORCHES_TO_BE_BROKEN.remove(target);
                last_torch_breaking = 10;
            } else {
                --last_torch_breaking;
            }
        }
        if (!CommonClass.TORCHES_TO_BE_REPLACED.isEmpty()) {
            if (last_torch_replaced == 0) {
                BlockPos target;
                Map.Entry<BlockPos, ServerPlayer> nextTorch = CommonClass.TORCHES_TO_BE_REPLACED.entrySet().iterator().next();
                ServerLevel level = nextTorch.getValue().serverLevel();
                if (level.getBlockState(target = nextTorch.getKey()).is(Blocks.WALL_TORCH)) {
                    level.setBlock(target, Blocks.REDSTONE_WALL_TORCH.withPropertiesOf(level.getBlockState(target)), 3);
                } else {
                    level.setBlock(target, Blocks.REDSTONE_TORCH.defaultBlockState(), 3);
                }
                level.playSound(null, target, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f);
                CommonClass.TORCHES_TO_BE_REPLACED.remove(target);
                last_torch_replaced = 10;
            } else {
                --last_torch_replaced;
            }
        }
        if (!CommonClass.BLOCKS_TO_BE_MINED_FAKE.isEmpty()) {
            if (last_fake_block_broken == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextBlock = CommonClass.BLOCKS_TO_BE_MINED_FAKE.entrySet().iterator().next();
                BlockPos target = nextBlock.getKey();
                ServerLevel level = nextBlock.getValue().serverLevel();
                level.playSound(null, target, level.getBlockState(target).getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                CommonClass.BLOCKS_TO_BE_MINED_FAKE.remove(target);
                last_fake_block_broken = 10;
            } else {
                --last_fake_block_broken;
            }
        }
        if (!CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.isEmpty()) {
            if (last_fake_block_stepped_on == 0) {
                Map.Entry<BlockPos, ServerPlayer> nextBlock = CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.entrySet().iterator().next();
                BlockPos target = nextBlock.getKey();
                ServerLevel level = nextBlock.getValue().serverLevel();
                level.playSound(null, target, level.getBlockState(target).getSoundType().getStepSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                CommonClass.BLOCKS_TO_BE_STEPPED_ON_FAKE.remove(target);
                last_fake_block_stepped_on = 7;
            } else {
                --last_fake_block_stepped_on;
            }
        }
        for (ServerPlayer real : this.getPlayerList().getPlayers()) {
            for (ServerPlayer fake : CommonClass.FAKE_PLAYERS.keySet()) {
                if (!MinecraftServerMixin.isLookingAt(real, fake) || CommonClass.FAKE_PLAYERS.get(fake) <= 10) continue;
                CommonClass.FAKE_PLAYERS.put(fake, 10);
            }
        }
        if (!CommonClass.isGracePeriodUp(self.overworld())) {
            return;
        }
        if (ServersideHorrorConfig.fake_joiner_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.fake_joiner_chance)) {
            playerNames = CommonClass.getSeenPlayers(self);
            playerNames.removeAll(List.of(self.getPlayerList().getPlayerNamesArray()));
            if (!playerNames.isEmpty()) {
                CommonClass.addFakeJoiner(self, playerNames.get(this.random.nextInt(playerNames.size())), true);
            }
        }
        if (ServersideHorrorConfig.random_fake_joiner_enable && CommonClass.chanceOneIn(ServersideHorrorConfig.random_fake_joiner_chance)) {
            playerNames = CommonClass.getSeenPlayers(self);
            playerNames.removeAll(List.of(self.getPlayerList().getPlayerNamesArray()));
            String[] name_msg = ServersideHorrorConfig.random_fake_joiner_list.get(this.random.nextInt(ServersideHorrorConfig.random_fake_joiner_list.size())).split(";");
            CommonClass.addFakeJoiner(self, name_msg[0], name_msg[this.random.nextInt(1, name_msg.length)]);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"logChatMessage"})
    private void logChatMessage(Component content, ChatType.Bound boundChatType, String header, CallbackInfo ci) {
        try {
            DimensionDataStorage storage = ((MinecraftServer)this).overworld().getDataStorage();
            SavedDataHorror savedData = (SavedDataHorror)storage.computeIfAbsent(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
            savedData.addMessage(content.getString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isLookingAt(ServerPlayer real, ServerPlayer fake) {
        Vec3 vec3 = real.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(fake.getX() - real.getX(), fake.getEyeY() - real.getEyeY(), fake.getZ() - real.getZ());
        double distanceBetween = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 1.5 / distanceBetween && real.hasLineOfSight((Entity)fake);
    }
}

