/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.ServersideHorrorConfig;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class StructureMixin {
    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void generate(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, CallbackInfoReturnable<StructureStart> cir) {
        Holder.Direct direct = new Holder.Direct((Object)this);
        ResourceLocation structureID = registryAccess.registryOrThrow(Registries.STRUCTURE).getKey((Object)((Structure)direct.value()));
        if (!ServersideHorrorConfig.old_villages_enable && structureID.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"serversidehorror", (String)"village_old_plains"))) {
            cir.setReturnValue((Object)StructureStart.INVALID_START);
        }
        if (structureID.getPath().contains("traps/trap_")) {
            if (ServersideHorrorConfig.grace_period_applies_to_traps) {
                if (CommonClass.currentLevel == null) {
                    cir.setReturnValue((Object)StructureStart.INVALID_START);
                } else if (!CommonClass.isGracePeriodUp(CommonClass.currentLevel)) {
                    cir.setReturnValue((Object)StructureStart.INVALID_START);
                }
            }
            if (!ServersideHorrorConfig.traps_enable) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        }
    }
}

