/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mars.deimos.config.DeimosConfig;
import com.mars.serversidehorror.Constants;
import com.mars.serversidehorror.SavedDataHorror;
import com.mars.serversidehorror.ServersideHorrorConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public class CommonClass {
    public static Map<ServerPlayer, Integer> FAKE_PLAYERS = new HashMap<ServerPlayer, Integer>();
    public static Map<ServerPlayer, Integer> FAKE_JOINERS = new HashMap<ServerPlayer, Integer>();
    public static Map<ServerPlayer, Object[]> FAKE_JOINERS_TALKERS = new HashMap<ServerPlayer, Object[]>();
    public static List<ServerPlayer> TO_BE_JUMP_SCARED = new ArrayList<ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> TORCHES_TO_BE_BROKEN = new HashMap<BlockPos, ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> TORCHES_TO_BE_REPLACED = new HashMap<BlockPos, ServerPlayer>();
    public static List<ServerPlayer> TO_BE_HIT_BY_LIGHTNING = new ArrayList<ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> BLOCKS_TO_BE_MINED_FAKE = new HashMap<BlockPos, ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> BLOCKS_TO_BE_STEPPED_ON_FAKE = new HashMap<BlockPos, ServerPlayer>();
    public static ServerLevel currentLevel;
    public static RandomSource random;

    public static void init() {
        DeimosConfig.init((String)"serversidehorror", ServersideHorrorConfig.class);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addFakeJoiner").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"fakesName", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String fakesName = StringArgumentType.getString((CommandContext)ctx, (String)"fakesName");
            CommonClass.addFakeJoiner(((CommandSourceStack)ctx.getSource()).getServer(), fakesName, false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Added fake player " + fakesName)), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnFakePlayer").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"fakesName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"hideNametag", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            String fakesName = StringArgumentType.getString((CommandContext)ctx, (String)"fakesName");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            boolean hideNametag = BoolArgumentType.getBool((CommandContext)ctx, (String)"hideNametag");
            targets.forEach(target -> CommonClass.spawnFakePlayer(target, fakesName, radius, hideNametag));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Spawned fake player " + fakesName)), true);
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnFakePlayer").requires(src -> src.hasPermission(2))).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 40, true));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Spawned Herobrine near players"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hitPlayerLightning").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            TO_BE_HIT_BY_LIGHTNING.addAll(targets);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Struck players with lightning"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"particleJumpScare").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            TO_BE_JUMP_SCARED.addAll(targets);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Jump-scared players"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setLongNight").requires(src -> src.hasPermission(2))).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
            ServerLevel level = server.overworld();
            SavedDataHorror savedData = SavedDataHorror.get(server);
            savedData.setLongNight(true);
            level.setDayTime(17999L);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Set Long Night"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"breakTorches").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            targets.forEach(target -> CommonClass.breakTorches(target, minRadius, maxRadius));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Broke torches near players"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"replaceTorches").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            targets.forEach(target -> CommonClass.replaceTorches(target, minRadius, maxRadius));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Replaced torches near players with redstone torches"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakeMining").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.fakeMining(target));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Players will hear fake mining noises"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakeSteps").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.fakeSteps(target));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Players will hear fake footsteps"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setupNewTrap").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.placeSmallTrap(target));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"A new trap will be be set up near these players"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"startRandomFire").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            targets.forEach(target -> CommonClass.startFire(target, radius));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"A random fire will be started near these players"), true);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeLeaves").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            targets.forEach(target -> CommonClass.removeLeaves(target, maxRadius, minRadius));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Leaves will be removed around players"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"placeSign").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            for (ServerPlayer target : targets) {
                boolean canPlace = CommonClass.placeSign(target, maxRadius, minRadius);
                if (canPlace) {
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Placed a sign near player " + target.getName().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Couldn't place a sign near player " + target.getName().getString())), true);
            }
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"placeHead").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            for (ServerPlayer target : targets) {
                boolean canPlace = CommonClass.placeHead(target, name, maxRadius, minRadius);
                if (canPlace) {
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Placed a head near player " + target.getName().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Couldn't place head near player " + target.getName().getString())), true);
            }
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"playScarySound").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            for (ServerPlayer target : targets) {
                boolean didPlay = CommonClass.playScarySound(target, radius);
                if (didPlay) {
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Played a scary sound near player " + target.getName().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Couldn't play a scary sound because the scary_sound_list config is empty"), true);
            }
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resetMessages").requires(src -> src.hasPermission(2))).executes(ctx -> {
            SavedDataHorror savedData = SavedDataHorror.get(((CommandSourceStack)ctx.getSource()).getServer());
            savedData.setPlayerMessages(new ArrayList<String>());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reset all messages"), true);
            return 1;
        }));
    }

    public static void particleJumpScare(ServerPlayer target) {
        ServerLevel level = target.level();
        Vec3 eyePos = target.getEyePosition(1.0f);
        Vec3 forward = target.getLookAngle().normalize();
        Vec3 right = forward.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 up = right.cross(forward).normalize();
        float spacing = 0.15f;
        double distance = 1.1;
        float width = 7.0f * spacing * 0.5f;
        float height = 7.0f * spacing * 0.5f;
        Vec3 basePos = eyePos.add(forward.scale(distance));
        float[][][] herobrineFace = new float[][][]{new float[][]{{0.18f, 0.122f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.18f, 0.114f, 0.047f}, {0.153f, 0.102f, 0.024f}, {0.133f, 0.082f, 0.012f}, {0.145f, 0.098f, 0.024f}, {0.165f, 0.11f, 0.035f}, {0.161f, 0.11f, 0.035f}}, new float[][]{{0.165f, 0.11f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.192f, 0.133f, 0.059f}, {0.259f, 0.161f, 0.059f}, {0.247f, 0.161f, 0.075f}, {0.169f, 0.11f, 0.035f}, {0.153f, 0.102f, 0.024f}}, new float[][]{{0.165f, 0.11f, 0.035f}, {0.714f, 0.537f, 0.42f}, {0.741f, 0.557f, 0.443f}, {0.776f, 0.588f, 0.502f}, {0.741f, 0.545f, 0.443f}, {0.741f, 0.557f, 0.455f}, {0.675f, 0.463f, 0.353f}, {0.196f, 0.141f, 0.059f}}, new float[][]{{0.667f, 0.49f, 0.4f}, {0.706f, 0.518f, 0.424f}, {0.667f, 0.49f, 0.4f}, {0.678f, 0.502f, 0.424f}, {0.612f, 0.443f, 0.361f}, {0.733f, 0.537f, 0.443f}, {0.612f, 0.412f, 0.298f}, {0.612f, 0.412f, 0.298f}}, new float[][]{{0.706f, 0.518f, 0.424f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.71f, 0.482f, 0.404f}, {0.733f, 0.537f, 0.443f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.667f, 0.49f, 0.4f}}, new float[][]{{0.612f, 0.388f, 0.278f}, {0.702f, 0.482f, 0.384f}, {0.718f, 0.51f, 0.443f}, {0.412f, 0.247f, 0.184f}, {0.412f, 0.247f, 0.184f}, {0.745f, 0.533f, 0.42f}, {0.635f, 0.412f, 0.278f}, {0.502f, 0.325f, 0.196f}}, new float[][]{{0.565f, 0.369f, 0.263f}, {0.588f, 0.373f, 0.247f}, {0.255f, 0.125f, 0.035f}, {0.541f, 0.298f, 0.235f}, {0.541f, 0.298f, 0.235f}, {0.271f, 0.125f, 0.035f}, {0.561f, 0.369f, 0.239f}, {0.506f, 0.325f, 0.22f}}, new float[][]{{0.431f, 0.271f, 0.169f}, {0.424f, 0.263f, 0.161f}, {0.255f, 0.125f, 0.035f}, {0.259f, 0.11f, 0.024f}, {0.271f, 0.125f, 0.035f}, {0.271f, 0.125f, 0.035f}, {0.514f, 0.333f, 0.227f}, {0.478f, 0.306f, 0.192f}}};
        ArrayList<Vec3> eyes = new ArrayList<Vec3>();
        level.playSound(null, target.getOnPos(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.AMBIENT, 1.0f, 1.0f);
        for (int i = 0; i < 50; ++i) {
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 8; ++x) {
                    DustParticleOptions dust = new DustParticleOptions(CommonClass.rgbToInt(herobrineFace[y][x]), 1.0f);
                    float offsetX = (float)x * spacing - width;
                    float offsetY = height - (float)y * spacing;
                    Vec3 pos = basePos.add(right.scale((double)offsetX)).add(up.scale((double)offsetY));
                    level.sendParticles((ParticleOptions)dust, false, false, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
                    if (herobrineFace[y][x][0] != 1.0f) continue;
                    eyes.add(pos);
                }
            }
        }
        for (Vec3 eye : eyes) {
            DustParticleOptions dust = new DustParticleOptions(0xFFFFFF, 1.0f);
            level.sendParticles((ParticleOptions)dust, false, false, eye.x, eye.y, eye.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean addFakeJoiner(MinecraftServer server, String name, boolean canBeTalker) {
        if (server == null) {
            return false;
        }
        List playerList = server.getPlayerList().getPlayers();
        if (playerList.isEmpty()) {
            return false;
        }
        MutableComponent joinMsg = Component.translatable((String)"multiplayer.player.joined", (Object[])new Object[]{name});
        server.getPlayerList().broadcastSystemMessage((Component)joinMsg.copy().withStyle(ChatFormatting.YELLOW), false);
        String[] skin = CommonClass.getSkin(name);
        GameProfile profile = CommonClass.makeProfileWithSkin(name, skin[0], skin[1]);
        ServerPlayer fake = new ServerPlayer(server, server.overworld(), profile, ((ServerPlayer)playerList.getFirst()).clientInformation());
        fake.connection = new ServerGamePacketListenerImpl(server, new Connection(PacketFlow.SERVERBOUND), fake, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)false));
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        ClientboundPlayerInfoUpdatePacket updateList = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED, fake);
        server.getPlayerList().broadcastAll((Packet)addInfo);
        server.getPlayerList().broadcastAll((Packet)updateList);
        int lifeTime = random.nextInt(600, 60000);
        FAKE_JOINERS.put(fake, lifeTime);
        SavedDataHorror savedData = SavedDataHorror.get(server);
        if (canBeTalker && random.nextBoolean() && !savedData.getPlayerMessages().isEmpty()) {
            FAKE_JOINERS_TALKERS.put(fake, new Object[]{savedData.getPlayerMessages().get(random.nextInt(savedData.getPlayerMessages().size() - 1)), random.nextInt(1, lifeTime - 1)});
        }
        return true;
    }

    public static boolean addFakeJoiner(MinecraftServer server, String name, String msg) {
        if (server == null) {
            return false;
        }
        List playerList = server.getPlayerList().getPlayers();
        if (playerList.isEmpty()) {
            return false;
        }
        MutableComponent joinMsg = Component.translatable((String)"multiplayer.player.joined", (Object[])new Object[]{name});
        server.getPlayerList().broadcastSystemMessage((Component)joinMsg.copy().withStyle(ChatFormatting.YELLOW), false);
        String[] skin = CommonClass.getSkin(name);
        GameProfile profile = CommonClass.makeProfileWithSkin(name, skin[0], skin[1]);
        ServerPlayer fake = new ServerPlayer(server, server.overworld(), profile, ((ServerPlayer)server.getPlayerList().getPlayers().getFirst()).clientInformation());
        fake.connection = new ServerGamePacketListenerImpl(server, new Connection(PacketFlow.SERVERBOUND), fake, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)false));
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        ClientboundPlayerInfoUpdatePacket updateList = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED, fake);
        server.getPlayerList().broadcastAll((Packet)addInfo);
        server.getPlayerList().broadcastAll((Packet)updateList);
        int lifeTime = random.nextInt(600, 60000);
        FAKE_JOINERS.put(fake, lifeTime);
        FAKE_JOINERS_TALKERS.put(fake, new Object[]{msg, random.nextInt(1, lifeTime - 1)});
        return true;
    }

    public static void removeFakeJoiner(MinecraftServer server, ServerPlayer fake) {
        MutableComponent leftMsg = Component.translatable((String)"multiplayer.player.left", (Object[])new Object[]{fake.getName()});
        server.getPlayerList().broadcastSystemMessage((Component)leftMsg.copy().withStyle(ChatFormatting.YELLOW), false);
        ClientboundPlayerInfoRemovePacket removeInfo = new ClientboundPlayerInfoRemovePacket(List.of(fake.getUUID()));
        server.getPlayerList().broadcastAll((Packet)removeInfo);
    }

    public static void spawnFakePlayer(ServerPlayer target, String name, int radius, boolean hideNameTag) {
        Optional<BlockPos> spawnOpt;
        MinecraftServer server = target.level().getServer();
        if (server == null) {
            return;
        }
        ServerLevel level = target.level();
        String[] skin = CommonClass.getSkin(name);
        GameProfile profile = CommonClass.makeProfileWithSkin(name, skin[0], skin[1]);
        ServerPlayer fake = new ServerPlayer(server, level, profile, target.clientInformation());
        if (hideNameTag) {
            ServerScoreboard scoreboard = level.getScoreboard();
            PlayerTeam hideTagTeam = scoreboard.getPlayerTeam("noTags");
            if (hideTagTeam == null) {
                hideTagTeam = scoreboard.addPlayerTeam("noTags");
                hideTagTeam.setNameTagVisibility(Team.Visibility.NEVER);
            }
            scoreboard.addPlayerToTeam(name, hideTagTeam);
        }
        if (!(spawnOpt = CommonClass.findValidSpawnPos(level, fake, target, radius, true)).isPresent()) {
            Constants.LOG.info("couldn't find a valid location to spawn a fake entity");
            return;
        }
        BlockPos spawnPos = spawnOpt.get();
        double spawnX = (double)spawnPos.getX() + 0.5;
        double spawnY = spawnPos.getY();
        double spawnZ = (double)spawnPos.getZ() + 0.5;
        double d0 = target.getX() - spawnX;
        double d1 = target.getY() - spawnY;
        double d2 = target.getZ() - spawnZ;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float xRot = Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 180.0 / 3.1415927410125732))));
        float yRot = Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f));
        fake.absSnapTo(spawnX, spawnY, spawnZ);
        fake.setXRot(xRot);
        fake.setYRot(yRot);
        fake.setYHeadRot(yRot);
        fake.connection = new ServerGamePacketListenerImpl(server, new Connection(PacketFlow.SERVERBOUND), fake, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)false));
        ServerEntity wrapper = CommonClass.getServerEntity(target, level, fake);
        int lifeTime = 24000;
        FAKE_PLAYERS.put(fake, lifeTime);
        ClientboundAddEntityPacket spawnPacket = (ClientboundAddEntityPacket)fake.getAddEntityPacket(wrapper);
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        server.getPlayerList().broadcastAll((Packet)addInfo);
        server.getPlayerList().broadcastAll((Packet)spawnPacket);
        List values = fake.getEntityData().getNonDefaultValues();
        if (values != null && !values.isEmpty()) {
            server.getPlayerList().broadcastAll((Packet)new ClientboundSetEntityDataPacket(fake.getId(), values));
        }
    }

    public static void removeFakePlayer(MinecraftServer server, ServerPlayer fake) {
        ClientboundPlayerInfoRemovePacket removeInfo = new ClientboundPlayerInfoRemovePacket(List.of(fake.getUUID()));
        ClientboundRemoveEntitiesPacket removeEntity = new ClientboundRemoveEntitiesPacket(new int[]{fake.getId()});
        fake.remove(Entity.RemovalReason.DISCARDED);
        server.getPlayerList().broadcastAll((Packet)removeEntity);
        server.getPlayerList().broadcastAll((Packet)removeInfo);
    }

    public static void breakTorches(ServerPlayer target, int minRange, int maxRange) {
        ServerLevel level = target.level();
        BlockPos playerPos = target.getOnPos();
        List<BlockPos> torches = CommonClass.getTorchesInRadius(target, playerPos, level, minRange, maxRange);
        if (torches.isEmpty()) {
            return;
        }
        BlockPos targetedTorch = torches.get(random.nextInt(torches.size()));
        TORCHES_TO_BE_BROKEN.put(targetedTorch, target);
        List<BlockPos> targetedTorches = CommonClass.getTorchesInRadius(target, targetedTorch, level, 0, 15);
        targetedTorches.forEach(pos -> TORCHES_TO_BE_BROKEN.put((BlockPos)pos, target));
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
    }

    public static void replaceTorches(ServerPlayer target, int minRange, int maxRange) {
        ServerLevel level = target.level();
        BlockPos playerPos = target.getOnPos();
        List<BlockPos> torches = CommonClass.getTorchesInRadius(target, playerPos, level, minRange, maxRange);
        if (torches.isEmpty()) {
            return;
        }
        BlockPos targetedTorch = torches.get(random.nextInt(torches.size()));
        TORCHES_TO_BE_REPLACED.put(targetedTorch, target);
        List<BlockPos> targetedTorches = CommonClass.getTorchesInRadius(target, targetedTorch, level, 0, 15);
        targetedTorches.forEach(pos -> TORCHES_TO_BE_REPLACED.put((BlockPos)pos, target));
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
    }

    public static boolean hitPlayerLightning(ServerPlayer target) {
        ServerLevel level = target.level();
        if (!level.canSeeSky(target.blockPosition())) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level, EntitySpawnReason.EVENT);
        lightningbolt.snapTo(Vec3.atBottomCenterOf((Vec3i)target.blockPosition()));
        level.addFreshEntity((Entity)lightningbolt);
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
        return true;
    }

    public static void fakeMining(ServerPlayer target) {
        ServerLevel level = target.level();
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        int radius = 10;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.getOnPos().offset(dx, dy, dz);
                    if (level.isEmptyBlock(candidate) || level.isEmptyBlock(candidate.above()) || level.isEmptyBlock(candidate.below()) || level.isEmptyBlock(candidate.west()) || level.isEmptyBlock(candidate.east()) || level.isEmptyBlock(candidate.north()) || level.isEmptyBlock(candidate.south()) || candidate.distToCenterSqr(target.getX(), target.getY(), target.getZ()) < 11.0) continue;
                    validPos.add(candidate);
                }
            }
        }
        if (validPos.isEmpty()) {
            return;
        }
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos.MutableBlockPos pos = ((BlockPos)validPos.get(random.nextInt(validPos.size()))).mutable();
        for (int i = 0; i < random.nextInt(10); ++i) {
            pos.move(dir);
            BLOCKS_TO_BE_MINED_FAKE.put(new BlockPos((Vec3i)pos), target);
            BLOCKS_TO_BE_MINED_FAKE.put(new BlockPos((Vec3i)pos.above()), target);
        }
    }

    public static void fakeSteps(ServerPlayer target) {
        ServerLevel level = target.level();
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        int radius = 10;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.getOnPos().offset(dx, dy, dz);
                    if (!level.isEmptyBlock(candidate) || !level.isEmptyBlock(candidate.above()) || !level.isEmptyBlock(candidate.below()) || candidate.distToCenterSqr(target.getX(), target.getY(), target.getZ()) < 4.0) continue;
                    validPos.add(candidate);
                }
            }
        }
        if (validPos.isEmpty()) {
            return;
        }
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos.MutableBlockPos pos = ((BlockPos)validPos.get(random.nextInt(validPos.size()))).mutable();
        for (int i = 0; i < random.nextInt(20); ++i) {
            pos.move(dir);
            BLOCKS_TO_BE_STEPPED_ON_FAKE.put(new BlockPos((Vec3i)pos), target);
        }
    }

    public static void joinOnBedrock(ServerPlayer target, ServerGamePacketListenerImpl listener) {
        MinecraftServer server = target.level().getServer();
        BlockPos playerPos = new BlockPos((int)target.getX(), 319, (int)target.getZ());
        server.overworld().setBlockAndUpdate(playerPos, Blocks.BEDROCK.defaultBlockState());
        listener.teleport((double)((int)target.getX()) + 0.5, 320.0, (double)((int)target.getZ()) + 0.5, target.getYRot(), target.getXRot());
    }

    public static void placeSmallTrap(ServerPlayer target) {
        MinecraftServer server = target.level().getServer();
        ServerLevel level = target.level();
        StructureTemplateManager manager = server.getStructureManager();
        Optional optionalTemplate = manager.get(ResourceLocation.fromNamespaceAndPath((String)"serversidehorror", (String)("small_traps/trap_" + random.nextInt(1, 5))));
        if (optionalTemplate.isEmpty()) {
            return;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().setMirror(Mirror.NONE).setFinalizeEntities(true).setIgnoreEntities(false);
        StructureTemplate template = (StructureTemplate)optionalTemplate.get();
        CommonClass.findPlacement(level, target.blockPosition(), template, settings, 80, target).ifPresent(origin -> template.placeInWorld((ServerLevelAccessor)level, origin, origin, settings, random, 3));
    }

    public static void startFire(ServerPlayer target, int radius) {
        ServerLevel level = target.level();
        Optional<BlockPos> targetPos = CommonClass.findBurnablePos(target, level, radius);
        if (targetPos.isEmpty()) {
            return;
        }
        BlockPos pos = targetPos.get();
        level.setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos));
        level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void joinInDungeon(ServerPlayer target, ServerGamePacketListenerImpl listener) {
        MinecraftServer server = target.level().getServer();
        ServerLevel level = target.level();
        StructureTemplateManager manager = server.getStructureManager();
        Optional optionalTemplate = manager.get(ResourceLocation.fromNamespaceAndPath((String)"serversidehorror", (String)"rejoin_dungeon"));
        if (optionalTemplate.isEmpty()) {
            return;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().setMirror(Mirror.NONE).setFinalizeEntities(true).setIgnoreEntities(false);
        StructureTemplate template = (StructureTemplate)optionalTemplate.get();
        CommonClass.findPlacementRejoinDungeon(level, target.blockPosition(), template, settings, 80).ifPresent(origin -> {
            template.placeInWorld((ServerLevelAccessor)level, origin, origin, settings, random, 3);
            listener.teleport((double)origin.getX() + 2.5, -58.0, (double)origin.getZ() + 2.5, target.getYRot(), target.getXRot());
        });
    }

    public static void removeLeaves(ServerPlayer target, int maxRadius, int minRadius) {
        ServerLevel level = target.level();
        BlockPos playerPos = target.getOnPos();
        BlockPos aMax = playerPos.offset(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.offset(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.betweenClosed((BlockPos)aMax, (BlockPos)bMax);
        for (BlockPos pos : allBlocksInRadius) {
            BlockState state;
            if (pos.closerToCenterThan((Position)playerPos.getCenter(), (double)minRadius) || !(level.getBlockState(pos).getBlock() instanceof LeavesBlock) || ((Boolean)(state = level.getBlockState(pos)).getValue((net.minecraft.world.level.block.state.properties.Property)LeavesBlock.PERSISTENT)).booleanValue()) continue;
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public static boolean placeSign(ServerPlayer target, int maxRadius, int minRadius) {
        ServerLevel level = target.level();
        BlockPos playerPos = target.getOnPos();
        BlockPos aMax = playerPos.offset(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.offset(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.betweenClosed((BlockPos)aMax, (BlockPos)bMax);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : allBlocksInRadius) {
            if (pos.closerToCenterThan((Position)playerPos.getCenter(), (double)minRadius) || CommonClass.canSeeBlock(target, pos) || !level.isEmptyBlock(pos) || !level.getFluidState(pos).isEmpty() || !level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) continue;
            candidates.add(new BlockPos((Vec3i)pos));
        }
        if (candidates.isEmpty()) {
            return false;
        }
        BlockPos finalPos = (BlockPos)candidates.get(random.nextInt(candidates.size()));
        level.setBlockAndUpdate(finalPos, (BlockState)Blocks.OAK_SIGN.defaultBlockState().setValue((net.minecraft.world.level.block.state.properties.Property)StandingSignBlock.ROTATION, (Comparable)Integer.valueOf(random.nextInt(16))));
        BlockEntity blockEntity = level.getBlockEntity(finalPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            String randomSignText = ServersideHorrorConfig.random_signs_texts.get(random.nextInt(ServersideHorrorConfig.random_signs_texts.size()));
            String[] lines = randomSignText.split("\\r?\\n");
            SignText text = sign.getText(true).setMessage(0, (Component)Component.literal((String)lines[0])).setMessage(1, (Component)Component.literal((String)lines[1])).setMessage(2, (Component)Component.literal((String)lines[2])).setMessage(3, (Component)Component.literal((String)lines[3]));
            sign.setText(text, true);
            sign.setChanged();
            level.sendBlockUpdated(finalPos, sign.getBlockState(), sign.getBlockState(), 3);
        }
        return true;
    }

    public static boolean placeHead(ServerPlayer target, String name, int maxRadius, int minRadius) {
        ServerLevel level = target.level();
        BlockPos playerPos = target.getOnPos();
        BlockPos aMax = playerPos.offset(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.offset(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.betweenClosed((BlockPos)aMax, (BlockPos)bMax);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : allBlocksInRadius) {
            if (pos.closerToCenterThan((Position)playerPos.getCenter(), (double)minRadius) || CommonClass.canSeeBlock(target, pos) || !level.isEmptyBlock(pos) || !level.getFluidState(pos).isEmpty() || !level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) continue;
            candidates.add(new BlockPos((Vec3i)pos));
        }
        if (candidates.isEmpty()) {
            return false;
        }
        BlockPos finalPos = (BlockPos)candidates.get(random.nextInt(candidates.size()));
        level.setBlockAndUpdate(finalPos, (BlockState)Blocks.PLAYER_HEAD.defaultBlockState().setValue((net.minecraft.world.level.block.state.properties.Property)SkullBlock.ROTATION, (Comparable)Integer.valueOf(random.nextInt(16))));
        BlockEntity blockEntity = level.getBlockEntity(finalPos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity head = (SkullBlockEntity)blockEntity;
            String[] skin = CommonClass.getSkin(name);
            GameProfile gameProfile = CommonClass.makeProfileWithSkin(name, skin[0], skin[1]);
            ResolvableProfile profile = ResolvableProfile.createResolved((GameProfile)gameProfile);
            ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            stack.set(DataComponents.PROFILE, (Object)profile);
            head.applyComponentsFromItemStack(stack);
            head.setChanged();
            level.setBlockEntity((BlockEntity)head);
        }
        return true;
    }

    public static boolean playScarySound(ServerPlayer target, int radius) {
        ServerLevel level = target.level();
        List<String> soundNamesList = ServersideHorrorConfig.scary_sound_list;
        if (soundNamesList.isEmpty()) {
            return false;
        }
        String soundName = soundNamesList.get(random.nextInt(soundNamesList.size() - 1));
        SoundEvent scarySound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)soundName));
        BlockPos soundPos = target.getOnPos().offset(random.nextInt(-radius, radius), random.nextInt(-radius, radius), random.nextInt(-radius, radius));
        level.playSound(null, soundPos, scarySound, SoundSource.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    @NotNull
    private static ServerEntity getServerEntity(ServerPlayer target, ServerLevel level, ServerPlayer fake) {
        final ServerGamePacketListenerImpl conn = target.connection;
        ServerEntity wrapper = new ServerEntity(level, (Entity)fake, 0, false, new ServerEntity.Synchronizer(){

            public void sendToTrackingPlayers(Packet<? super ClientGamePacketListener> packet) {
                conn.send(packet);
            }

            public void sendToTrackingPlayersAndSelf(Packet<? super ClientGamePacketListener> packet) {
                this.sendToTrackingPlayers(packet);
            }

            public void sendToTrackingPlayersFiltered(Packet<? super ClientGamePacketListener> packet, Predicate<ServerPlayer> predicate) {
                if (predicate.test(conn.getPlayer())) {
                    this.sendToTrackingPlayers(packet);
                }
            }
        });
        return wrapper;
    }

    static GameProfile makeProfileWithSkin(String name, String valueB64, String signature) {
        UUID id = UUID.randomUUID();
        ArrayListMultimap mm = ArrayListMultimap.create();
        mm.put((Object)"textures", (Object)new Property("textures", valueB64, signature));
        PropertyMap props = new PropertyMap((Multimap)mm);
        try {
            Constructor c = GameProfile.class.getDeclaredConstructor(UUID.class, String.class, PropertyMap.class);
            return (GameProfile)c.newInstance(id, name, props);
        }
        catch (NoSuchMethodException e) {
            try {
                GameProfile gp = new GameProfile(id, name);
                Field f = GameProfile.class.getDeclaredField("properties");
                f.setAccessible(true);
                f.set(gp, props);
                return gp;
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to apply skin to GameProfile", ex);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to construct GameProfile", e);
        }
    }

    public static boolean chanceOneIn(int denominator) {
        return random.nextInt(denominator) == 0;
    }

    public static boolean isGracePeriodUp(ServerLevel level) {
        return level.getLevelData().getGameTime() > (long)ServersideHorrorConfig.grace_period * 24000L;
    }

    public static boolean canSeeBlock(ServerPlayer player, BlockPos pos) {
        ClipContext ctx;
        ServerLevel world = player.level();
        BlockHitResult result = world.clip(ctx = new ClipContext(player.getEyePosition(), Vec3.atCenterOf((Vec3i)pos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (result.getType() == HitResult.Type.MISS) {
            return true;
        }
        if (result.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        return result.getBlockPos().equals((Object)pos);
    }

    private static String[] getSkin(String name) {
        try {
            URL profileUrl = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            InputStreamReader inputStreamReaderProfile = new InputStreamReader(profileUrl.openStream());
            String uuid = new JsonParser().parse((Reader)inputStreamReaderProfile).getAsJsonObject().get("id").getAsString();
            URL userSession = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            InputStreamReader inputStreamReaderSession = new InputStreamReader(userSession.openStream());
            JsonObject property = new JsonParser().parse((Reader)inputStreamReaderSession).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            return new String[]{property.get("value").getAsString(), property.get("signature").getAsString()};
        }
        catch (Exception e) {
            Constants.LOG.info("Couldn't find player{}, the fake player is going to use the default skin", (Object)name);
            Constants.LOG.warn(String.valueOf(e));
            return CommonClass.getSkin("IceBreak");
        }
    }

    public static List<BlockPos> getTorchesInRadius(ServerPlayer player, BlockPos centre, ServerLevel level, int minRange, int maxRange) {
        ArrayList<BlockPos> torches = new ArrayList<BlockPos>();
        BlockPos aMax = centre.offset(-maxRange, -maxRange, -maxRange);
        BlockPos bMax = centre.offset(maxRange, maxRange, maxRange);
        Iterable allBlocksInRange = BlockPos.betweenClosed((BlockPos)aMax, (BlockPos)bMax);
        for (BlockPos pos : allBlocksInRange) {
            if (!level.getBlockState(pos).is(Blocks.TORCH) && !level.getBlockState(pos).is(Blocks.WALL_TORCH) || pos.closerThan(new Vec3i(centre.getX(), centre.getY(), centre.getZ()), (double)minRange) || CommonClass.canSeeBlock(player, pos)) continue;
            torches.add(new BlockPos((Vec3i)pos));
        }
        return torches;
    }

    private static Optional<BlockPos> findValidSpawnPos(ServerLevel level, ServerPlayer fake, ServerPlayer target, int radius, boolean lineOfSight) {
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.getOnPos().offset(dx, dy, dz);
                    if (!level.isEmptyBlock(candidate) || !level.isEmptyBlock(candidate.above()) || !level.getBlockState(candidate.below()).canOcclude() || target.getOnPos() == candidate || target.getOnPos().east() == candidate || target.getOnPos().north() == candidate || target.getOnPos().south() == candidate || target.getOnPos().west() == candidate) continue;
                    fake.setPos((double)candidate.getX(), (double)candidate.getY(), (double)candidate.getZ());
                    if (lineOfSight != fake.hasLineOfSight((Entity)target)) continue;
                    valid.add(candidate);
                }
            }
        }
        if (valid.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((BlockPos)valid.get(random.nextInt(valid.size())));
    }

    private static Optional<BlockPos> findPlacement(ServerLevel level, BlockPos around, StructureTemplate template, StructurePlaceSettings settings, int radiusBlocks, ServerPlayer player) {
        BoundingBox boxAtZero = template.getBoundingBox(settings, BlockPos.ZERO);
        int sizeX = boxAtZero.getXSpan();
        int sizeY = boxAtZero.getYSpan();
        int sizeZ = boxAtZero.getZSpan();
        ServerChunkCache chunkSource = level.getChunkSource();
        for (int r = radiusBlocks; r >= 0; --r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dzRing1 = r;
                int dzRing2 = -r;
                if (CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dx, around.getZ() + dzRing1, sizeX, sizeZ, sizeY, player).isPresent()) {
                    return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dx, around.getZ() + dzRing1, sizeX, sizeZ, sizeY, player);
                }
                if (!CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dx, around.getZ() + dzRing2, sizeX, sizeZ, sizeY, player).isPresent()) continue;
                return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dx, around.getZ() + dzRing2, sizeX, sizeZ, sizeY, player);
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                int dxRing1 = r;
                int dxRing2 = -r;
                if (CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dxRing1, around.getZ() + dz, sizeX, sizeZ, sizeY, player).isPresent()) {
                    return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dxRing1, around.getZ() + dz, sizeX, sizeZ, sizeY, player);
                }
                if (!CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dxRing2, around.getZ() + dz, sizeX, sizeZ, sizeY, player).isPresent()) continue;
                return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.getX() + dxRing2, around.getZ() + dz, sizeX, sizeZ, sizeY, player);
            }
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> tryCandidate(ServerLevel level, ChunkSource chunkSource, int cornerX, int cornerZ, int sizeX, int sizeZ, int sizeY, ServerPlayer player) {
        int x;
        int minChunkX = cornerX >> 4;
        int minChunkZ = cornerZ >> 4;
        int maxChunkX = cornerX + sizeX - 1 >> 4;
        int maxChunkZ = cornerZ + sizeZ - 1 >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                LevelChunk chk = chunkSource.getChunkNow(cx, cz);
                if (chk != null) continue;
                return Optional.empty();
            }
        }
        Integer flatGroundY = null;
        for (int x2 = 0; x2 < sizeX; ++x2) {
            for (int z = 0; z < sizeZ; ++z) {
                int worldX = cornerX + x2;
                int worldZ = cornerZ + z;
                int topY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ) - 1;
                if (flatGroundY == null) {
                    flatGroundY = topY;
                    continue;
                }
                if (topY == flatGroundY) continue;
                return Optional.empty();
            }
        }
        if (flatGroundY == null) {
            return Optional.empty();
        }
        int originY = flatGroundY + 1;
        BlockPos origin = new BlockPos(cornerX, originY, cornerZ);
        if (CommonClass.canSeeBlock(player, origin) || CommonClass.canSeeBlock(player, origin.above())) {
            return Optional.empty();
        }
        for (x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                BlockPos supportPos = new BlockPos(cornerX + x, flatGroundY.intValue(), cornerZ + z);
                BlockState support = level.getBlockState(supportPos);
                if (!support.isAir() && support.isFaceSturdy((BlockGetter)level, supportPos, Direction.UP)) continue;
                return Optional.empty();
            }
        }
        for (x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos p = new BlockPos(cornerX + x, originY + y, cornerZ + z);
                    if (!level.isInWorldBounds(p)) {
                        return Optional.empty();
                    }
                    if (level.getBlockState(p).isAir()) continue;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(origin);
    }

    private static Optional<BlockPos> findPlacementRejoinDungeon(ServerLevel level, BlockPos around, StructureTemplate template, StructurePlaceSettings settings, int radiusBlocks) {
        BoundingBox boxAtZero = template.getBoundingBox(settings, BlockPos.ZERO);
        int sizeX = boxAtZero.getXSpan();
        int sizeY = boxAtZero.getYSpan();
        int sizeZ = boxAtZero.getZSpan();
        for (int r = 0; r <= radiusBlocks; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dzRing1 = r;
                int dzRing2 = -r;
                if (CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dx, around.getZ() + dzRing1, sizeX, sizeZ, sizeY).isPresent()) {
                    return CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dx, around.getZ() + dzRing1, sizeX, sizeZ, sizeY);
                }
                if (!CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dx, around.getZ() + dzRing2, sizeX, sizeZ, sizeY).isPresent()) continue;
                return CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dx, around.getZ() + dzRing2, sizeX, sizeZ, sizeY);
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                int dxRing1 = r;
                int dxRing2 = -r;
                if (CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dxRing1, around.getZ() + dz, sizeX, sizeZ, sizeY).isPresent()) {
                    return CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dxRing1, around.getZ() + dz, sizeX, sizeZ, sizeY);
                }
                if (!CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dxRing2, around.getZ() + dz, sizeX, sizeZ, sizeY).isPresent()) continue;
                return CommonClass.tryCandidateRejoinDungeon(level, around.getX() + dxRing2, around.getZ() + dz, sizeX, sizeZ, sizeY);
            }
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> tryCandidateRejoinDungeon(ServerLevel level, int cornerX, int cornerZ, int sizeX, int sizeZ, int sizeY) {
        int originY = -59;
        BlockPos origin = new BlockPos(cornerX, originY, cornerZ);
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos p = new BlockPos(cornerX + x, originY + y, cornerZ + z);
                    if (!level.isInWorldBounds(p)) {
                        return Optional.empty();
                    }
                    if (level.getBlockState(p).is(Blocks.DEEPSLATE)) continue;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(origin);
    }

    private static Optional<BlockPos> findBurnablePos(ServerPlayer target, ServerLevel level, int radius) {
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.getOnPos().offset(dx, dy, dz);
                    BlockState state = level.getBlockState(candidate);
                    if (!state.isAir() || !CommonClass.hasFlammableNeighbours((LevelReader)level, candidate) || CommonClass.canSeeBlock(target, candidate)) continue;
                    valid.add(candidate);
                }
            }
        }
        if (valid.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((BlockPos)valid.get(random.nextInt(valid.size())));
    }

    private static boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!CommonClass.isFlammable(level, pos.relative(direction))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlammable(LevelReader level, BlockPos pos) {
        return (pos.getY() < level.getMinY() || pos.getY() >= level.getMaxY() || level.hasChunkAt(pos)) && level.getBlockState(pos).ignitedByLava();
    }

    public static int rgbToInt(float[] rgb) {
        int r = Math.round(rgb[0] * 255.0f) & 0xFF;
        int g = Math.round(rgb[1] * 255.0f) & 0xFF;
        int b = Math.round(rgb[2] * 255.0f) & 0xFF;
        return r << 16 | g << 8 | b;
    }

    static {
        random = RandomSource.create();
    }
}

