/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mars.deimos.config.DeimosConfig;
import com.mars.serversidehorror.Constants;
import com.mars.serversidehorror.SavedDataHorror;
import com.mars.serversidehorror.ServersideHorrorConfig;
import com.mars.serversidehorror.mixin.PlayerAccessor;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.joml.Vector3f;

public class CommonClass {
    public static Map<ServerPlayer, Integer> FAKE_PLAYERS = new HashMap<ServerPlayer, Integer>();
    public static Map<ServerPlayer, Integer> FAKE_JOINERS = new HashMap<ServerPlayer, Integer>();
    public static Map<ServerPlayer, Object[]> FAKE_JOINERS_TALKERS = new HashMap<ServerPlayer, Object[]>();
    public static List<ServerPlayer> TO_BE_JUMP_SCARED = new ArrayList<ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> TORCHES_TO_BE_BROKEN = new HashMap<BlockPos, ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> TORCHES_TO_BE_REPLACED = new HashMap<BlockPos, ServerPlayer>();
    public static List<ServerPlayer> TO_BE_HIT_BY_LIGHTNING = new ArrayList<ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> BLOCKS_TO_BE_MINED_FAKE = new HashMap<BlockPos, ServerPlayer>();
    public static Map<BlockPos, ServerPlayer> BLOCKS_TO_BE_STEPPED_ON_FAKE = new HashMap<BlockPos, ServerPlayer>();
    public static ServerLevel currentLevel;
    public static RandomSource random;

    public static void init() {
        DeimosConfig.init((String)"serversidehorror", ServersideHorrorConfig.class);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addFakeJoiner").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"fakesName", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String fakesName = StringArgumentType.getString((CommandContext)ctx, (String)"fakesName");
            CommonClass.addFakeJoiner(((CommandSourceStack)ctx.getSource()).m_81377_(), fakesName, false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added fake player " + fakesName)), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnFakePlayer").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"fakesName", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"hideNametag", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            String fakesName = StringArgumentType.getString((CommandContext)ctx, (String)"fakesName");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            boolean hideNametag = BoolArgumentType.getBool((CommandContext)ctx, (String)"hideNametag");
            targets.forEach(target -> CommonClass.spawnFakePlayer(target, fakesName, radius, hideNametag));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Spawned fake player " + fakesName)), true);
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnFakePlayer").requires(src -> src.m_6761_(2))).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 40, true));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Spawned Herobrine near players"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hitPlayerLightning").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            TO_BE_HIT_BY_LIGHTNING.addAll(targets);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Struck players with lightning"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"particleJumpScare").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            TO_BE_JUMP_SCARED.addAll(targets);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Jump-scared players"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setLongNight").requires(src -> src.m_6761_(2))).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            ServerLevel level = server.m_129783_();
            DimensionDataStorage storage = level.m_8895_();
            SavedDataHorror savedData = (SavedDataHorror)storage.m_164861_(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
            savedData.setLongNight(true);
            level.m_8615_(17999L);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Set Long Night"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"breakTorches").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            targets.forEach(target -> CommonClass.breakTorches(target, minRadius, maxRadius));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Broke torches near players"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"replaceTorches").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            targets.forEach(target -> CommonClass.replaceTorches(target, minRadius, maxRadius));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Replaced torches near players with redstone torches"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fakeMining").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.fakeMining(target));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Players will hear fake mining noises"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fakeSteps").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.fakeSteps(target));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Players will hear fake footsteps"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setupNewTrap").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            targets.forEach(target -> CommonClass.placeSmallTrap(target));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"A new trap will be be set up near these players"), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"startRandomFire").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            targets.forEach(target -> CommonClass.startFire(target, radius));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"A random fire will be started near these players"), true);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removeLeaves").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            targets.forEach(target -> CommonClass.removeLeaves(target, maxRadius, minRadius));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Leaves will be removed around players"), true);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"placeSign").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            for (ServerPlayer target : targets) {
                boolean canPlace = CommonClass.placeSign(target, maxRadius, minRadius);
                if (canPlace) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Placed a sign near player " + target.m_7755_().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Couldn't place a sign near player " + target.m_7755_().getString())), true);
            }
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"placeHead").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"maxRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int maxRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxRadius");
            int minRadius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius");
            for (ServerPlayer target : targets) {
                boolean canPlace = CommonClass.placeHead(target, name, maxRadius, minRadius);
                if (canPlace) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Placed a head near player " + target.m_7755_().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Couldn't place head near player " + target.m_7755_().getString())), true);
            }
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"playScarySound").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            for (ServerPlayer target : targets) {
                boolean didPlay = CommonClass.playScarySound(target, radius);
                if (didPlay) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Played a scary sound near player " + target.m_7755_().getString())), true);
                    continue;
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Couldn't play a scary sound because the scary_sound_list config is empty"), true);
            }
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"resetMessages").requires(src -> src.m_6761_(2))).executes(ctx -> {
            DimensionDataStorage storage = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129783_().m_8895_();
            SavedDataHorror savedData = (SavedDataHorror)storage.m_164861_(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
            savedData.setPlayerMessages(new ArrayList<String>());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Successfully reset all messages"), true);
            return 1;
        }));
    }

    public static void particleJumpScare(ServerPlayer target) {
        ServerLevel level = target.m_284548_();
        Vec3 eyePos = target.m_20299_(1.0f);
        Vec3 forward = target.m_20154_().m_82541_();
        Vec3 right = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 up = right.m_82537_(forward).m_82541_();
        float spacing = 0.15f;
        double distance = 1.1;
        float width = 7.0f * spacing * 0.5f;
        float height = 7.0f * spacing * 0.5f;
        Vec3 basePos = eyePos.m_82549_(forward.m_82490_(distance));
        float[][][] herobrineFace = new float[][][]{new float[][]{{0.18f, 0.122f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.18f, 0.114f, 0.047f}, {0.153f, 0.102f, 0.024f}, {0.133f, 0.082f, 0.012f}, {0.145f, 0.098f, 0.024f}, {0.165f, 0.11f, 0.035f}, {0.161f, 0.11f, 0.035f}}, new float[][]{{0.165f, 0.11f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.165f, 0.11f, 0.035f}, {0.192f, 0.133f, 0.059f}, {0.259f, 0.161f, 0.059f}, {0.247f, 0.161f, 0.075f}, {0.169f, 0.11f, 0.035f}, {0.153f, 0.102f, 0.024f}}, new float[][]{{0.165f, 0.11f, 0.035f}, {0.714f, 0.537f, 0.42f}, {0.741f, 0.557f, 0.443f}, {0.776f, 0.588f, 0.502f}, {0.741f, 0.545f, 0.443f}, {0.741f, 0.557f, 0.455f}, {0.675f, 0.463f, 0.353f}, {0.196f, 0.141f, 0.059f}}, new float[][]{{0.667f, 0.49f, 0.4f}, {0.706f, 0.518f, 0.424f}, {0.667f, 0.49f, 0.4f}, {0.678f, 0.502f, 0.424f}, {0.612f, 0.443f, 0.361f}, {0.733f, 0.537f, 0.443f}, {0.612f, 0.412f, 0.298f}, {0.612f, 0.412f, 0.298f}}, new float[][]{{0.706f, 0.518f, 0.424f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.71f, 0.482f, 0.404f}, {0.733f, 0.537f, 0.443f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.667f, 0.49f, 0.4f}}, new float[][]{{0.612f, 0.388f, 0.278f}, {0.702f, 0.482f, 0.384f}, {0.718f, 0.51f, 0.443f}, {0.412f, 0.247f, 0.184f}, {0.412f, 0.247f, 0.184f}, {0.745f, 0.533f, 0.42f}, {0.635f, 0.412f, 0.278f}, {0.502f, 0.325f, 0.196f}}, new float[][]{{0.565f, 0.369f, 0.263f}, {0.588f, 0.373f, 0.247f}, {0.255f, 0.125f, 0.035f}, {0.541f, 0.298f, 0.235f}, {0.541f, 0.298f, 0.235f}, {0.271f, 0.125f, 0.035f}, {0.561f, 0.369f, 0.239f}, {0.506f, 0.325f, 0.22f}}, new float[][]{{0.431f, 0.271f, 0.169f}, {0.424f, 0.263f, 0.161f}, {0.255f, 0.125f, 0.035f}, {0.259f, 0.11f, 0.024f}, {0.271f, 0.125f, 0.035f}, {0.271f, 0.125f, 0.035f}, {0.514f, 0.333f, 0.227f}, {0.478f, 0.306f, 0.192f}}};
        ArrayList<Vec3> eyes = new ArrayList<Vec3>();
        level.m_5594_(null, target.m_20097_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.AMBIENT, 1.0f, 1.0f);
        for (int i = 0; i < 50; ++i) {
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 8; ++x) {
                    float r = herobrineFace[y][x][0];
                    float g = herobrineFace[y][x][1];
                    float b = herobrineFace[y][x][2];
                    DustParticleOptions dust = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
                    float offsetX = (float)x * spacing - width;
                    float offsetY = height - (float)y * spacing;
                    Vec3 pos = basePos.m_82549_(right.m_82490_((double)offsetX)).m_82549_(up.m_82490_((double)offsetY));
                    level.m_8624_(target, (ParticleOptions)dust, false, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    if (r != 1.0f) continue;
                    eyes.add(pos);
                }
            }
        }
        for (Vec3 eye : eyes) {
            DustParticleOptions dust = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f);
            level.m_8624_(target, (ParticleOptions)dust, false, eye.f_82479_, eye.f_82480_, eye.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean addFakeJoiner(MinecraftServer server, String name, boolean canBeTalker) {
        List<String> msgs;
        if (server == null) {
            return false;
        }
        List players = server.m_6846_().m_11314_();
        if (players.isEmpty()) {
            return false;
        }
        MutableComponent joinMsg = Component.m_237110_((String)"multiplayer.player.joined", (Object[])new Object[]{name});
        server.m_6846_().m_240416_((Component)joinMsg.m_6881_().m_130940_(ChatFormatting.YELLOW), false);
        ServerLevel level = server.m_129783_();
        GameProfile profile = new GameProfile(UUID.randomUUID(), name);
        String[] skin = CommonClass.getSkin(name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
        ServerPlayer sample = (ServerPlayer)players.get(0);
        ServerPlayer fake = new ServerPlayer(server, level, profile, sample.m_294559_());
        ServerGamePacketListenerImpl savedConn = fake.f_8906_;
        fake.f_8906_ = sample.f_8906_;
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        ClientboundPlayerInfoUpdatePacket updateListed = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED, fake);
        fake.f_8906_ = savedConn;
        server.m_6846_().m_11268_((Packet)addInfo);
        server.m_6846_().m_11268_((Packet)updateListed);
        int lifeTime = random.m_216339_(600, 60000);
        FAKE_JOINERS.put(fake, lifeTime);
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        SavedDataHorror savedData = (SavedDataHorror)storage.m_164861_(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
        if (canBeTalker && random.m_188499_() && !savedData.getPlayerMessages().isEmpty() && !(msgs = savedData.getPlayerMessages()).isEmpty()) {
            String msg = msgs.get(random.m_188503_(msgs.size()));
            int when = random.m_216339_(1, Math.max(2, lifeTime));
            FAKE_JOINERS_TALKERS.put(fake, new Object[]{msg, when});
        }
        return true;
    }

    public static boolean addFakeJoiner(MinecraftServer server, String name, String msg) {
        if (server == null) {
            return false;
        }
        List players = server.m_6846_().m_11314_();
        if (players.isEmpty()) {
            return false;
        }
        MutableComponent joinMsg = Component.m_237110_((String)"multiplayer.player.joined", (Object[])new Object[]{name});
        server.m_6846_().m_240416_((Component)joinMsg.m_6881_().m_130940_(ChatFormatting.YELLOW), false);
        ServerLevel level = server.m_129783_();
        GameProfile profile = new GameProfile(UUID.randomUUID(), name);
        String[] skin = CommonClass.getSkin(name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
        ServerPlayer sample = (ServerPlayer)players.get(0);
        ServerPlayer fake = new ServerPlayer(server, level, profile, sample.m_294559_());
        ServerGamePacketListenerImpl savedConn = fake.f_8906_;
        fake.f_8906_ = sample.f_8906_;
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        ClientboundPlayerInfoUpdatePacket updateListed = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED, fake);
        fake.f_8906_ = savedConn;
        server.m_6846_().m_11268_((Packet)addInfo);
        server.m_6846_().m_11268_((Packet)updateListed);
        int lifeTime = random.m_216339_(600, 60000);
        FAKE_JOINERS.put(fake, lifeTime);
        int when = random.m_216339_(1, lifeTime);
        FAKE_JOINERS_TALKERS.put(fake, new Object[]{msg, when});
        return true;
    }

    public static void removeFakeJoiner(MinecraftServer server, ServerPlayer fake) {
        MutableComponent leftMsg = Component.m_237110_((String)"multiplayer.player.left", (Object[])new Object[]{fake.m_7755_()});
        server.m_6846_().m_240416_((Component)leftMsg.m_6881_().m_130940_(ChatFormatting.YELLOW), false);
        ClientboundPlayerInfoRemovePacket removeInfo = new ClientboundPlayerInfoRemovePacket(List.of(fake.m_20148_()));
        server.m_6846_().m_11268_((Packet)removeInfo);
    }

    public static void spawnFakePlayer(ServerPlayer target, String name, int radius, boolean hideNameTag) {
        Optional<BlockPos> spawnOpt;
        MinecraftServer server = target.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel level = target.m_284548_();
        GameProfile profile = new GameProfile(UUID.randomUUID(), name);
        String[] skin = CommonClass.getSkin(name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
        ServerPlayer fake = new ServerPlayer(server, level, profile, target.m_294559_());
        fake.m_20088_().m_135381_(PlayerAccessor.getDataPlayerModeCustomisation(), (Object)-1);
        if (hideNameTag) {
            ServerScoreboard scoreboard = level.m_6188_();
            PlayerTeam hideTagTeam = scoreboard.m_83489_("noTags");
            if (hideTagTeam == null) {
                hideTagTeam = scoreboard.m_83492_("noTags");
                hideTagTeam.m_83346_(Team.Visibility.NEVER);
            }
            scoreboard.m_6546_(name, hideTagTeam);
        }
        if ((spawnOpt = CommonClass.findValidSpawnPos(level, fake, target, radius, true)).isEmpty()) {
            Constants.LOG.info("couldn't find a valid location to spawn a fake entity");
            return;
        }
        BlockPos p = spawnOpt.get();
        double x = (double)p.m_123341_() + 0.5;
        double y = p.m_123342_();
        double z = (double)p.m_123343_() + 0.5;
        double dx = target.m_20185_() - x;
        double dy = target.m_20186_() - y;
        double dz = target.m_20189_() - z;
        double dHoriz = Math.sqrt(dx * dx + dz * dz);
        float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)dy, (double)dHoriz) * 180.0 / Math.PI))));
        float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f));
        fake.m_20248_(x, y, z);
        fake.m_146926_(xRot);
        fake.m_146922_(yRot);
        fake.m_5616_(yRot);
        ServerGamePacketListenerImpl saved = fake.f_8906_;
        fake.f_8906_ = target.f_8906_;
        ClientboundPlayerInfoUpdatePacket addInfo = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, fake);
        fake.f_8906_ = saved;
        ClientboundAddEntityPacket spawnPacket = new ClientboundAddEntityPacket(fake.m_19879_(), fake.m_20148_(), x, y, z, fake.m_146909_(), fake.m_146908_(), fake.m_6095_(), 0, fake.m_20184_(), (double)fake.m_6080_());
        server.m_6846_().m_11268_((Packet)addInfo);
        server.m_6846_().m_11268_((Packet)spawnPacket);
        ClientboundAddEntityPacket addEntity = new ClientboundAddEntityPacket(fake.m_19879_(), fake.m_20148_(), x, y, z, xRot, yRot, fake.m_6095_(), 0, fake.m_20184_(), (double)fake.m_6080_());
        server.m_6846_().m_11268_((Packet)addInfo);
        server.m_6846_().m_11268_((Packet)addEntity);
        server.m_6846_().m_11268_((Packet)new ClientboundSetEntityDataPacket(fake.m_19879_(), fake.m_20088_().m_135378_()));
        List values = fake.m_20088_().m_252804_();
        if (values != null && !values.isEmpty()) {
            server.m_6846_().m_11268_((Packet)new ClientboundSetEntityDataPacket(fake.m_19879_(), values));
        }
        FAKE_PLAYERS.put(fake, 24000);
    }

    public static void removeFakePlayer(MinecraftServer server, ServerPlayer fake) {
        ClientboundPlayerInfoRemovePacket removeInfo = new ClientboundPlayerInfoRemovePacket(List.of(fake.m_20148_()));
        ClientboundRemoveEntitiesPacket removeEntity = new ClientboundRemoveEntitiesPacket(new int[]{fake.m_19879_()});
        fake.m_142687_(Entity.RemovalReason.DISCARDED);
        server.m_6846_().m_11268_((Packet)removeEntity);
        server.m_6846_().m_11268_((Packet)removeInfo);
    }

    public static void breakTorches(ServerPlayer target, int minRange, int maxRange) {
        ServerLevel level = target.m_284548_();
        BlockPos playerPos = target.m_20097_();
        List<BlockPos> torches = CommonClass.getTorchesInRadius(target, playerPos, level, minRange, maxRange);
        if (torches.isEmpty()) {
            return;
        }
        BlockPos targetedTorch = torches.get(random.m_188503_(torches.size()));
        TORCHES_TO_BE_BROKEN.put(targetedTorch, target);
        List<BlockPos> targetedTorches = CommonClass.getTorchesInRadius(target, targetedTorch, level, 0, 15);
        targetedTorches.forEach(pos -> TORCHES_TO_BE_BROKEN.put((BlockPos)pos, target));
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
    }

    public static void replaceTorches(ServerPlayer target, int minRange, int maxRange) {
        ServerLevel level = target.m_284548_();
        BlockPos playerPos = target.m_20097_();
        List<BlockPos> torches = CommonClass.getTorchesInRadius(target, playerPos, level, minRange, maxRange);
        if (torches.isEmpty()) {
            return;
        }
        BlockPos targetedTorch = torches.get(random.m_188503_(torches.size()));
        TORCHES_TO_BE_REPLACED.put(targetedTorch, target);
        List<BlockPos> targetedTorches = CommonClass.getTorchesInRadius(target, targetedTorch, level, 0, 15);
        targetedTorches.forEach(pos -> TORCHES_TO_BE_REPLACED.put((BlockPos)pos, target));
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
    }

    public static boolean hitPlayerLightning(ServerPlayer target) {
        ServerLevel level = target.m_284548_();
        if (!level.m_45527_(target.m_20183_())) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
        lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)target.m_20183_()));
        level.m_7967_((Entity)lightningbolt);
        CommonClass.spawnFakePlayer(target, "MarsThePlanet_", 20, true);
        return true;
    }

    public static void fakeMining(ServerPlayer target) {
        ServerLevel level = target.m_284548_();
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        int radius = 10;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.m_20097_().m_7918_(dx, dy, dz);
                    if (level.m_46859_(candidate) || level.m_46859_(candidate.m_7494_()) || level.m_46859_(candidate.m_7495_()) || level.m_46859_(candidate.m_122024_()) || level.m_46859_(candidate.m_122029_()) || level.m_46859_(candidate.m_122012_()) || level.m_46859_(candidate.m_122019_()) || candidate.m_203198_(target.m_20185_(), target.m_20186_(), target.m_20189_()) < 11.0) continue;
                    validPos.add(candidate);
                }
            }
        }
        if (validPos.isEmpty()) {
            return;
        }
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos.MutableBlockPos pos = ((BlockPos)validPos.get(random.m_188503_(validPos.size()))).m_122032_();
        for (int i = 0; i < random.m_188503_(10); ++i) {
            pos.m_122173_(dir);
            BLOCKS_TO_BE_MINED_FAKE.put(new BlockPos((Vec3i)pos), target);
            BLOCKS_TO_BE_MINED_FAKE.put(new BlockPos((Vec3i)pos.m_7494_()), target);
        }
    }

    public static void fakeSteps(ServerPlayer target) {
        ServerLevel level = target.m_284548_();
        ArrayList<BlockPos> validPos = new ArrayList<BlockPos>();
        int radius = 10;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.m_20097_().m_7918_(dx, dy, dz);
                    if (!level.m_46859_(candidate) || !level.m_46859_(candidate.m_7494_()) || !level.m_46859_(candidate.m_7495_()) || candidate.m_203198_(target.m_20185_(), target.m_20186_(), target.m_20189_()) < 4.0) continue;
                    validPos.add(candidate);
                }
            }
        }
        if (validPos.isEmpty()) {
            return;
        }
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos.MutableBlockPos pos = ((BlockPos)validPos.get(random.m_188503_(validPos.size()))).m_122032_();
        for (int i = 0; i < random.m_188503_(20); ++i) {
            pos.m_122173_(dir);
            BLOCKS_TO_BE_STEPPED_ON_FAKE.put(new BlockPos((Vec3i)pos), target);
        }
    }

    public static void joinOnBedrock(ServerPlayer target, ServerGamePacketListenerImpl listener) {
        MinecraftServer server = target.f_8924_;
        BlockPos playerPos = new BlockPos((int)target.m_20185_(), 319, (int)target.m_20189_());
        server.m_129783_().m_46597_(playerPos, Blocks.f_50752_.m_49966_());
        listener.m_9774_((double)((int)target.m_20185_()) + 0.5, 320.0, (double)((int)target.m_20189_()) + 0.5, target.m_146908_(), target.m_146909_());
    }

    public static void placeSmallTrap(ServerPlayer target) {
        MinecraftServer server = target.f_8924_;
        ServerLevel level = target.m_284548_();
        StructureTemplateManager manager = server.m_236738_();
        Optional optionalTemplate = manager.m_230407_(new ResourceLocation("serversidehorror", "small_traps/trap_" + random.m_216339_(1, 5)));
        if (optionalTemplate.isEmpty()) {
            return;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74405_(true).m_74392_(false);
        StructureTemplate template = (StructureTemplate)optionalTemplate.get();
        CommonClass.findPlacement(level, target.m_20183_(), template, settings, 80, target).ifPresent(origin -> template.m_230328_((ServerLevelAccessor)level, origin, origin, settings, random, 3));
    }

    public static void startFire(ServerPlayer target, int radius) {
        ServerLevel level = target.m_284548_();
        Optional<BlockPos> targetPos = CommonClass.findBurnablePos(target, level, radius);
        if (targetPos.isEmpty()) {
            return;
        }
        BlockPos pos = targetPos.get();
        level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
        level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void joinInDungeon(ServerPlayer target, ServerGamePacketListenerImpl listener) {
        MinecraftServer server = target.f_8924_;
        ServerLevel level = target.m_284548_();
        StructureTemplateManager manager = server.m_236738_();
        Optional optionalTemplate = manager.m_230407_(new ResourceLocation("serversidehorror", "rejoin_dungeon"));
        if (optionalTemplate.isEmpty()) {
            return;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74405_(true).m_74392_(false);
        StructureTemplate template = (StructureTemplate)optionalTemplate.get();
        CommonClass.findPlacementRejoinDungeon(level, target.m_20183_(), template, settings, 80, target).ifPresent(origin -> {
            template.m_230328_((ServerLevelAccessor)level, origin, origin, settings, random, 3);
            listener.m_9774_((double)origin.m_123341_() + 2.5, -58.0, (double)origin.m_123343_() + 2.5, target.m_146908_(), target.m_146909_());
        });
    }

    public static void removeLeaves(ServerPlayer target, int maxRadius, int minRadius) {
        ServerLevel level = target.m_284548_();
        BlockPos playerPos = target.m_20097_();
        BlockPos aMax = playerPos.m_7918_(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.m_7918_(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.m_121940_((BlockPos)aMax, (BlockPos)bMax);
        for (BlockPos pos : allBlocksInRadius) {
            BlockState state;
            if (pos.m_203195_((Position)playerPos.m_252807_(), (double)minRadius) || !(level.m_8055_(pos).m_60734_() instanceof LeavesBlock) || ((Boolean)(state = level.m_8055_(pos)).m_61143_((net.minecraft.world.level.block.state.properties.Property)LeavesBlock.f_54419_)).booleanValue()) continue;
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public static boolean placeSign(ServerPlayer target, int maxRadius, int minRadius) {
        ServerLevel level = target.m_284548_();
        BlockPos playerPos = target.m_20097_();
        BlockPos aMax = playerPos.m_7918_(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.m_7918_(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.m_121940_((BlockPos)aMax, (BlockPos)bMax);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : allBlocksInRadius) {
            if (pos.m_203195_((Position)playerPos.m_252807_(), (double)minRadius) || CommonClass.canSeeBlock(target, pos) || !level.m_46859_(pos) || !level.m_6425_(pos).m_76178_() || !level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) continue;
            candidates.add(new BlockPos((Vec3i)pos));
        }
        if (candidates.isEmpty()) {
            return false;
        }
        BlockPos finalPos = (BlockPos)candidates.get(random.m_188503_(candidates.size()));
        level.m_46597_(finalPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((net.minecraft.world.level.block.state.properties.Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(random.m_188503_(16))));
        BlockEntity blockEntity = level.m_7702_(finalPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            String[] lines = ServersideHorrorConfig.random_signs_texts.get(random.m_188503_(ServersideHorrorConfig.random_signs_texts.size())).split("\\r?\\n");
            SignText text = sign.m_277157_(true).m_276913_(0, (Component)Component.m_237113_((String)lines[0])).m_276913_(1, (Component)Component.m_237113_((String)lines[1])).m_276913_(2, (Component)Component.m_237113_((String)lines[2])).m_276913_(3, (Component)Component.m_237113_((String)lines[3]));
            sign.m_276956_(text, true);
            sign.m_6596_();
            level.m_7260_(finalPos, sign.m_58900_(), sign.m_58900_(), 3);
        }
        return true;
    }

    public static boolean placeHead(ServerPlayer target, String name, int maxRadius, int minRadius) {
        ServerLevel level = target.m_284548_();
        BlockPos playerPos = target.m_20097_();
        BlockPos aMax = playerPos.m_7918_(-maxRadius, -maxRadius, -maxRadius);
        BlockPos bMax = playerPos.m_7918_(maxRadius, maxRadius, maxRadius);
        Iterable allBlocksInRadius = BlockPos.m_121940_((BlockPos)aMax, (BlockPos)bMax);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos pos : allBlocksInRadius) {
            if (pos.m_203195_((Position)playerPos.m_252807_(), (double)minRadius) || CommonClass.canSeeBlock(target, pos) || !level.m_46859_(pos) || !level.m_6425_(pos).m_76178_() || !level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) continue;
            candidates.add(new BlockPos((Vec3i)pos));
        }
        if (candidates.isEmpty()) {
            return false;
        }
        BlockPos finalPos = (BlockPos)candidates.get(random.m_188503_(candidates.size()));
        level.m_46597_(finalPos, (BlockState)Blocks.f_50316_.m_49966_().m_61124_((net.minecraft.world.level.block.state.properties.Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(random.m_188503_(16))));
        BlockEntity blockEntity = level.m_7702_(finalPos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity head = (SkullBlockEntity)blockEntity;
            GameProfile profile = new GameProfile(UUID.randomUUID(), name);
            head.m_59769_(profile);
            head.m_6596_();
        }
        return true;
    }

    public static boolean playScarySound(ServerPlayer target, int radius) {
        ServerLevel level = target.m_284548_();
        List<String> soundNamesList = ServersideHorrorConfig.scary_sound_list;
        if (soundNamesList.isEmpty()) {
            return false;
        }
        String soundName = soundNamesList.get(random.m_188503_(soundNamesList.size() - 1));
        SoundEvent scarySound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(soundName));
        BlockPos soundPos = target.m_20097_().m_7918_(random.m_216339_(-radius, radius), random.m_216339_(-radius, radius), random.m_216339_(-radius, radius));
        level.m_5594_(null, soundPos, scarySound, SoundSource.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    public static boolean chanceOneIn(int denominator) {
        return random.m_188503_(denominator) == 0;
    }

    public static boolean isGracePeriodUp(ServerLevel level) {
        return level.m_6106_().m_6793_() > (long)ServersideHorrorConfig.grace_period * 24000L;
    }

    public static boolean canSeeBlock(ServerPlayer player, BlockPos pos) {
        ClipContext ctx;
        ServerLevel world = player.m_284548_();
        BlockHitResult result = world.m_45547_(ctx = new ClipContext(player.m_146892_(), Vec3.m_82512_((Vec3i)pos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        return result.m_82425_().equals((Object)pos);
    }

    public static List<String> getSeenPlayers(MinecraftServer server) {
        Path worldPath = server.m_129843_(LevelResource.f_78182_);
        ArrayList<String> names = new ArrayList<String>();
        Path playerData = worldPath.resolve("playerdata");
        if (!Files.isDirectory(playerData, new LinkOption[0])) {
            return names;
        }
        GameProfileCache cache = server.m_129927_();
        Set<Object> uuids = new HashSet();
        try (Stream<Path> paths = Files.list(playerData);){
            uuids = paths.filter(p -> p.getFileName().toString().endsWith(".dat")).map(p -> p.getFileName().toString().replace(".dat", "")).map(uuidStr -> {
                try {
                    return UUID.fromString(uuidStr);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        }
        catch (IOException e) {
            Constants.LOG.info(e.toString());
        }
        for (UUID uuid : uuids) {
            Optional opt = cache.m_11002_(uuid);
            if (!opt.isPresent()) continue;
            names.add(opt.map(GameProfile::getName).get());
        }
        return names;
    }

    private static String[] getSkin(String name) {
        try {
            URL profileUrl = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            InputStreamReader inputStreamReaderProfile = new InputStreamReader(profileUrl.openStream());
            String uuid = new JsonParser().parse((Reader)inputStreamReaderProfile).getAsJsonObject().get("id").getAsString();
            URL userSession = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            InputStreamReader inputStreamReaderSession = new InputStreamReader(userSession.openStream());
            JsonObject property = new JsonParser().parse((Reader)inputStreamReaderSession).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            return new String[]{property.get("value").getAsString(), property.get("signature").getAsString()};
        }
        catch (Exception e) {
            Constants.LOG.info("Couldn't find player{}, the fake player is going to use the default skin", (Object)name);
            Constants.LOG.warn(String.valueOf(e));
            return CommonClass.getSkin("IceBreak");
        }
    }

    public static List<BlockPos> getTorchesInRadius(ServerPlayer player, BlockPos centre, ServerLevel level, int minRange, int maxRange) {
        ArrayList<BlockPos> torches = new ArrayList<BlockPos>();
        BlockPos aMax = centre.m_7918_(-maxRange, -maxRange, -maxRange);
        BlockPos bMax = centre.m_7918_(maxRange, maxRange, maxRange);
        Iterable allBlocksInRange = BlockPos.m_121940_((BlockPos)aMax, (BlockPos)bMax);
        for (BlockPos pos : allBlocksInRange) {
            if (!level.m_8055_(pos).m_60713_(Blocks.f_50081_) && !level.m_8055_(pos).m_60713_(Blocks.f_50082_) || pos.m_123314_(new Vec3i(centre.m_123341_(), centre.m_123342_(), centre.m_123343_()), (double)minRange) || CommonClass.canSeeBlock(player, pos)) continue;
            torches.add(new BlockPos((Vec3i)pos));
        }
        return torches;
    }

    private static Optional<BlockPos> findValidSpawnPos(ServerLevel level, ServerPlayer fake, ServerPlayer target, int radius, boolean lineOfSight) {
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.m_20097_().m_7918_(dx, dy, dz);
                    if (!level.m_46859_(candidate) || !level.m_46859_(candidate.m_7494_()) || !level.m_8055_(candidate.m_7495_()).m_60815_() || target.m_20097_() == candidate || target.m_20097_().m_122029_() == candidate || target.m_20097_().m_122012_() == candidate || target.m_20097_().m_122019_() == candidate || target.m_20097_().m_122024_() == candidate) continue;
                    fake.m_6034_((double)candidate.m_123341_(), (double)candidate.m_123342_(), (double)candidate.m_123343_());
                    if (lineOfSight != fake.m_142582_((Entity)target)) continue;
                    valid.add(candidate);
                }
            }
        }
        if (valid.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((BlockPos)valid.get(random.m_188503_(valid.size())));
    }

    private static Optional<BlockPos> findPlacement(ServerLevel level, BlockPos around, StructureTemplate template, StructurePlaceSettings settings, int radiusBlocks, ServerPlayer player) {
        BoundingBox boxAtZero = template.m_74633_(settings, BlockPos.f_121853_);
        int sizeX = boxAtZero.m_71056_();
        int sizeY = boxAtZero.m_71057_();
        int sizeZ = boxAtZero.m_71058_();
        ServerChunkCache chunkSource = level.m_7726_();
        for (int r = radiusBlocks; r >= 0; --r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dzRing1 = r;
                int dzRing2 = -r;
                if (CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dx, around.m_123343_() + dzRing1, sizeX, sizeZ, sizeY, player).isPresent()) {
                    return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dx, around.m_123343_() + dzRing1, sizeX, sizeZ, sizeY, player);
                }
                if (!CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dx, around.m_123343_() + dzRing2, sizeX, sizeZ, sizeY, player).isPresent()) continue;
                return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dx, around.m_123343_() + dzRing2, sizeX, sizeZ, sizeY, player);
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                int dxRing1 = r;
                int dxRing2 = -r;
                if (CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dxRing1, around.m_123343_() + dz, sizeX, sizeZ, sizeY, player).isPresent()) {
                    return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dxRing1, around.m_123343_() + dz, sizeX, sizeZ, sizeY, player);
                }
                if (!CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dxRing2, around.m_123343_() + dz, sizeX, sizeZ, sizeY, player).isPresent()) continue;
                return CommonClass.tryCandidate(level, (ChunkSource)chunkSource, around.m_123341_() + dxRing2, around.m_123343_() + dz, sizeX, sizeZ, sizeY, player);
            }
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> tryCandidate(ServerLevel level, ChunkSource chunkSource, int cornerX, int cornerZ, int sizeX, int sizeZ, int sizeY, ServerPlayer player) {
        int x;
        int minChunkX = cornerX >> 4;
        int minChunkZ = cornerZ >> 4;
        int maxChunkX = cornerX + sizeX - 1 >> 4;
        int maxChunkZ = cornerZ + sizeZ - 1 >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                LevelChunk chk = chunkSource.m_7131_(cx, cz);
                if (chk != null) continue;
                return Optional.empty();
            }
        }
        Integer flatGroundY = null;
        for (int x2 = 0; x2 < sizeX; ++x2) {
            for (int z = 0; z < sizeZ; ++z) {
                int worldX = cornerX + x2;
                int worldZ = cornerZ + z;
                int topY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ) - 1;
                if (flatGroundY == null) {
                    flatGroundY = topY;
                    continue;
                }
                if (topY == flatGroundY) continue;
                return Optional.empty();
            }
        }
        if (flatGroundY == null) {
            return Optional.empty();
        }
        int originY = flatGroundY + 1;
        BlockPos origin = new BlockPos(cornerX, originY, cornerZ);
        if (CommonClass.canSeeBlock(player, origin) || CommonClass.canSeeBlock(player, origin.m_7494_())) {
            return Optional.empty();
        }
        for (x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                BlockPos supportPos = new BlockPos(cornerX + x, flatGroundY.intValue(), cornerZ + z);
                BlockState support = level.m_8055_(supportPos);
                if (!support.m_60795_() && support.m_60783_((BlockGetter)level, supportPos, Direction.UP)) continue;
                return Optional.empty();
            }
        }
        for (x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos p = new BlockPos(cornerX + x, originY + y, cornerZ + z);
                    if (!level.m_46739_(p)) {
                        return Optional.empty();
                    }
                    if (level.m_8055_(p).m_60795_()) continue;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(origin);
    }

    private static Optional<BlockPos> findPlacementRejoinDungeon(ServerLevel level, BlockPos around, StructureTemplate template, StructurePlaceSettings settings, int radiusBlocks, ServerPlayer player) {
        BoundingBox boxAtZero = template.m_74633_(settings, BlockPos.f_121853_);
        int sizeX = boxAtZero.m_71056_();
        int sizeY = boxAtZero.m_71057_();
        int sizeZ = boxAtZero.m_71058_();
        for (int r = 0; r <= radiusBlocks; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                int dzRing1 = r;
                int dzRing2 = -r;
                if (CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dx, around.m_123343_() + dzRing1, sizeX, sizeZ, sizeY).isPresent()) {
                    return CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dx, around.m_123343_() + dzRing1, sizeX, sizeZ, sizeY);
                }
                if (!CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dx, around.m_123343_() + dzRing2, sizeX, sizeZ, sizeY).isPresent()) continue;
                return CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dx, around.m_123343_() + dzRing2, sizeX, sizeZ, sizeY);
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                int dxRing1 = r;
                int dxRing2 = -r;
                if (CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dxRing1, around.m_123343_() + dz, sizeX, sizeZ, sizeY).isPresent()) {
                    return CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dxRing1, around.m_123343_() + dz, sizeX, sizeZ, sizeY);
                }
                if (!CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dxRing2, around.m_123343_() + dz, sizeX, sizeZ, sizeY).isPresent()) continue;
                return CommonClass.tryCandidateRejoinDungeon(level, around.m_123341_() + dxRing2, around.m_123343_() + dz, sizeX, sizeZ, sizeY);
            }
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> tryCandidateRejoinDungeon(ServerLevel level, int cornerX, int cornerZ, int sizeX, int sizeZ, int sizeY) {
        int originY = -59;
        BlockPos origin = new BlockPos(cornerX, originY, cornerZ);
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos p = new BlockPos(cornerX + x, originY + y, cornerZ + z);
                    if (!level.m_46739_(p)) {
                        return Optional.empty();
                    }
                    if (level.m_8055_(p).m_60713_(Blocks.f_152550_)) continue;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(origin);
    }

    private static Optional<BlockPos> findBurnablePos(ServerPlayer target, ServerLevel level, int radius) {
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos candidate = target.m_20097_().m_7918_(dx, dy, dz);
                    BlockState state = level.m_8055_(candidate);
                    if (!state.m_60795_() || !CommonClass.hasFlammableNeighbours((LevelReader)level, candidate) || CommonClass.canSeeBlock(target, candidate)) continue;
                    valid.add(candidate);
                }
            }
        }
        if (valid.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((BlockPos)valid.get(random.m_188503_(valid.size())));
    }

    private static boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!CommonClass.isFlammable(level, pos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlammable(LevelReader level, BlockPos pos) {
        return (pos.m_123342_() < level.m_141937_() || pos.m_123342_() >= level.m_151558_() || level.m_46805_(pos)) && level.m_8055_(pos).m_278200_();
    }

    static {
        random = RandomSource.m_216327_();
    }
}

