/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.ServersideHorrorConfig;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocateCommand.class})
public class LocateCommandMixin {
    @Inject(method={"locateStructure"}, at={@At(value="HEAD")}, cancellable=true)
    private static void locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure, CallbackInfoReturnable<Integer> cir) throws CommandSyntaxException {
        if (!ServersideHorrorConfig.old_villages_enable && structure.m_245390_().equals("serversidehorror:village_old_plains")) {
            throw new SimpleCommandExceptionType((Message)Component.m_264568_((String)"serversidehorror.commands.locate.structure.disabled", (String)"Couldn't find the structure you were looking for because it was disabled in the config")).create();
        }
        if (structure.m_245390_().contains("serversidehorror:traps/trap_")) {
            if (!ServersideHorrorConfig.traps_enable) {
                throw new SimpleCommandExceptionType((Message)Component.m_264568_((String)"serversidehorror.commands.locate.structure.disabled", (String)"Couldn't find the structure you were looking for because it was disabled in the config")).create();
            }
            if (!CommonClass.isGracePeriodUp(source.m_81377_().m_129783_()) && ServersideHorrorConfig.grace_period_applies_to_traps) {
                throw new SimpleCommandExceptionType((Message)Component.m_264568_((String)"serversidehorror.commands.locate.structure.grace_period_not_up", (String)"Grace period is not up yet and traps can not generate")).create();
            }
        }
    }
}

