/*
 * Decompiled with CFR 0.152.
 */
package com.mars.serversidehorror.mixin;

import com.mars.serversidehorror.CommonClass;
import com.mars.serversidehorror.SavedDataHorror;
import com.mars.serversidehorror.ServersideHorrorConfig;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tickServer(BooleanSupplier hasTimeLeft, CallbackInfo info) {
        ServerLevel self = (ServerLevel)this;
        if (ServersideHorrorConfig.grace_period_applies_to_traps) {
            CommonClass.currentLevel = self;
        }
        if (!CommonClass.isGracePeriodUp(self)) {
            return;
        }
        TickRateManager tickratemanager = self.tickRateManager();
        if (!tickratemanager.runsNormally()) {
            return;
        }
        long time = self.getLevelData().getDayTime();
        DimensionDataStorage storage = self.getServer().overworld().getDataStorage();
        SavedDataHorror savedData = (SavedDataHorror)storage.computeIfAbsent(new SavedData.Factory(SavedDataHorror::create, SavedDataHorror::load, null), "saved_data_horror");
        if (time == 18000L && self.getLevelData().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT) && ServersideHorrorConfig.long_night_enable) {
            savedData.setLongNight(CommonClass.chanceOneIn(ServersideHorrorConfig.long_night_chance));
        }
        if (savedData.getLongNight()) {
            savedData.setLongNight(!CommonClass.chanceOneIn(12000));
            ((GameRules.BooleanValue)self.getLevelData().getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(!savedData.getLongNight(), self.getServer());
        }
    }
}

