/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.tooltips.init;

import com.jahirtrap.tooltips.init.ModConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.ModList;

public class ModTooltips {
    public static void init(ItemStack stack, Player player, List<Component> list, TooltipFlag flag) {
        Item enchantPowerTooltip2;
        Block block;
        int repairCost;
        int enchantable;
        ItemCooldowns.CooldownInstance cooldown;
        int burnTime;
        float compostable;
        if (!ModConfig.enableMod) {
            return;
        }
        if (ModConfig.showDurability && (!flag.m_7050_() || flag.m_7050_() && !stack.m_41768_()) && stack.m_41776_() != 0) {
            TranslatableComponent durabilityTooltip = new TranslatableComponent("item.durability", new Object[]{stack.m_41776_() - stack.m_41773_(), stack.m_41776_()});
            list.add((Component)durabilityTooltip.m_6881_().m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.durabilityColor).intValue())));
        }
        if (ModConfig.showFoodValues) {
            FoodProperties foodProperties = stack.m_41720_().m_41473_();
            if (stack.m_41614_() && foodProperties != null) {
                TranslatableComponent foodTooltip = null;
                int nutrition = foodProperties.m_38744_();
                float saturation = (float)nutrition * foodProperties.m_38745_() * 2.0f;
                if (nutrition != 0 && saturation != 0.0f) {
                    foodTooltip = new TranslatableComponent("tooltipstxf.tooltip.nutrition", new Object[]{nutrition}).m_130946_(" ").m_7220_((Component)new TranslatableComponent("tooltipstxf.tooltip.saturation", new Object[]{ModTooltips.formatText(saturation)}));
                } else if (nutrition != 0) {
                    foodTooltip = new TranslatableComponent("tooltipstxf.tooltip.nutrition", new Object[]{nutrition});
                } else if (saturation != 0.0f) {
                    foodTooltip = new TranslatableComponent("tooltipstxf.tooltip.saturation", new Object[]{ModTooltips.formatText(saturation)});
                }
                if (foodTooltip != null) {
                    list.add((Component)foodTooltip.m_6881_().m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.foodValuesColor).intValue())));
                }
            }
        }
        if (ModConfig.showCompostable && (compostable = ComposterBlock.f_51914_.getOrDefault((Object)stack.m_41720_(), 0.0f)) != 0.0f) {
            MutableComponent compostableTooltip = new TranslatableComponent("tooltipstxf.tooltip.compostable", new Object[]{ModTooltips.formatText(compostable * 100.0f)}).m_130946_("%").m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.compostableColor).intValue()));
            list.add((Component)compostableTooltip);
        }
        if (ModConfig.showBurnTime && (burnTime = ForgeHooks.getBurnTime((ItemStack)stack, null)) != 0) {
            TranslatableComponent burnTimeTooltip = ModConfig.timeInSeconds ? new TranslatableComponent("tooltipstxf.tooltip.burn_time.seconds", new Object[]{ModTooltips.formatText((float)burnTime / 20.0f)}) : new TranslatableComponent("tooltipstxf.tooltip.burn_time", new Object[]{burnTime});
            list.add((Component)burnTimeTooltip.m_6881_().m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.burnTimeColor).intValue())));
        }
        if (ModConfig.showUseCooldown && player != null && (cooldown = (ItemCooldowns.CooldownInstance)player.m_36335_().f_41515_.get(stack.m_41720_())) != null) {
            TranslatableComponent cooldownComponent = ModConfig.timeInSeconds ? new TranslatableComponent("tooltipstxf.tooltip.use_cooldown.seconds", new Object[]{ModTooltips.formatText((float)(cooldown.f_41534_ - cooldown.f_41533_) / 20.0f)}) : new TranslatableComponent("tooltipstxf.tooltip.use_cooldown", new Object[]{cooldown.f_41534_ - cooldown.f_41533_});
            list.add((Component)cooldownComponent.m_6881_().m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.useCooldownColor).intValue())));
        }
        if (ModConfig.showEnchantability && (enchantable = stack.m_41720_().m_6473_()) != 0) {
            MutableComponent enchantabilityComponent = new TranslatableComponent("tooltipstxf.tooltip.enchantability", new Object[]{enchantable}).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.enchantabilityColor).intValue()));
            list.add((Component)enchantabilityComponent);
        }
        if (ModConfig.showRepairCost && (repairCost = stack.m_41610_()) != 0) {
            list.add((Component)new TranslatableComponent("tooltipstxf.tooltip.repair_cost", new Object[]{repairCost + 1}).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.repairCostColor).intValue())));
        }
        if ((block = Block.m_49814_((Item)stack.m_41720_())) != Blocks.f_50016_) {
            float enchantPower;
            if (ModConfig.showStrength) {
                TranslatableComponent strengthTooltip = null;
                if (block.m_155943_() != 0.0f && block.m_7325_() != 0.0f) {
                    strengthTooltip = new TranslatableComponent("tooltipstxf.tooltip.hardness", new Object[]{ModTooltips.formatText(block.m_155943_())}).m_130946_(" ").m_7220_((Component)new TranslatableComponent("tooltipstxf.tooltip.resistance", new Object[]{ModTooltips.formatText(block.m_7325_())}));
                } else if (block.m_155943_() != 0.0f) {
                    strengthTooltip = new TranslatableComponent("tooltipstxf.tooltip.hardness", new Object[]{ModTooltips.formatText(block.m_155943_())});
                } else if (block.m_7325_() != 0.0f) {
                    strengthTooltip = new TranslatableComponent("tooltipstxf.tooltip.resistance", new Object[]{ModTooltips.formatText(block.m_7325_())});
                }
                if (strengthTooltip != null) {
                    list.add((Component)strengthTooltip.m_6881_().m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.strengthColor).intValue())));
                }
            }
            if (ModConfig.showEnchantmentPower && player != null && (enchantPower = ModTooltips.getEnchantPowerBonus(player.m_183503_(), block)) != 0.0f) {
                MutableComponent enchantPowerTooltip2 = new TranslatableComponent("tooltipstxf.tooltip.enchantment_power", new Object[]{ModTooltips.formatText(enchantPower)}).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.enchantmentPowerColor).intValue()));
                list.add((Component)enchantPowerTooltip2);
            }
        }
        if ((enchantPowerTooltip2 = stack.m_41720_()) instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)enchantPowerTooltip2;
            Tier tier = tieredItem.m_43314_();
            if (ModConfig.showMiningLevel) {
                MutableComponent miningLevelTooltip = new TranslatableComponent("tooltipstxf.tooltip.mining_level", new Object[]{tier.m_6604_()}).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.miningLevelColor).intValue()));
                list.add((Component)miningLevelTooltip);
            }
            if (ModConfig.showMiningSpeed) {
                MutableComponent miningSpeedTooltip = new TranslatableComponent("tooltipstxf.tooltip.mining_speed", new Object[]{ModTooltips.formatText(tier.m_6624_())}).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x555555, ModConfig.miningSpeedColor).intValue()));
                list.add((Component)miningSpeedTooltip);
            }
        }
        if (ModConfig.showModName) {
            String modId = Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135827_();
            MutableComponent modNameTooltip = new TextComponent(ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId)).m_130940_(ChatFormatting.ITALIC).m_130938_(s -> s.m_178520_(ModTooltips.getColor(0x5555FF, ModConfig.modNameColor).intValue()));
            list.add((Component)modNameTooltip);
        }
    }

    private static String formatText(double value) {
        if (value % 1.0 == 0.0) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", value).replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    private static float getEnchantPowerBonus(Level level, Block block) {
        return block.m_49966_().getEnchantPowerBonus((LevelReader)level, BlockPos.f_121853_);
    }

    private static Integer getColor(int defaultValue, String hexColor) {
        int color = defaultValue;
        try {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            color = Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }
}

