/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.tooltips.init;

import com.jahirtrap.tooltips.init.ModConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.CommonHooks;

public class ModTooltips {
    public static void init(ItemStack stack, Player player, List<Component> list, TooltipFlag flag) {
        Item enchantPowerTooltip2;
        Block block;
        int repairCost;
        int enchantable;
        ItemCooldowns.CooldownInstance cooldown;
        int burnTime;
        float compostable;
        if (!ModConfig.enableMod) {
            return;
        }
        if (ModConfig.showDurability && (!flag.isAdvanced() || flag.isAdvanced() && !stack.isDamaged()) && stack.getMaxDamage() != 0) {
            MutableComponent durabilityTooltip = Component.translatable((String)"item.durability", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue(), stack.getMaxDamage()});
            list.add((Component)durabilityTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.durabilityColor).intValue()));
        }
        if (ModConfig.showFoodValues) {
            FoodProperties foodProperties = stack.getItem().getFoodProperties();
            if (stack.isEdible() && foodProperties != null) {
                MutableComponent foodTooltip = Component.empty();
                int nutrition = foodProperties.getNutrition();
                float saturation = (float)nutrition * foodProperties.getSaturationModifier() * 2.0f;
                if (nutrition != 0 && saturation != 0.0f) {
                    foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.nutrition", (Object[])new Object[]{nutrition}).append(" ").append((Component)Component.translatable((String)"tooltipstxf.tooltip.saturation", (Object[])new Object[]{ModTooltips.formatText(saturation)}));
                } else if (nutrition != 0) {
                    foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.nutrition", (Object[])new Object[]{nutrition});
                } else if (saturation != 0.0f) {
                    foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.saturation", (Object[])new Object[]{ModTooltips.formatText(saturation)});
                }
                if (!foodTooltip.equals(Component.empty())) {
                    list.add((Component)foodTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.foodValuesColor).intValue()));
                }
            }
        }
        if (ModConfig.showCompostable && (compostable = ComposterBlock.getValue((ItemStack)stack)) > -1.0f && compostable != 0.0f) {
            MutableComponent compostableTooltip = Component.translatable((String)"tooltipstxf.tooltip.compostable", (Object[])new Object[]{ModTooltips.formatText(compostable * 100.0f)}).append("%").withColor(ModTooltips.getColor(0x555555, ModConfig.compostableColor).intValue());
            list.add((Component)compostableTooltip);
        }
        if (ModConfig.showBurnTime && (burnTime = CommonHooks.getBurnTime((ItemStack)stack, null)) != 0) {
            MutableComponent burnTimeTooltip = ModConfig.timeInSeconds ? Component.translatable((String)"tooltipstxf.tooltip.burn_time.seconds", (Object[])new Object[]{ModTooltips.formatText((float)burnTime / 20.0f)}) : Component.translatable((String)"tooltipstxf.tooltip.burn_time", (Object[])new Object[]{burnTime});
            list.add((Component)burnTimeTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.burnTimeColor).intValue()));
        }
        if (ModConfig.showUseCooldown && player != null && (cooldown = (ItemCooldowns.CooldownInstance)player.getCooldowns().cooldowns.get(stack.getItem())) != null) {
            MutableComponent cooldownComponent = ModConfig.timeInSeconds ? Component.translatable((String)"tooltipstxf.tooltip.use_cooldown.seconds", (Object[])new Object[]{ModTooltips.formatText((float)(cooldown.endTime - cooldown.startTime) / 20.0f)}) : Component.translatable((String)"tooltipstxf.tooltip.use_cooldown", (Object[])new Object[]{cooldown.endTime - cooldown.startTime});
            list.add((Component)cooldownComponent.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.useCooldownColor).intValue()));
        }
        if (ModConfig.showEnchantability && (enchantable = stack.getItem().getEnchantmentValue()) != 0) {
            MutableComponent enchantabilityComponent = Component.translatable((String)"tooltipstxf.tooltip.enchantability", (Object[])new Object[]{enchantable}).withColor(ModTooltips.getColor(0x555555, ModConfig.enchantabilityColor).intValue());
            list.add((Component)enchantabilityComponent);
        }
        if (ModConfig.showRepairCost && (repairCost = stack.getBaseRepairCost()) != 0) {
            list.add((Component)Component.translatable((String)"tooltipstxf.tooltip.repair_cost", (Object[])new Object[]{repairCost + 1}).withColor(ModTooltips.getColor(0x555555, ModConfig.repairCostColor).intValue()));
        }
        if ((block = Block.byItem((Item)stack.getItem())) != Blocks.AIR) {
            float enchantPower;
            if (ModConfig.showStrength) {
                MutableComponent strengthTooltip = Component.empty();
                if (block.defaultDestroyTime() != 0.0f && block.getExplosionResistance() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.hardness", (Object[])new Object[]{ModTooltips.formatText(block.defaultDestroyTime())}).append(" ").append((Component)Component.translatable((String)"tooltipstxf.tooltip.resistance", (Object[])new Object[]{ModTooltips.formatText(block.getExplosionResistance())}));
                } else if (block.defaultDestroyTime() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.hardness", (Object[])new Object[]{ModTooltips.formatText(block.defaultDestroyTime())});
                } else if (block.getExplosionResistance() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.resistance", (Object[])new Object[]{ModTooltips.formatText(block.getExplosionResistance())});
                }
                if (!strengthTooltip.equals(Component.empty())) {
                    list.add((Component)strengthTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.strengthColor).intValue()));
                }
            }
            if (ModConfig.showEnchantmentPower && player != null && (enchantPower = ModTooltips.getEnchantPowerBonus(player.level(), block)) != 0.0f) {
                MutableComponent enchantPowerTooltip2 = Component.translatable((String)"tooltipstxf.tooltip.enchantment_power", (Object[])new Object[]{ModTooltips.formatText(enchantPower)}).withColor(ModTooltips.getColor(0x555555, ModConfig.enchantmentPowerColor).intValue());
                list.add((Component)enchantPowerTooltip2);
            }
        }
        if ((enchantPowerTooltip2 = stack.getItem()) instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)enchantPowerTooltip2;
            Tier tier = tieredItem.getTier();
            if (ModConfig.showMiningLevel) {
                MutableComponent miningLevelTooltip = Component.translatable((String)"tooltipstxf.tooltip.mining_level", (Object[])new Object[]{tier.getLevel()}).withColor(ModTooltips.getColor(0x555555, ModConfig.miningLevelColor).intValue());
                list.add((Component)miningLevelTooltip);
            }
            if (ModConfig.showMiningSpeed) {
                MutableComponent miningSpeedTooltip = Component.translatable((String)"tooltipstxf.tooltip.mining_speed", (Object[])new Object[]{ModTooltips.formatText(tier.getSpeed())}).withColor(ModTooltips.getColor(0x555555, ModConfig.miningSpeedColor).intValue());
                list.add((Component)miningSpeedTooltip);
            }
        }
        if (ModConfig.showModName) {
            String modId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
            MutableComponent modNameTooltip = Component.literal((String)ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId)).withStyle(ChatFormatting.ITALIC).withColor(ModTooltips.getColor(0x5555FF, ModConfig.modNameColor).intValue());
            list.add((Component)modNameTooltip);
        }
    }

    private static String formatText(double value) {
        if (value % 1.0 == 0.0) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", value).replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    private static float getEnchantPowerBonus(Level level, Block block) {
        return block.defaultBlockState().getEnchantPowerBonus((LevelReader)level, BlockPos.ZERO);
    }

    private static Integer getColor(int defaultValue, String hexColor) {
        int color = defaultValue;
        try {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            color = Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }
}

