/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.tooltips.init;

import com.jahirtrap.tooltips.init.ModConfig;
import com.jahirtrap.tooltips.init.ModTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.fml.ModList;

public class ModTooltips {
    public static void init(ItemStack stack, Player player, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        Tool tool;
        Block block;
        int repairCost;
        Enchantable enchantable;
        UseCooldown cooldown;
        int burnTime;
        float compostable;
        FoodProperties foodProperties;
        if (!ModConfig.enableMod) {
            return;
        }
        if (ModConfig.showDurability && (!flag.isAdvanced() || flag.isAdvanced() && !stack.isDamaged()) && stack.getMaxDamage() != 0) {
            MutableComponent durabilityTooltip = Component.translatable((String)"item.durability", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue(), stack.getMaxDamage()});
            list.add((Component)durabilityTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.durabilityColor).intValue()));
        }
        if (ModConfig.showFoodValues && (foodProperties = (FoodProperties)stack.get(DataComponents.FOOD)) != null) {
            MutableComponent foodTooltip = Component.empty();
            if (foodProperties.nutrition() != 0 && foodProperties.saturation() != 0.0f) {
                foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.nutrition", (Object[])new Object[]{foodProperties.nutrition()}).append(" ").append((Component)Component.translatable((String)"tooltipstxf.tooltip.saturation", (Object[])new Object[]{ModTooltips.formatText(foodProperties.saturation())}));
            } else if (foodProperties.nutrition() != 0) {
                foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.nutrition", (Object[])new Object[]{foodProperties.nutrition()});
            } else if (foodProperties.saturation() != 0.0f) {
                foodTooltip = Component.translatable((String)"tooltipstxf.tooltip.saturation", (Object[])new Object[]{ModTooltips.formatText(foodProperties.saturation())});
            }
            if (!foodTooltip.equals((Object)Component.empty())) {
                list.add((Component)foodTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.foodValuesColor).intValue()));
            }
        }
        if (ModConfig.showCompostable && (compostable = ComposterBlock.COMPOSTABLES.getOrDefault((Object)stack.getItem(), 0.0f)) != 0.0f) {
            MutableComponent compostableTooltip = Component.translatable((String)"tooltipstxf.tooltip.compostable", (Object[])new Object[]{ModTooltips.formatText(compostable * 100.0f)}).append("%").withColor(ModTooltips.getColor(0x555555, ModConfig.compostableColor).intValue());
            list.add((Component)compostableTooltip);
        }
        if (ModConfig.showBurnTime && player != null && (burnTime = player.level().fuelValues().burnDuration(stack)) != 0) {
            MutableComponent burnTimeTooltip = ModConfig.timeInSeconds ? Component.translatable((String)"tooltipstxf.tooltip.burn_time.seconds", (Object[])new Object[]{ModTooltips.formatText((float)burnTime / 20.0f)}) : Component.translatable((String)"tooltipstxf.tooltip.burn_time", (Object[])new Object[]{burnTime});
            list.add((Component)burnTimeTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.burnTimeColor).intValue()));
        }
        if (ModConfig.showUseCooldown && (cooldown = (UseCooldown)stack.get(DataComponents.USE_COOLDOWN)) != null && cooldown.seconds() != 0.0f) {
            MutableComponent cooldownComponent = ModConfig.timeInSeconds ? Component.translatable((String)"tooltipstxf.tooltip.use_cooldown.seconds", (Object[])new Object[]{ModTooltips.formatText(cooldown.seconds())}) : Component.translatable((String)"tooltipstxf.tooltip.use_cooldown", (Object[])new Object[]{cooldown.ticks()});
            list.add((Component)cooldownComponent.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.useCooldownColor).intValue()));
        }
        if (ModConfig.showEnchantability && (enchantable = (Enchantable)stack.get(DataComponents.ENCHANTABLE)) != null && enchantable.value() != 0) {
            MutableComponent enchantabilityComponent = Component.translatable((String)"tooltipstxf.tooltip.enchantability", (Object[])new Object[]{enchantable.value()}).withColor(ModTooltips.getColor(0x555555, ModConfig.enchantabilityColor).intValue());
            list.add((Component)enchantabilityComponent);
        }
        if (ModConfig.showRepairCost && (repairCost = ((Integer)stack.getComponents().getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue()) != 0) {
            list.add((Component)Component.translatable((String)"tooltipstxf.tooltip.repair_cost", (Object[])new Object[]{repairCost + 1}).withColor(ModTooltips.getColor(0x555555, ModConfig.repairCostColor).intValue()));
        }
        if ((block = Block.byItem((Item)stack.getItem())) != Blocks.AIR) {
            float enchantPower;
            if (ModConfig.showStrength) {
                MutableComponent strengthTooltip = Component.empty();
                if (block.defaultDestroyTime() != 0.0f && block.getExplosionResistance() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.hardness", (Object[])new Object[]{ModTooltips.formatText(block.defaultDestroyTime())}).append(" ").append((Component)Component.translatable((String)"tooltipstxf.tooltip.resistance", (Object[])new Object[]{ModTooltips.formatText(block.getExplosionResistance())}));
                } else if (block.defaultDestroyTime() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.hardness", (Object[])new Object[]{ModTooltips.formatText(block.defaultDestroyTime())});
                } else if (block.getExplosionResistance() != 0.0f) {
                    strengthTooltip = Component.translatable((String)"tooltipstxf.tooltip.resistance", (Object[])new Object[]{ModTooltips.formatText(block.getExplosionResistance())});
                }
                if (!strengthTooltip.equals((Object)Component.empty())) {
                    list.add((Component)strengthTooltip.copy().withColor(ModTooltips.getColor(0x555555, ModConfig.strengthColor).intValue()));
                }
            }
            if (ModConfig.showEnchantmentPower && player != null && (enchantPower = ModTooltips.getEnchantPowerBonus(player.level(), block)) != 0.0f) {
                MutableComponent enchantPowerTooltip = Component.translatable((String)"tooltipstxf.tooltip.enchantment_power", (Object[])new Object[]{ModTooltips.formatText(enchantPower)}).withColor(ModTooltips.getColor(0x555555, ModConfig.enchantmentPowerColor).intValue());
                list.add((Component)enchantPowerTooltip);
            }
        }
        if ((tool = (Tool)stack.get(DataComponents.TOOL)) != null) {
            float miningSpeed;
            int miningLevel;
            if (ModConfig.showMiningLevel && player != null && (miningLevel = ModTooltips.getMiningLevel(tool, player.level())) >= 0) {
                MutableComponent miningLevelTooltip = Component.translatable((String)"tooltipstxf.tooltip.mining_level", (Object[])new Object[]{miningLevel}).withColor(ModTooltips.getColor(0x555555, ModConfig.miningLevelColor).intValue());
                list.add((Component)miningLevelTooltip);
            }
            if (ModConfig.showMiningSpeed && (miningSpeed = ModTooltips.getMiningSpeed(tool)) >= 0.0f) {
                MutableComponent miningSpeedTooltip = Component.translatable((String)"tooltipstxf.tooltip.mining_speed", (Object[])new Object[]{ModTooltips.formatText(miningSpeed)}).withColor(ModTooltips.getColor(0x555555, ModConfig.miningSpeedColor).intValue());
                list.add((Component)miningSpeedTooltip);
            }
        }
        if (ModConfig.showModName) {
            String modId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
            MutableComponent modNameTooltip = Component.literal((String)ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId)).withStyle(ChatFormatting.ITALIC).withColor(ModTooltips.getColor(0x5555FF, ModConfig.modNameColor).intValue());
            list.add((Component)modNameTooltip);
        }
    }

    private static String formatText(double value) {
        if (value % 1.0 == 0.0) {
            return String.valueOf((int)value);
        }
        return String.format("%.2f", value).replaceAll("0*$", "").replaceAll("\\.$", "");
    }

    private static float getEnchantPowerBonus(Level level, Block block) {
        return block.defaultBlockState().getEnchantPowerBonus((LevelReader)level, BlockPos.ZERO);
    }

    public static int getMiningLevel(Tool tool, Level level) {
        if (level.registryAccess().lookupOrThrow(Registries.BLOCK).get(ModTags.Blocks.NEEDS_NETHERITE_TOOL).map(set -> set.stream().anyMatch(h -> tool.isCorrectForDrops(((Block)h.value()).defaultBlockState()))).orElse(false).booleanValue()) {
            return 4;
        }
        if (tool.isCorrectForDrops(Blocks.ANCIENT_DEBRIS.defaultBlockState())) {
            return 3;
        }
        if (tool.isCorrectForDrops(Blocks.DIAMOND_ORE.defaultBlockState())) {
            return 2;
        }
        if (tool.isCorrectForDrops(Blocks.IRON_ORE.defaultBlockState())) {
            return 1;
        }
        if (tool.isCorrectForDrops(Blocks.STONE.defaultBlockState())) {
            return 0;
        }
        return -1;
    }

    public static float getMiningSpeed(Tool tool) {
        for (Tool.Rule rule : tool.rules()) {
            if (!rule.speed().isPresent()) continue;
            return ((Float)rule.speed().get()).floatValue();
        }
        return -1.0f;
    }

    private static Integer getColor(int defaultValue, String hexColor) {
        int color = defaultValue;
        try {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            color = Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }
}

