/*
 * Decompiled with CFR 0.152.
 */
package com.dashomi.preventer;

import com.dashomi.preventer.RegisterKeyBindings;
import com.dashomi.preventer.config.PreventerConfig;
import com.dashomi.preventer.listeners.AttackBlockEvent;
import com.dashomi.preventer.listeners.AttackEntityEvent;
import com.dashomi.preventer.listeners.PlayerJoinEvent;
import com.dashomi.preventer.listeners.UseBlockEvent;
import com.dashomi.preventer.listeners.UseEntityEvent;
import com.dashomi.preventer.listeners.UseItemEvent;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PreventerClient
implements ClientModInitializer {
    public static final String MOD_ID = "preventer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"preventer");
    public static PreventerConfig config;
    public static boolean overrideKeyPressed;
    public static int ticksSinceEating;
    public static boolean overrideToggleOff;

    public static boolean getPrevent() {
        return !overrideToggleOff && !overrideKeyPressed;
    }

    public void onInitializeClient() {
        AutoConfig.register(PreventerConfig.class, GsonConfigSerializer::new);
        config = PreventerConfig.get();
        AttackBlockCallback.EVENT.register(AttackBlockEvent::attackBlockListener);
        AttackEntityCallback.EVENT.register(AttackEntityEvent::attackEntityListener);
        ClientPlayConnectionEvents.JOIN.register(PlayerJoinEvent::playerJoinListener);
        UseBlockCallback.EVENT.register(UseBlockEvent::useBlockListener);
        UseItemCallback.EVENT.register(UseItemEvent::useItemListener);
        UseEntityCallback.EVENT.register(UseEntityEvent::useEntityListener);
        ClientTickEvents.END_WORLD_TICK.register(world -> ++ticksSinceEating);
        RegisterKeyBindings.register();
    }

    static {
        overrideKeyPressed = false;
        ticksSinceEating = 0;
        overrideToggleOff = false;
    }
}

