/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers;

import com.itatiers.InventoryChecker;
import com.itatiers.PlayerProfileQueue;
import com.itatiers.misc.CommandRegister;
import com.itatiers.misc.ConfigManager;
import com.itatiers.misc.Modes;
import com.itatiers.profile.GameMode;
import com.itatiers.profile.PlayerProfile;
import com.itatiers.profile.Status;
import com.itatiers.profile.types.SuperProfile;
import com.itatiers.screens.ConfigScreen;
import com.itatiers.screens.PlayerSearchResultScreen;
import com.itatiers.textures.ColorControl;
import com.itatiers.textures.ColorLoader;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.client.ClientBrandRetriever;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ItaTiersClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(ItaTiersClient.class);
    public static String userAgent = "ItaTiers (https://github.com/Flavio6561/ItaTiers)";
    public static boolean anonymousUserAgent = false;
    private static final ArrayList<PlayerProfile> playerProfiles = new ArrayList();
    private static final HashMap<String, class_2561> playerTexts = new HashMap();
    public static boolean toggleMod = true;
    public static boolean showIcons = true;
    public static boolean isSeparatorAdaptive = true;
    public static ModesTierDisplay displayMode = ModesTierDisplay.ADAPTIVE_HIGHEST;
    public static DisplayStatus positionItaTiers = DisplayStatus.LEFT;
    public static Modes activeItaTiersMode = Modes.VANILLA;
    private static class_304 autoDetectKey;
    private static class_304 cycleKey;
    public static boolean isOnLunar;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        ItaTiersClient.clearCache(true);
        CommandRegister.registerCommands();
        isOnLunar = ClientBrandRetriever.getClientModName().contains("lunarclient");
        Optional fabricLoader = FabricLoader.getInstance().getModContainer("itatiers");
        fabricLoader.ifPresent(tiers -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"itatiers", (String)"itatiers-default"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            if (!anonymousUserAgent) {
                userAgent = userAgent + " " + ((ModContainer)fabricLoader.get()).getMetadata().getVersion().getFriendlyString() + " on " + class_310.method_1551().method_1515();
            }
        });
        autoDetectKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Auto-detect kit", 89, "ItaTiers"));
        cycleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle the gamemodes", 85, "ItaTiers"));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ColorLoader());
        ClientTickEvents.END_CLIENT_TICK.register(ItaTiersClient::tickUtils);
        LOGGER.info("ItaTiers initialized | User agent: {}", (Object)userAgent);
    }

    public static class_2561 getModifiedNametag(String originalName, class_2561 originalNameText) {
        PlayerProfile profile = ItaTiersClient.addGetPlayer(originalName, false);
        if (profile.status == Status.READY && (profile.originalNameText == null || profile.originalNameText != originalNameText)) {
            ItaTiersClient.updatePlayerNametag(originalNameText, profile);
        }
        if (playerTexts.containsKey(originalName)) {
            return playerTexts.get(originalName);
        }
        return originalNameText;
    }

    public static class_2561 getNametag(PlayerProfile profile) {
        if (!toggleMod || profile.status != Status.READY) {
            return profile.originalNameText;
        }
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        class_2561 nameText = class_2561.method_30163((String)profile.name);
        if (positionItaTiers == DisplayStatus.RIGHT) {
            rightText = ItaTiersClient.updateProfileNameTagRight(profile.profileItaTiers, activeItaTiersMode);
        } else if (positionItaTiers == DisplayStatus.LEFT) {
            leftText = ItaTiersClient.updateProfileNameTagLeft(profile.profileItaTiers, activeItaTiersMode);
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && client.method_1562() != null && profile.uuidObject != null && client.method_1562().method_31363().contains(profile.uuidObject)) {
            nameText = profile.originalNameText;
        }
        return class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(nameText).method_10852((class_2561)rightText);
    }

    private static void updateAllTags() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY || profile.originalNameText == null) continue;
            ItaTiersClient.updatePlayerNametag(profile.originalNameText, profile);
        }
        if (ConfigScreen.ownProfile.status == Status.READY) {
            ItaTiersClient.updatePlayerNametag(ConfigScreen.ownProfile.originalNameText, ConfigScreen.ownProfile);
        }
        ItaTiersClient.updatePlayerNametag(ConfigScreen.defaultProfile.originalNameText, ConfigScreen.defaultProfile);
    }

    private static void updatePlayerNametag(class_2561 originalNameText, PlayerProfile profile) {
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        if (positionItaTiers == DisplayStatus.RIGHT) {
            rightText = ItaTiersClient.updateProfileNameTagRight(profile.profileItaTiers, activeItaTiersMode);
        } else if (positionItaTiers == DisplayStatus.LEFT) {
            leftText = ItaTiersClient.updateProfileNameTagLeft(profile.profileItaTiers, activeItaTiersMode);
        }
        playerTexts.put(profile.name, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(originalNameText).method_10852((class_2561)rightText));
        profile.originalNameText = originalNameText;
    }

    private static class_2561 updateProfileNameTagRight(SuperProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints() > shown.getTierPoints()) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)separator).method_10852(shown.displayedTier));
            if (showIcons) {
                returnValue.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852(shown.name.iconTag));
            }
        }
        return returnValue;
    }

    private static class_2561 updateProfileNameTagLeft(SuperProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints() > shown.getTierPoints()) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            if (showIcons) {
                returnValue = class_2561.method_43470((String)"").method_10852(shown.name.iconTag).method_27693(" ");
            }
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852(shown.displayedTier).method_10852((class_2561)separator));
        }
        return returnValue;
    }

    public static void restyleAllTexts() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY || profile.profileItaTiers.status != Status.READY) continue;
            profile.profileItaTiers.parseJson(profile.profileItaTiers.originalJson);
        }
    }

    private static void tickUtils(class_310 client) {
        if (!client.method_53466()) {
            return;
        }
        if (ConfigScreen.defaultProfile == null) {
            ConfigScreen.ownProfile = new PlayerProfile(client.method_53462().getName(), false);
            PlayerProfileQueue.enqueue(ConfigScreen.ownProfile);
            ConfigScreen.defaultProfile = new PlayerProfile("{\"id\":\"da300ba3690b43228feacf1628825c88\",\"name\":\"Sbiguss\"}", "{\"uuid\":\"da300ba3690b43228feacf1628825c88\",\"username\":\"Sbiguss\",\"retired\":0,\"tiers\":{\"elytra\":\"HT3\",\"uhc\":\"LT2\",\"nethpot\":\"HT3\",\"vanilla\":\"LT4\",\"axe\":\"HT2\",\"smp\":\"HT2\",\"diapot\":\"HT2\",\"sword\":\"HT2\"},\"points\":151}");
        }
        if (autoDetectKey.method_1436()) {
            InventoryChecker.checkInventory(client);
        }
        if (cycleKey.method_1436()) {
            class_2561 message = ItaTiersClient.cycleModes();
            ItaTiersClient.sendMessageToPlayer(message, true);
        }
    }

    public static class_2561 cycleModes() {
        return class_2561.method_43470((String)"ItaTiers is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(ItaTiersClient.cycleItaTiersMode());
    }

    public static class_2561 getActiveIcon() {
        return ItaTiersClient.activeItaTiersMode.icon;
    }

    public static void sendMessageToPlayer(String message, int color, boolean overlay) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_36139(color)), overlay);
        }
    }

    public static void sendMessageToPlayer(class_2561 message, boolean overlay) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353(message, overlay);
        }
    }

    public static int toggleMod(CommandContext<FabricClientCommandSource> ignoredFabricClientCommandSourceCommandContext) {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
        ItaTiersClient.sendMessageToPlayer("ItaTiers is now " + (toggleMod ? "enabled" : "disabled"), toggleMod ? ColorControl.getColor("green") : ColorControl.getColor("red"), true);
        return 1;
    }

    public static void toggleMod() {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
    }

    private static PlayerProfile addGetPlayer(String name, boolean priority) {
        for (PlayerProfile profile : playerProfiles) {
            if (!profile.name.equalsIgnoreCase(name) && !profile.originalName.equalsIgnoreCase(name)) continue;
            if (priority) {
                PlayerProfileQueue.changeToFirstInQueue(profile);
            }
            return profile;
        }
        PlayerProfile newProfile = new PlayerProfile(name, true);
        if (priority) {
            PlayerProfileQueue.putFirstInQueue(newProfile);
        } else {
            PlayerProfileQueue.enqueue(newProfile);
        }
        playerProfiles.add(newProfile);
        return newProfile;
    }

    private static void openPlayerSearchResultScreen(PlayerProfile profile) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new PlayerSearchResultScreen(profile)));
    }

    private static void openConfigScreen() {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(ConfigScreen.getConfigScreen(null)));
    }

    public static int searchPlayer(String name) {
        if (name.equalsIgnoreCase("toggle")) {
            ItaTiersClient.toggleMod(null);
        } else if (name.equalsIgnoreCase("config")) {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(ItaTiersClient::openConfigScreen);
        } else {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> ItaTiersClient.openPlayerSearchResultScreen(ItaTiersClient.addGetPlayer(name, true)));
        }
        return 1;
    }

    public static void clearCache(boolean start) {
        playerProfiles.clear();
        playerTexts.clear();
        PlayerProfileQueue.clearQueue();
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(FabricLoader.getInstance().getGameDir()) + (start ? "/cache/itatiers" : "/cache/itatiers/players")));
        }
        catch (IOException e) {
            LOGGER.warn("Error deleting cache folder: {}", (Object)e.getMessage());
        }
    }

    public static void toggleSeparatorAdaptive() {
        isSeparatorAdaptive = !isSeparatorAdaptive;
        ItaTiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void toggleShowIcons() {
        showIcons = !showIcons;
        ItaTiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static class_2561 cycleItaTiersMode() {
        activeItaTiersMode = (Modes)ItaTiersClient.cycleEnum((Enum)activeItaTiersMode, (Enum[])Modes.getValues());
        ItaTiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return ItaTiersClient.activeItaTiersMode.label;
    }

    public static void cycleItaTiersPosition() {
        positionItaTiers = (DisplayStatus)ItaTiersClient.cycleEnum((Enum)positionItaTiers, (Enum[])DisplayStatus.values());
        ItaTiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleDisplayMode() {
        displayMode = (ModesTierDisplay)ItaTiersClient.cycleEnum((Enum)displayMode, (Enum[])ModesTierDisplay.values());
        ItaTiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    private static <T extends Enum<T>> T cycleEnum(T current, T[] values) {
        return values[(current.ordinal() + 1) % values.length];
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DisplayStatus {
        RIGHT,
        LEFT;


        public String getStatus() {
            if (this.toString().equalsIgnoreCase("RIGHT")) {
                return "Right";
            }
            return "Left";
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ModesTierDisplay {
        HIGHEST,
        SELECTED,
        ADAPTIVE_HIGHEST;


        public String getCurrentMode() {
            if (this.toString().equalsIgnoreCase("HIGHEST")) {
                return "Displayed Tiers: Highest";
            }
            if (this.toString().equalsIgnoreCase("SELECTED")) {
                return "Displayed Tiers: Selected";
            }
            return "Displayed Tiers: Adaptive Highest";
        }
    }
}

