/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers.profile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.itatiers.ItaTiersClient;
import com.itatiers.profile.GameMode;
import com.itatiers.profile.Status;
import com.itatiers.profile.types.ItaTiersProfile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

@Environment(value=EnvType.CLIENT)
public class PlayerProfile {
    public Status status = Status.SEARCHING;
    public String name = "";
    public String uuid = "";
    public UUID uuidObject;
    public ItaTiersProfile profileItaTiers;
    public class_2561 originalNameText;
    public boolean imageSaved = false;
    public int numberOfImageRequests = 0;
    private int numberOfRequests = 0;
    private final boolean regular;

    public PlayerProfile(String name, boolean regular) {
        this.regular = regular;
        this.name = name;
        this.originalNameText = class_2561.method_30163((String)name);
    }

    public PlayerProfile(String mojangJson, String jsonItaTiers) {
        this.regular = false;
        JsonObject jsonObject = JsonParser.parseString((String)mojangJson).getAsJsonObject();
        if (!jsonObject.has("name") || !jsonObject.has("id")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.name = jsonObject.get("name").getAsString();
        this.uuid = jsonObject.get("id").getAsString();
        this.originalNameText = class_2561.method_30163((String)this.name);
        class_2960 DEFAULT_IMAGE = class_2960.method_60655((String)"minecraft", (String)"textures/default.png");
        Path targetFile = FabricLoader.getInstance().getGameDir().resolve("cache/itatiers/da300ba3690b43228feacf1628825c88.png");
        try (InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(DEFAULT_IMAGE).orElseThrow()).method_14482();){
            if (inputStream == null) {
                throw new IOException();
            }
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ignored) {
            ItaTiersClient.LOGGER.warn("Error copying default image");
        }
        this.profileItaTiers = new ItaTiersProfile(jsonItaTiers);
        this.status = Status.READY;
    }

    public void buildItaTiersRequest() {
        if (!this.name.matches("^[a-zA-Z0-9_]{3,16}$") || this.name.contains(".")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        if (this.numberOfRequests > 4) {
            this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
            return;
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://www.mctiers.it/api/profile/" + this.name)).header("User-Agent", ItaTiersClient.userAgent).GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                if (response.statusCode() != 200) {
                    this.buildRequest();
                    return;
                }
                this.parseItaTiersJson((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(this::buildRequest);
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    public void buildRequest() {
        if (!this.name.matches("^[a-zA-Z0-9_]{3,16}$") || this.name.contains(".")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        if (this.numberOfRequests > 4) {
            this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
            return;
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://playerdb.co/api/player/minecraft/" + this.name)).header("User-Agent", ItaTiersClient.userAgent).GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                int statusCode = response.statusCode();
                if (statusCode == 400 || statusCode == 500) {
                    this.status = Status.NOT_EXISTING;
                    return;
                }
                if (statusCode != 200) {
                    this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
                    return;
                }
                this.parseJson((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(this::buildRequest);
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    public void buildRequest(String apiUrl) {
        if (this.numberOfRequests > 11 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl + this.name)).header("User-Agent", ItaTiersClient.userAgent).GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                if (((String)response.body()).contains("minecraft/profile/lookup")) {
                    this.status = Status.API_ISSUE;
                    return;
                }
                int statusCode = response.statusCode();
                if (statusCode == 404 || statusCode == 400) {
                    this.status = Status.NOT_EXISTING;
                    return;
                }
                if (statusCode == 403) {
                    CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest("https://api.minecraftservices.com/minecraft/profile/lookup/name/"));
                    return;
                }
                if (statusCode != 200) {
                    long delay = switch (this.numberOfRequests) {
                        case 1 -> 50L;
                        case 2, 3 -> 100L;
                        case 4, 5 -> 400L;
                        case 6, 7 -> 900L;
                        default -> 1500L;
                    };
                    CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(apiUrl));
                    return;
                }
                this.parseJson((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(apiUrl));
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    private void parseItaTiersJson(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (!jsonObject.has("username") || !jsonObject.has("uuid")) {
            this.buildRequest();
            return;
        }
        this.name = jsonObject.get("username").getAsString();
        this.uuid = jsonObject.get("uuid").getAsString();
        if (!this.regular) {
            this.savePlayerImage();
        }
        this.profileItaTiers = new ItaTiersProfile(json);
        this.status = Status.READY;
    }

    private void parseJson(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.has("code") && jsonObject.has("data") && jsonObject.has("success")) {
            JsonObject player;
            if (!jsonObject.get("success").getAsString().contains("true")) {
                this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
                return;
            }
            JsonObject data = jsonObject.getAsJsonObject("data");
            if (data.has("player") && (player = data.getAsJsonObject("player")).has("username") && player.has("raw_id") && player.has("id")) {
                this.name = player.get("username").getAsString();
                this.uuid = player.get("raw_id").getAsString();
                this.uuidObject = UUID.fromString(player.get("id").getAsString());
                this.originalNameText = class_2561.method_30163((String)this.name);
            }
        } else if (jsonObject.has("name") && jsonObject.has("id")) {
            this.name = jsonObject.get("name").getAsString();
            this.uuid = jsonObject.get("id").getAsString();
            this.originalNameText = class_2561.method_30163((String)this.name);
        }
        if (this.uuid.isEmpty()) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        if (!this.regular) {
            this.savePlayerImage();
        }
        this.profileItaTiers = new ItaTiersProfile(this.name, "https://www.mctiers.it/api/profile/");
        this.status = Status.READY;
    }

    public void savePlayerImage() {
        if (this.numberOfImageRequests == 5) {
            return;
        }
        ++this.numberOfImageRequests;
        String savePath = String.valueOf(FabricLoader.getInstance().getGameDir()) + "/cache/itatiers/" + (this.regular ? "players/" : "");
        CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(Paths.get(savePath, new String[0]), new FileAttribute[0]);
                URL uri = new URI("https://mc-heads.net/body/" + this.uuid).toURL();
                HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
                connection.setRequestProperty("User-Agent", ItaTiersClient.userAgent);
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try (InputStream inputStream = connection.getInputStream();){
                    BufferedImage image = ImageIO.read(inputStream);
                    File outputFile = new File(savePath + this.uuid + ".png");
                    ImageIO.write((RenderedImage)image, "png", outputFile);
                    this.imageSaved = true;
                }
            }
            catch (IOException | URISyntaxException ignored) {
                CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(this::savePlayerImage);
            }
        });
    }

    public void resetDrawnStatus() {
        if (this.profileItaTiers == null) {
            return;
        }
        this.profileItaTiers.drawn = false;
        for (GameMode mode : this.profileItaTiers.gameModes) {
            mode.drawn = false;
        }
    }
}

