/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers;

import com.itatiers.ItaTiersClient;
import com.itatiers.misc.ConfigManager;
import com.itatiers.misc.Modes;
import com.itatiers.textures.ColorControl;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class InventoryChecker {
    private static final Set<class_1792> SWORD_NON_ALLOWED = Set.of(class_1802.field_8556, class_1802.field_8786, class_1802.field_8255, class_1802.field_8634, class_1802.field_8287, class_1802.field_8436, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> UHC_NON_ALLOWED = Set.of(class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> POT_NON_ALLOWED = Set.of(class_1802.field_8556, class_1802.field_8463, class_1802.field_8255, class_1802.field_8786, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> NETHPOT_NON_ALLOWED = Set.of(class_1802.field_8634, class_1802.field_8255, class_1802.field_22025, class_1802.field_22024, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> SMP_NON_ALLOWED = Set.of(class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22024, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> AXE_NON_ALLOWED = Set.of(class_1802.field_8634, class_1802.field_8786, class_1802.field_8463, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);

    public static void checkInventory(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        Modes detected = null;
        class_1661 inventory = client.field_1724.method_31548();
        if (InventoryChecker.checkVanilla(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.VANILLA;
            detected = Modes.VANILLA;
        }
        if (InventoryChecker.checkSword(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.SWORD;
            detected = Modes.SWORD;
        }
        if (InventoryChecker.checkUhc(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.UHC;
            detected = Modes.UHC;
        }
        if (InventoryChecker.checkPot(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.POT;
            detected = Modes.POT;
        }
        if (InventoryChecker.checkNethPot(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.NETH_POT;
            detected = Modes.NETH_POT;
        }
        if (InventoryChecker.checkSmp(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.SMP;
            detected = Modes.SMP;
        }
        if (InventoryChecker.checkAxe(inventory)) {
            ItaTiersClient.activeItaTiersMode = Modes.AXE;
            detected = Modes.AXE;
        }
        if (detected != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"").method_10852(detected.label).method_10852((class_2561)class_2561.method_43470((String)" was detected").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text")))), true);
        } else {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"No gamemode detected").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("red"))), true);
        }
        ConfigManager.saveConfig();
    }

    private static boolean checkVanilla(class_1661 inventory) {
        boolean hasObsidian = false;
        boolean hasCrystal = false;
        boolean hasAnchor = false;
        boolean hasGlowstone = false;
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasObsidian |= InventoryChecker.hasItem(stack, class_1802.field_8281);
            hasCrystal |= InventoryChecker.hasItem(stack, class_1802.field_8301);
            hasAnchor |= InventoryChecker.hasItem(stack, class_1802.field_23141);
            hasGlowstone |= InventoryChecker.hasItem(stack, class_1802.field_8801);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
        }
        return hasObsidian && hasCrystal && hasAnchor && hasGlowstone && hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkSword(class_1661 inventory) {
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285);
            if (!SWORD_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkUhc(class_1661 inventory) {
        boolean hasShield = false;
        boolean hasGaps = false;
        boolean hasLava = false;
        boolean hasWater = false;
        boolean hasCobwebs = false;
        boolean hasEnchantedBow = false;
        boolean hasEnchantedCrossbow = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasLava |= InventoryChecker.hasItem(stack, class_1802.field_8187);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasCobwebs |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasEnchantedBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasEnchantedCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, true);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_8556, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true) || InventoryChecker.hasItem(stack, class_1802.field_8396, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!UHC_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasShield && hasGaps && hasLava && hasWater && hasCobwebs && hasEnchantedBow && hasEnchantedCrossbow && hasEnchantedSword && hasEnchantedAxe && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkPot(class_1661 inventory) {
        boolean hasSteak = false;
        boolean hasPotions = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasSteak |= InventoryChecker.hasItem(stack, class_1802.field_8176);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!POT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSteak && hasPotions && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkNethPot(class_1661 inventory) {
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!NETHPOT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasPotions && hasTotem && hasXp && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkSmp(class_1661 inventory) {
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasPearls = false;
        boolean hasShield = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_22025, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!SMP_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasPotions && hasTotem && hasXp && hasPearls && hasShield && hasEnchantedAxe && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkAxe(class_1661 inventory) {
        boolean hasBow = false;
        boolean hasCrossbow = false;
        boolean hasShield = false;
        boolean hasSword = false;
        boolean hasAxe = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, false);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, false);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255, false);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, false);
            hasAxe |= InventoryChecker.hasItem(stack, class_1802.field_8556, false);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, false);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, false);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, false);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, false);
            if (!AXE_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasBow && hasCrossbow && hasShield && hasSword && hasAxe && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean hasItem(class_1799 itemStack, class_1792 item, boolean needEnchant) {
        return itemStack.method_7909() == item && needEnchant == itemStack.method_7942();
    }

    private static boolean hasItem(class_1799 itemStack, class_1792 item) {
        return itemStack.method_7909() == item;
    }
}

