/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers.screens;

import com.itatiers.ItaTiersClient;
import com.itatiers.profile.GameMode;
import com.itatiers.profile.PlayerProfile;
import com.itatiers.profile.Status;
import com.itatiers.profile.types.SuperProfile;
import com.itatiers.textures.ColorControl;
import com.itatiers.textures.Icons;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class PlayerSearchResultScreen
extends class_437 {
    private final PlayerProfile playerProfile;
    private class_2960 playerAvatarTexture;
    private int separator;
    private boolean imageReady = false;

    public PlayerSearchResultScreen(PlayerProfile playerProfile) {
        super((class_2561)class_2561.method_43470((String)playerProfile.name));
        this.playerProfile = playerProfile;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.playerProfile.status == Status.NOT_EXISTING) {
            this.method_25419();
            ItaTiersClient.sendMessageToPlayer(this.playerProfile.name + " was not found or isn't a premium account", ColorControl.getColor("red"), false);
            return;
        }
        if (this.playerProfile.status == Status.TIMEOUTED) {
            this.method_25419();
            ItaTiersClient.sendMessageToPlayer(this.playerProfile.name + "'s search was timeouted. Clear cache and retry", ColorControl.getColor("red"), false);
            return;
        }
        if (this.playerProfile.status == Status.API_ISSUE) {
            this.method_25419();
            ItaTiersClient.sendMessageToPlayer(this.playerProfile.name + "'s search failed. This is likely a Mojang issue. Contact flavio6561 on Discord for support", ColorControl.getColor("red"), false);
            return;
        }
        int centerX = this.field_22789 / 2;
        int listY = (int)((double)this.field_22790 / 3.2);
        this.separator = this.field_22790 / 23;
        int avatarY = this.field_22790 / 55 + 14;
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.playerProfile.status == Status.SEARCHING) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Searching for " + this.playerProfile.name + "...")), centerX, listY, ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (this.playerProfile.numberOfImageRequests == 0) {
            this.playerProfile.savePlayerImage();
        }
        this.drawPlayerAvatar(context, centerX, avatarY);
        context.method_27534(this.field_22793, ItaTiersClient.getNametag(this.playerProfile), centerX, this.field_22790 / 55, ColorControl.getColorMinecraftStandard("text"));
        this.drawCategoryList(context, this.playerProfile.profileItaTiers, centerX, listY);
    }

    private void drawCategoryList(class_332 context, SuperProfile profile, int x, int y) {
        if (profile == null) {
            context.method_25300(this.field_22793, "Loading from API...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (profile.status == Status.SEARCHING) {
            context.method_25300(this.field_22793, "Searching...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (profile.status == Status.NOT_EXISTING) {
            context.method_25300(this.field_22793, "Unranked", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (profile.status == Status.TIMEOUTED) {
            context.method_25300(this.field_22793, "Search timeouted. Clear cache and retry", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (profile.status == Status.API_ISSUE) {
            context.method_25300(this.field_22793, "Search failed. This is likely an API issue", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            context.method_25300(this.field_22793, "Contact flavio6561 on Discord for support", x, (int)((double)y + 2.8 * (double)this.separator + 15.0), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (!profile.drawn) {
            class_7842 overallLabel = new class_7842(class_2561.method_30163((String)"Points"), this.field_22793);
            overallLabel.method_48229(x - 42, (int)((double)y + 2.4 * (double)this.separator));
            overallLabel.method_46438(ColorControl.getColor("points"));
            this.method_37063((class_364)overallLabel);
            class_7842 overallIcon = new class_7842(Icons.OVERALL, this.field_22793);
            overallIcon.method_48229(x - 62, (int)((double)y + 2.4 * (double)this.separator + 2.0));
            overallIcon.method_46438(ColorControl.getColor("points"));
            this.method_37063((class_364)overallIcon);
            class_7842 overall = new class_7842(profile.displayedPoints, this.field_22793);
            overall.method_48229(x + 45 - (profile.displayedPoints.getString().length() - 2) * 3, (int)((double)y + 2.4 * (double)this.separator));
            overall.method_47400(class_7919.method_47407((class_2561)profile.pointsTooltip));
            this.method_37063((class_364)overall);
            this.drawTierList(profile, x - 62, (int)((double)y + 2.4 * (double)this.separator) + 30);
            profile.drawn = true;
        }
    }

    private void drawTierList(SuperProfile profile, int x, int y) {
        for (GameMode gameMode : profile.gameModes) {
            if (!this.drawGameModeTiers(gameMode, x, y)) continue;
            y += 15;
        }
    }

    private boolean drawGameModeTiers(GameMode mode, int x, int y) {
        if (mode.drawn || mode.status != Status.READY) {
            return false;
        }
        class_7842 icon = new class_7842(mode.name.icon, this.field_22793);
        icon.method_48229(x, y + 3);
        this.method_37063((class_364)icon);
        class_7842 label = new class_7842(mode.name.label, this.field_22793);
        label.method_48229(x + 20, y);
        this.method_37063((class_364)label);
        class_7842 tier = new class_7842(mode.displayedTier, this.field_22793);
        tier.method_48229(x + 105 - (mode.displayedTier.getString().length() - 3) * 3, y);
        tier.method_47400(class_7919.method_47407((class_2561)mode.tierTooltip));
        this.method_37063((class_364)tier);
        mode.drawn = true;
        return true;
    }

    private void drawPlayerAvatar(class_332 context, int x, int y) {
        if (this.playerAvatarTexture != null && this.imageReady) {
            context.method_25290(class_1921::method_62277, this.playerAvatarTexture, x - this.field_22789 / 32, y, 0.0f, 0.0f, this.field_22789 / 16, (int)((double)this.field_22789 / 6.666), this.field_22789 / 16, (int)((double)this.field_22789 / 6.666));
        } else if (this.playerProfile.imageSaved) {
            this.loadPlayerAvatar();
        } else if (this.playerProfile.numberOfImageRequests == 5) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(this.playerProfile.name + "'s skin failed to load. Clear cache and retry")), x, y + 50, ColorControl.getColorMinecraftStandard("red"));
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Loading " + this.playerProfile.name + "'s skin")), x, y + 50, ColorControl.getColorMinecraftStandard("green"));
        }
    }

    private void loadPlayerAvatar() {
        File avatarFile = FabricLoader.getInstance().getGameDir().resolve("cache/itatiers/players/" + this.playerProfile.uuid + ".png").toFile();
        if (!avatarFile.exists()) {
            return;
        }
        try (FileInputStream stream = new FileInputStream(avatarFile);){
            this.playerAvatarTexture = class_2960.method_60655((String)"players", (String)this.playerProfile.uuid);
            class_310.method_1551().method_1531().method_4616(this.playerAvatarTexture, (class_1044)new class_1043(class_1011.method_4309((InputStream)stream)));
            this.imageReady = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void method_25426() {
        this.playerProfile.resetDrawnStatus();
    }
}

