/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers.misc;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.itatiers.ItaTiersClient;
import com.itatiers.misc.Modes;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static Config config;
    private static final Path CONFIG_PATH;

    public static void loadConfig() {
        Gson gson = new Gson();
        File configFile = CONFIG_PATH.toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                if (config == null) {
                    ConfigManager.restoreFromClient();
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                ConfigManager.restoreFromClient();
            }
        } else {
            ConfigManager.restoreFromClient();
        }
        ItaTiersClient.toggleMod = ConfigManager.config.toggleMod;
        ItaTiersClient.showIcons = ConfigManager.config.showIcons;
        ItaTiersClient.isSeparatorAdaptive = ConfigManager.config.isSeparatorAdaptive;
        if (Arrays.stream(ItaTiersClient.ModesTierDisplay.values()).toList().contains((Object)ConfigManager.config.displayMode)) {
            ItaTiersClient.displayMode = ConfigManager.config.displayMode;
        }
        if (Arrays.stream(ItaTiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.positionItaTiers)) {
            ItaTiersClient.positionItaTiers = ConfigManager.config.positionItaTiers;
        }
        if (Arrays.stream(Modes.values()).toList().contains((Object)ConfigManager.config.activeItaTiersMode)) {
            ItaTiersClient.activeItaTiersMode = ConfigManager.config.activeItaTiersMode;
        }
        ItaTiersClient.anonymousUserAgent = ConfigManager.config.anonymousUserAgent;
        ConfigManager.saveConfig();
    }

    private static void restoreFromClient() {
        config = new Config();
        ConfigManager.config.toggleMod = ItaTiersClient.toggleMod;
        ConfigManager.config.showIcons = ItaTiersClient.showIcons;
        ConfigManager.config.isSeparatorAdaptive = ItaTiersClient.isSeparatorAdaptive;
        ConfigManager.config.displayMode = ItaTiersClient.displayMode;
        ConfigManager.config.positionItaTiers = ItaTiersClient.positionItaTiers;
        ConfigManager.config.activeItaTiersMode = ItaTiersClient.activeItaTiersMode;
        ConfigManager.config.anonymousUserAgent = ItaTiersClient.anonymousUserAgent;
        ConfigManager.saveConfig();
    }

    public static void saveConfig() {
        Gson gson = new Gson();
        File configFile = CONFIG_PATH.toFile();
        Config currentConfig = new Config();
        currentConfig.toggleMod = ItaTiersClient.toggleMod;
        currentConfig.showIcons = ItaTiersClient.showIcons;
        currentConfig.isSeparatorAdaptive = ItaTiersClient.isSeparatorAdaptive;
        currentConfig.displayMode = ItaTiersClient.displayMode;
        currentConfig.positionItaTiers = ItaTiersClient.positionItaTiers;
        currentConfig.activeItaTiersMode = ItaTiersClient.activeItaTiersMode;
        currentConfig.anonymousUserAgent = ItaTiersClient.anonymousUserAgent;
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)currentConfig, (Appendable)writer);
        }
        catch (IOException exception) {
            ConfigManager.restoreFromClient();
        }
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("ItaTiers.json");
    }

    @Environment(value=EnvType.CLIENT)
    private static class Config {
        boolean toggleMod = true;
        boolean showIcons = true;
        boolean isSeparatorAdaptive = true;
        ItaTiersClient.ModesTierDisplay displayMode;
        ItaTiersClient.DisplayStatus positionItaTiers;
        Modes activeItaTiersMode;
        boolean anonymousUserAgent;

        private Config() {
        }
    }
}

