/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers.profile;

import com.google.gson.JsonElement;
import com.itatiers.misc.Modes;
import com.itatiers.profile.Status;
import com.itatiers.textures.ColorControl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

@Environment(value=EnvType.CLIENT)
public class GameMode {
    public Status status = Status.SEARCHING;
    private String tier;
    public class_2561 displayedTier;
    private String displayedTierUnformatted;
    public class_2561 tierTooltip;
    public final Modes name;
    public final String parsingName;
    public boolean drawn = false;

    public GameMode(Modes name, String parsingName) {
        this.name = name;
        this.parsingName = parsingName;
    }

    public void parseTiers(JsonElement jsonElement) {
        this.displayedTierUnformatted = jsonElement.getAsString();
        this.tier = String.valueOf(this.displayedTierUnformatted.toCharArray()[2]);
        this.displayedTier = class_2561.method_43470((String)this.displayedTierUnformatted).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedTierUnformatted)));
        this.tierTooltip = this.getTierTooltip();
        this.status = Status.READY;
    }

    private class_2561 getTierTooltip() {
        Object tierTooltipString = "";
        if (this.displayedTierUnformatted.contains("R")) {
            tierTooltipString = (String)tierTooltipString + "Retired ";
        }
        tierTooltipString = this.displayedTierUnformatted.contains("H") ? (String)tierTooltipString + "High " : (String)tierTooltipString + "Low ";
        tierTooltipString = (String)tierTooltipString + "Tier " + this.tier + "\n\nPoints: " + this.getTierPoints();
        return class_2561.method_43470((String)tierTooltipString).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedTierUnformatted)));
    }

    public int getTierPoints() {
        if (this.status == Status.NOT_EXISTING) {
            return 0;
        }
        String tier = this.displayedTierUnformatted;
        if ((tier = tier.replace("R", "")).equalsIgnoreCase("HT1")) {
            return 60;
        }
        if (tier.equalsIgnoreCase("LT1")) {
            return 44;
        }
        if (tier.equalsIgnoreCase("HT2")) {
            return 28;
        }
        if (tier.equalsIgnoreCase("LT2")) {
            return 16;
        }
        if (tier.equalsIgnoreCase("HT3")) {
            return 10;
        }
        if (tier.equalsIgnoreCase("LT3")) {
            return 6;
        }
        if (tier.equalsIgnoreCase("HT4")) {
            return 4;
        }
        if (tier.equalsIgnoreCase("LT4")) {
            return 3;
        }
        if (tier.equalsIgnoreCase("HT5")) {
            return 2;
        }
        if (tier.equalsIgnoreCase("LT5")) {
            return 1;
        }
        return 0;
    }

    private int getTierColor(String tier) {
        if (tier.contains("R")) {
            return ColorControl.getColor("retired");
        }
        if (tier.equalsIgnoreCase("HT1")) {
            return ColorControl.getColor("ht1");
        }
        if (tier.equalsIgnoreCase("LT1")) {
            return ColorControl.getColor("lt1");
        }
        if (tier.equalsIgnoreCase("HT2")) {
            return ColorControl.getColor("ht2");
        }
        if (tier.equalsIgnoreCase("LT2")) {
            return ColorControl.getColor("lt2");
        }
        if (tier.equalsIgnoreCase("HT3")) {
            return ColorControl.getColor("ht3");
        }
        if (tier.equalsIgnoreCase("LT3")) {
            return ColorControl.getColor("lt3");
        }
        if (tier.equalsIgnoreCase("HT4")) {
            return ColorControl.getColor("ht4");
        }
        if (tier.equalsIgnoreCase("LT4")) {
            return ColorControl.getColor("lt4");
        }
        if (tier.equalsIgnoreCase("HT5")) {
            return ColorControl.getColor("ht5");
        }
        if (tier.equalsIgnoreCase("LT5")) {
            return ColorControl.getColor("lt5");
        }
        return ColorControl.getColor("unknown");
    }
}

