/*
 * Decompiled with CFR 0.152.
 */
package com.itatiers.profile.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.itatiers.ItaTiersClient;
import com.itatiers.misc.Modes;
import com.itatiers.profile.GameMode;
import com.itatiers.profile.Status;
import com.itatiers.textures.ColorControl;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

@Environment(value=EnvType.CLIENT)
public class SuperProfile {
    public Status status = Status.SEARCHING;
    public int points;
    public int overall;
    public class_2561 displayedPoints;
    public class_2561 pointsTooltip;
    public final ArrayList<GameMode> gameModes = new ArrayList();
    public GameMode highest;
    public String originalJson;
    public boolean drawn = false;
    private int numberOfRequests = 0;

    protected SuperProfile(String name, String apiUrl) {
        CompletableFuture.delayedExecutor(20L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(name, apiUrl));
    }

    protected SuperProfile(String json) {
        CompletableFuture.delayedExecutor(20L, TimeUnit.MILLISECONDS).execute(() -> this.parseJson(json));
    }

    private void buildRequest(String name, String apiUrl) {
        if (this.numberOfRequests == 5 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl + name)).header("User-Agent", ItaTiersClient.userAgent).GET().build();
        ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            if (response.statusCode() == 404) {
                this.status = Status.NOT_EXISTING;
                return;
            }
            if (response.statusCode() != 200) {
                this.status = Status.API_ISSUE;
                return;
            }
            this.parseJson((String)response.body());
        })).exceptionally(exception -> {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(name, apiUrl));
            return null;
        });
    }

    public void parseJson(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (!(jsonObject.has("username") && jsonObject.has("uuid") && jsonObject.has("tiers") && jsonObject.has("points") && jsonObject.has("rank"))) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.overall = jsonObject.get("rank").getAsInt();
        this.points = jsonObject.get("points").getAsInt();
        this.displayedPoints = this.getPointsText();
        this.pointsTooltip = this.getPointsTooltip();
        this.parseRankings(jsonObject.getAsJsonObject("tiers"));
        this.status = Status.READY;
        this.originalJson = json;
    }

    private void parseRankings(JsonObject jsonObject) {
        for (GameMode gameMode : this.gameModes) {
            if (jsonObject.has(gameMode.parsingName)) {
                gameMode.parseTiers(jsonObject.get(gameMode.parsingName));
                continue;
            }
            gameMode.status = Status.NOT_EXISTING;
        }
        this.highest = this.getHighestMode();
    }

    public GameMode getGameMode(Modes gamemode) {
        for (GameMode gameMode : this.gameModes) {
            if (!gameMode.name.toString().equalsIgnoreCase(gamemode.toString())) continue;
            return gameMode;
        }
        this.status = Status.NOT_EXISTING;
        return null;
    }

    private GameMode getHighestMode() {
        GameMode highest = null;
        int highestPoints = 0;
        for (GameMode gameMode : this.gameModes) {
            if (gameMode.status != Status.READY || gameMode.getTierPoints() <= highestPoints) continue;
            highest = gameMode;
            highestPoints = gameMode.getTierPoints();
        }
        return highest;
    }

    private class_2561 getPointsText() {
        if (this.points >= 200) {
            return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("master")));
        }
        if (this.points >= 100) {
            return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("ace")));
        }
        if (this.points >= 50) {
            return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("specialist")));
        }
        if (this.points >= 20) {
            return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("cadet")));
        }
        if (this.points >= 10) {
            return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("novice")));
        }
        return class_2561.method_43470((String)String.valueOf(this.points)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("rookie")));
    }

    private class_2561 getPointsTooltip() {
        Object overallTooltip = "Combat ";
        overallTooltip = this.points >= 200 ? (String)overallTooltip + "Master" : (this.points >= 100 ? (String)overallTooltip + "Ace" : (this.points >= 50 ? (String)overallTooltip + "Specialist" : (this.points >= 20 ? (String)overallTooltip + "Cadet" : (this.points >= 10 ? (String)overallTooltip + "Novice" : "Rookie"))));
        overallTooltip = (String)overallTooltip + "\nOverall: #" + this.overall;
        return class_2561.method_43470((String)overallTooltip).method_10862(this.displayedPoints.method_10866());
    }
}

