/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MyLogger {
    private final BigDoors plugin;
    private final File logFile;

    public MyLogger(BigDoors plugin, File logFile) {
        this.plugin = plugin;
        this.logFile = logFile;
        this.loadLog();
    }

    public void loadLog() {
        if (!this.logFile.exists()) {
            try {
                this.logFile.getParentFile().mkdirs();
                this.logFile.createNewFile();
                this.myLogger(Level.INFO, "New file created at " + this.logFile);
            }
            catch (IOException e) {
                this.myLogger(Level.SEVERE, "File write error: " + this.logFile);
                e.printStackTrace();
            }
        }
    }

    public void myLogger(Level level, String str) {
        Bukkit.getLogger().log(level, "[" + this.plugin.getName() + "] " + str);
    }

    public void returnToSender(CommandSender sender, Level level, ChatColor color, String str) {
        if (sender instanceof Player) {
            Util.messagePlayer((Player)sender, color + str);
        } else {
            this.myLogger(level, ChatColor.stripColor((String)str));
        }
    }

    public void logMessage(Level level, String msg) {
        this.logMessage(msg, true, false, level);
    }

    public void logMessage(String msg, boolean printToConsole, boolean startSkip, Level level) {
        if (printToConsole) {
            this.myLogger(level, msg);
        }
        if (this.plugin.getConfigLoader() != null && !this.plugin.getConfigLoader().enableFileLogging()) {
            return;
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.logFile, true));
            Date now = new Date();
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            if (startSkip) {
                bw.write("\n\n[" + format.format(now) + "] " + msg);
            } else {
                bw.write("[" + format.format(now) + "] " + msg);
            }
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            this.myLogger(Level.SEVERE, "Logging error! Could not log to logFile!");
            e.printStackTrace();
        }
    }

    public void logMessage(String msg, boolean printToConsole, boolean startSkip) {
        this.logMessage(msg, printToConsole, startSkip, Level.WARNING);
    }

    public void logMessageToLogFile(String msg) {
        this.logMessage(msg, false, false);
    }

    public void logMessageToConsole(String msg) {
        this.logMessage(msg, true, false);
    }

    public void logMessageToConsoleOnly(String msg) {
        this.info(msg);
    }

    public void debug(String str) {
        if (ConfigLoader.DEBUG) {
            this.myLogger(Level.INFO, str);
        }
    }

    public void info(String str) {
        this.myLogger(Level.INFO, str);
    }

    public void warn(String str) {
        this.myLogger(Level.WARNING, str);
        this.logMessage(str, false, false);
    }

    public void severe(String str) {
        this.myLogger(Level.SEVERE, str);
        this.logMessage(str, false, false);
    }

    public static void logMessage(Level level, String pluginName, String message) {
        Bukkit.getLogger().log(level, "[" + pluginName + "] " + message);
    }

    public void log(Throwable throwable) {
        this.severe(Util.throwableToString(throwable));
    }

    public void log(String message, Throwable throwable) {
        this.severe(message + "\n" + Util.throwableToString(throwable));
    }
}

