/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.NMS;

import java.util.Objects;
import nl.pim16aap2.bigDoors.NMS.CustomCraftFallingBlock;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.util.LazyInit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public interface FallingBlockFactory {
    public static final boolean SUPPORTS_PERSISTENT_DATA_CONTAINER = Helper.access$000();
    public static final String ENTITY_NAME = "BigDoorsEntity";
    @Nullable
    public static final LazyInit<NamespacedKey> ENTITY_KEY = !SUPPORTS_PERSISTENT_DATA_CONTAINER ? null : new LazyInit<NamespacedKey>(() -> new NamespacedKey(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("BigDoors")), "bigdoors_entity"));

    public CustomCraftFallingBlock createFallingBlock(Location var1, NMSBlock var2, byte var3, Material var4);

    default public CustomCraftFallingBlock createFallingBlockWithMetadata(Specification data, Location loc, NMSBlock block, byte matData, Material mat) {
        CustomCraftFallingBlock entity = this.createFallingBlock(loc, block, matData, mat);
        this.setFallingBlockMetadata(data, entity);
        return entity;
    }

    default public void setFallingBlockMetadata(Specification data, CustomCraftFallingBlock entity) {
        if (data.setCustomName) {
            entity.setCustomName(ENTITY_NAME);
            entity.setCustomNameVisible(false);
        }
        if (ENTITY_KEY != null) {
            entity.getPersistentDataContainer().set(ENTITY_KEY.get(), PersistentDataType.BYTE, (Object)1);
        }
    }

    public NMSBlock nmsBlockFactory(World var1, int var2, int var3, int var4);

    default public boolean isBigDoorsEntity(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        if (ENTITY_NAME.equals(entity.getCustomName())) {
            return true;
        }
        return ENTITY_KEY != null && entity.getPersistentDataContainer().has(ENTITY_KEY.get(), PersistentDataType.BYTE);
    }

    public static final class Specification {
        private final boolean setCustomName;

        public Specification(boolean setCustomName) {
            this.setCustomName = setCustomName || !SUPPORTS_PERSISTENT_DATA_CONTAINER;
        }
    }

    public static final class Helper {
        private static boolean supportsPersistentDataContainer() {
            try {
                Class.forName("org.bukkit.persistence.PersistentDataContainer");
                return true;
            }
            catch (ClassNotFoundException ignored) {
                return false;
            }
        }

        static /* synthetic */ boolean access$000() {
            return Helper.supportsPersistentDataContainer();
        }
    }
}

