/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.NMS;

import java.util.Set;
import net.minecraft.server.v1_13_R1.Block;
import net.minecraft.server.v1_13_R1.BlockPosition;
import net.minecraft.server.v1_13_R1.BlockRotatable;
import net.minecraft.server.v1_13_R1.EnumBlockRotation;
import net.minecraft.server.v1_13_R1.EnumDirection;
import net.minecraft.server.v1_13_R1.IBlockData;
import net.minecraft.server.v1_13_R1.IBlockState;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Fence;
import org.bukkit.craftbukkit.v1_13_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_13_R1.block.data.CraftBlockData;

public class NMSBlock_V1_13_R1
extends Block
implements NMSBlock {
    private IBlockData blockData;
    private CraftBlockData craftBlockData;
    private XMaterial xmat;
    private Location loc;

    public NMSBlock_V1_13_R1(World world, int x, int y, int z) {
        super(Block.Info.a((Block)((CraftWorld)world).getHandle().getType(new BlockPosition(x, y, z)).getBlock()));
        this.loc = new Location(world, (double)x, (double)y, (double)z);
        this.craftBlockData = (CraftBlockData)((CraftBlock)world.getBlockAt(x, y, z)).getBlockData();
        if (this.craftBlockData instanceof Waterlogged) {
            ((Waterlogged)this.craftBlockData).setWaterlogged(false);
        }
        this.constructBlockDataFromBukkit();
        this.xmat = XMaterial.matchXMaterial(world.getBlockAt(x, y, z).getType().toString()).orElse(XMaterial.BEDROCK);
        super.v(this.blockData);
    }

    @Override
    public boolean canRotate() {
        return this.craftBlockData instanceof MultipleFacing;
    }

    @Override
    public void rotateBlock(RotateDirection rotDir) {
        EnumBlockRotation rot;
        switch (rotDir) {
            case CLOCKWISE: {
                rot = EnumBlockRotation.CLOCKWISE_90;
                break;
            }
            case COUNTERCLOCKWISE: {
                rot = EnumBlockRotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                rot = EnumBlockRotation.NONE;
            }
        }
        this.blockData = this.blockData.a(rot);
    }

    private void constructBlockDataFromBukkit() {
        this.blockData = this.craftBlockData.getState();
    }

    @Override
    public void putBlock(Location loc) {
        this.loc = loc;
        if (this.craftBlockData instanceof MultipleFacing) {
            this.updateCraftBlockDataMultipleFacing();
        }
        ((CraftWorld)loc.getWorld()).getHandle().setTypeAndData(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), this.blockData, 1);
    }

    private void updateCraftBlockDataMultipleFacing() {
        Set allowedFaces = ((MultipleFacing)this.craftBlockData).getAllowedFaces();
        allowedFaces.forEach(K -> {
            org.bukkit.block.Block otherBlock = this.loc.clone().add((double)K.getModX(), (double)K.getModY(), (double)K.getModZ()).getBlock();
            CraftBlockData otherData = (CraftBlockData)((CraftBlock)otherBlock).getBlockData();
            if (K.equals((Object)BlockFace.UP)) {
                ((MultipleFacing)this.craftBlockData).setFace(K, true);
            } else if (otherBlock.getType().isSolid()) {
                ((MultipleFacing)this.craftBlockData).setFace(K, true);
                if (otherData instanceof MultipleFacing && (otherBlock.getType().equals((Object)this.xmat.parseMaterial()) || this.craftBlockData instanceof Fence && otherData instanceof Fence) && ((MultipleFacing)otherData).getAllowedFaces().contains(K.getOppositeFace())) {
                    ((MultipleFacing)otherData).setFace(K.getOppositeFace(), true);
                    ((CraftBlock)otherBlock).setBlockData((BlockData)otherData);
                }
            } else {
                ((MultipleFacing)this.craftBlockData).setFace(K, false);
            }
        });
        this.constructBlockDataFromBukkit();
    }

    @Override
    public void rotateBlockUpDown(boolean NS) {
        EnumDirection.EnumAxis axis;
        EnumDirection.EnumAxis newAxis = axis = (EnumDirection.EnumAxis)this.blockData.get((IBlockState)BlockRotatable.AXIS);
        switch (axis) {
            case X: {
                newAxis = NS ? EnumDirection.EnumAxis.X : EnumDirection.EnumAxis.Y;
                break;
            }
            case Y: {
                newAxis = NS ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
                break;
            }
            case Z: {
                newAxis = NS ? EnumDirection.EnumAxis.Y : EnumDirection.EnumAxis.Z;
            }
        }
        this.blockData = (IBlockData)this.blockData.set((IBlockState)BlockRotatable.AXIS, (Comparable)newAxis);
    }

    @Override
    public void rotateCylindrical(RotateDirection rotDir) {
        this.blockData = rotDir.equals((Object)RotateDirection.CLOCKWISE) ? this.blockData.a(EnumBlockRotation.CLOCKWISE_90) : this.blockData.a(EnumBlockRotation.COUNTERCLOCKWISE_90);
    }

    @Override
    public String toString() {
        return this.blockData.toString();
    }

    @Override
    public void deleteOriginalBlock(boolean applyPhysics) {
        if (!applyPhysics) {
            this.loc.getWorld().getBlockAt(this.loc).setType(Material.AIR, applyPhysics);
        } else {
            this.loc.getWorld().getBlockAt(this.loc).setType(Material.CAVE_AIR, false);
            this.loc.getWorld().getBlockAt(this.loc).setType(Material.AIR, true);
        }
    }
}

