/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.NMS;

import com.mojang.serialization.MapCodec;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.LazyInit;
import nl.pim16aap2.bigDoors.util.NMSUtil;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Fence;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;

public class NMSBlock_V1_21_R2
extends BlockBase
implements NMSBlock {
    private static final Field FIELD_BLOCK_MAP_CODEC = NMSBlock_V1_21_R2.getFieldBlockMapCodec();
    private final LazyInit<MapCodec<? extends Block>> blockMapCodec;
    private IBlockData blockData;
    private CraftBlockData craftBlockData;
    private final XMaterial xmat;
    private Location loc;

    private static Field getFieldBlockMapCodec() {
        try {
            Field field = IBlockDataHolder.class.getDeclaredField("e");
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }

    public NMSBlock_V1_21_R2(World world, int x, int y, int z, BlockBase.Info blockInfo) {
        super(blockInfo);
        this.loc = new Location(world, (double)x, (double)y, (double)z);
        this.craftBlockData = (CraftBlockData)world.getBlockAt(x, y, z).getBlockData();
        if (this.craftBlockData instanceof Waterlogged) {
            ((Waterlogged)this.craftBlockData).setWaterlogged(false);
        }
        this.updateBlockData();
        this.xmat = XMaterial.matchXMaterial(world.getBlockAt(x, y, z).getType().toString()).orElse(XMaterial.BEDROCK);
        this.blockMapCodec = new LazyInit<MapCodec>(() -> {
            try {
                return (MapCodec)FIELD_BLOCK_MAP_CODEC.get(this.blockData.b());
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException("Failed to get block map codec!", e2);
            }
        });
    }

    @Override
    public boolean canRotate() {
        return this.craftBlockData instanceof MultipleFacing;
    }

    @Override
    public void rotateBlock(RotateDirection rotDir) {
        EnumBlockRotation rot;
        switch (rotDir) {
            case CLOCKWISE: {
                rot = EnumBlockRotation.b;
                break;
            }
            case COUNTERCLOCKWISE: {
                rot = EnumBlockRotation.d;
                break;
            }
            default: {
                rot = EnumBlockRotation.a;
            }
        }
        this.blockData = this.blockData.a(rot);
        this.updateCraftBlockData();
    }

    private void updateBlockData() {
        this.blockData = this.craftBlockData.getState();
    }

    private void updateCraftBlockData() {
        this.craftBlockData = CraftBlockData.fromData((IBlockData)this.blockData);
    }

    @Override
    public void putBlock(Location loc) {
        this.loc = loc;
        if (this.craftBlockData instanceof MultipleFacing) {
            this.updateCraftBlockDataMultipleFacing();
        }
        CraftWorld craftWorld = Objects.requireNonNull((CraftWorld)loc.getWorld());
        craftWorld.getHandle().a(BlockPosition.a((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()), this.blockData, 1);
    }

    private void updateCraftBlockDataMultipleFacing() {
        Set allowedFaces = ((MultipleFacing)this.craftBlockData).getAllowedFaces();
        allowedFaces.forEach(blockFace -> {
            org.bukkit.block.Block otherBlock = this.loc.clone().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ()).getBlock();
            BlockData otherData = otherBlock.getBlockData();
            if (blockFace.equals((Object)BlockFace.UP)) {
                ((MultipleFacing)this.craftBlockData).setFace(blockFace, true);
            } else if (otherBlock.getType().isSolid()) {
                Set otherAllowedFaces;
                boolean areBothFence;
                ((MultipleFacing)this.craftBlockData).setFace(blockFace, true);
                boolean isOtherMultipleFacing = otherData instanceof MultipleFacing;
                boolean materialMatch = otherBlock.getType().equals((Object)this.xmat.parseMaterial());
                boolean bl = areBothFence = this.craftBlockData instanceof Fence && otherData instanceof Fence;
                if (isOtherMultipleFacing && (materialMatch || areBothFence) && (otherAllowedFaces = ((MultipleFacing)otherData).getAllowedFaces()).contains(blockFace.getOppositeFace())) {
                    ((MultipleFacing)otherData).setFace(blockFace.getOppositeFace(), true);
                    otherBlock.setBlockData(otherData);
                }
            } else {
                ((MultipleFacing)this.craftBlockData).setFace(blockFace, false);
            }
        });
        this.updateBlockData();
    }

    @Override
    public void rotateVerticallyInDirection(DoorDirection openDirection) {
        NMSUtil.rotateVerticallyInDirection(openDirection, this.craftBlockData);
        this.updateBlockData();
    }

    @Override
    public void rotateBlockUpDown(boolean ns) {
        EnumDirection.EnumAxis axis;
        EnumDirection.EnumAxis newAxis = axis = (EnumDirection.EnumAxis)this.blockData.c((IBlockState)BlockRotatable.i);
        switch (axis) {
            case a: {
                newAxis = ns ? EnumDirection.EnumAxis.a : EnumDirection.EnumAxis.b;
                break;
            }
            case b: {
                newAxis = ns ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
                break;
            }
            case c: {
                newAxis = ns ? EnumDirection.EnumAxis.b : EnumDirection.EnumAxis.c;
            }
        }
        this.blockData = (IBlockData)this.blockData.b((IBlockState)BlockRotatable.i, (Comparable)newAxis);
        this.updateCraftBlockData();
    }

    @Override
    public void rotateCylindrical(RotateDirection rotDir) {
        this.blockData = rotDir.equals((Object)RotateDirection.CLOCKWISE) ? this.blockData.a(EnumBlockRotation.b) : this.blockData.a(EnumBlockRotation.d);
        this.updateCraftBlockData();
    }

    IBlockData getMyBlockData() {
        return this.blockData;
    }

    @Override
    public String toString() {
        return this.blockData.toString();
    }

    @Override
    public void deleteOriginalBlock(boolean applyPhysics) {
        World world = Objects.requireNonNull(this.loc.getWorld());
        if (!applyPhysics) {
            world.getBlockAt(this.loc).setType(Material.AIR, false);
        } else {
            world.getBlockAt(this.loc).setType(Material.CAVE_AIR, false);
            world.getBlockAt(this.loc).setType(Material.AIR, true);
        }
    }

    protected MapCodec<? extends Block> a() {
        return this.blockMapCodec.get();
    }

    public Item j() {
        return null;
    }

    protected Block o() {
        return null;
    }
}

