/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.VersionScheme;
import org.bukkit.Bukkit;

public final class UpdateChecker {
    private static final URL UPDATE_URL;
    private static UpdateChecker instance;
    private UpdateResult lastResult = null;
    private final BigDoors plugin;
    private final VersionScheme versionScheme;
    private final File updateFile;

    private UpdateChecker(BigDoors plugin, VersionScheme versionScheme) {
        this.plugin = plugin;
        this.versionScheme = versionScheme;
        this.updateFile = new File(Bukkit.getUpdateFolderFile() + "/" + plugin.getName() + ".jar");
    }

    public CompletableFuture<UpdateResult> requestUpdateCheck() {
        if (UPDATE_URL == null) {
            return CompletableFuture.completedFuture(new UpdateResult(UpdateReason.UNKNOWN_ERROR));
        }
        return CompletableFuture.supplyAsync(() -> {
            int responseCode = -1;
            try {
                String line;
                HttpURLConnection connection = (HttpURLConnection)UPDATE_URL.openConnection();
                InputStreamReader iSReader = new InputStreamReader(connection.getInputStream());
                responseCode = connection.getResponseCode();
                BufferedReader reader = new BufferedReader(iSReader);
                StringBuilder jsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    jsonStr.append(line);
                }
                iSReader.close();
                reader.close();
                JsonElement element = new JsonParser().parse("[" + jsonStr + "]");
                if (!element.isJsonArray()) {
                    return new UpdateResult(UpdateReason.INVALID_JSON);
                }
                JsonObject latestRelease = element.getAsJsonArray().get(0).getAsJsonObject();
                long age = UpdateChecker.getAgeInSeconds(latestRelease.get("published_at").getAsString());
                String jarUrl = "";
                String hashUrl = "";
                for (JsonElement asset : latestRelease.get("assets").getAsJsonArray()) {
                    JsonObject asset_object = asset.getAsJsonObject();
                    String downloadUrl = asset_object.get("browser_download_url").getAsString();
                    if (downloadUrl.endsWith("jar")) {
                        jarUrl = downloadUrl;
                        continue;
                    }
                    if (!downloadUrl.endsWith("256")) continue;
                    hashUrl = downloadUrl;
                }
                String current = Util.getCleanedVersionString();
                String available = Util.getCleanedVersionString(latestRelease.get("name").getAsString());
                if (!available.startsWith("0.1")) {
                    return new UpdateResult(UpdateReason.UP_TO_DATE);
                }
                String highest = this.versionScheme.compareVersions(current, available);
                if (highest == null) {
                    return new UpdateResult(UpdateReason.UNSUPPORTED_VERSION_SCHEME);
                }
                if (highest.equals(current)) {
                    return new UpdateResult(current.equals(available) ? UpdateReason.UP_TO_DATE : UpdateReason.UNRELEASED_VERSION, current, age, jarUrl, hashUrl, this.getFromObjAsString(latestRelease, "body"), this.getFromObjAsString(latestRelease, "html_url"));
                }
                if (highest.equals(available)) {
                    return new UpdateResult(UpdateReason.NEW_UPDATE, highest, age, jarUrl, hashUrl, this.getFromObjAsString(latestRelease, "body"), this.getFromObjAsString(latestRelease, "html_url"));
                }
            }
            catch (IOException e) {
                return new UpdateResult(UpdateReason.COULD_NOT_CONNECT);
            }
            catch (JsonSyntaxException e) {
                return new UpdateResult(UpdateReason.INVALID_JSON);
            }
            return new UpdateResult(responseCode == 401 ? UpdateReason.UNAUTHORIZED_QUERY : UpdateReason.UNKNOWN_ERROR);
        });
    }

    public UpdateResult getLastResult() {
        return this.lastResult;
    }

    @Nullable
    private String getFromObjAsString(JsonObject jsonObject, String memberName) {
        try {
            JsonElement member = jsonObject.get(memberName);
            if (member == null) {
                return null;
            }
            return member.getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean downloadUpdate(UpdateResult result) throws IOException {
        String checksum;
        File updateFolder = Bukkit.getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdirs()) {
            throw new IOException("Failed to create update folder!");
        }
        if (result.getHashURL().isEmpty() || (checksum = Util.readSHA256FromURL(new URL(result.getHashURL()))).isEmpty()) {
            this.plugin.getMyLogger().severe("Failed to obtain checksum for update! Auto-update has been aborted!");
            return false;
        }
        if (this.updateFile.exists() && checksum.equals(Util.getSHA256(this.updateFile))) {
            return true;
        }
        try (InputStream in = new URL(result.getDownloadUrl()).openStream();){
            Files.copy(in, this.updateFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            return false;
        }
        if (!this.updateFile.exists()) {
            throw new IOException("Failed to save file!");
        }
        String currentChecksum = Util.getSHA256(this.updateFile);
        boolean downloadSuccessfully = checksum.equals(currentChecksum);
        if (!downloadSuccessfully) {
            this.plugin.getMyLogger().severe("Checksum of downloaded file did not match expected checksum!");
            this.plugin.getMyLogger().severe("Expected: " + checksum);
            this.plugin.getMyLogger().severe("Found: " + currentChecksum);
            this.updateFile.delete();
        }
        return downloadSuccessfully;
    }

    public static UpdateChecker init(BigDoors plugin, VersionScheme versionScheme) {
        return instance == null ? (instance = new UpdateChecker(plugin, versionScheme)) : instance;
    }

    public static UpdateChecker init(BigDoors plugin) {
        return UpdateChecker.init(plugin, VersionScheme.DECIMAL);
    }

    public static UpdateChecker get() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance has not yet been initialized. Be sure #init() has been invoked");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    private static long getAgeInSeconds(String time) {
        TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_INSTANT.parse(time);
        Date date = Date.from(Instant.from(temporalAccessor));
        return (new Date().getTime() - date.getTime()) / 1000L;
    }

    static {
        String urlStr = "https://api.github.com/repos/PimvanderLoos/BigDoors/releases/latest";
        URL url = null;
        try {
            url = new URL("https://api.github.com/repos/PimvanderLoos/BigDoors/releases/latest");
        }
        catch (IOException e) {
            BigDoors.get().getMyLogger().severe("Failed to construct URL from: \"https://api.github.com/repos/PimvanderLoos/BigDoors/releases/latest\".\nPlease contact Pim about the stacktrace below:");
            e.printStackTrace();
        }
        UPDATE_URL = url;
    }

    public final class UpdateResult {
        private final UpdateReason reason;
        private final String newestVersion;
        private final long age;
        private final String url;
        private final String hashURL;
        @Nullable
        private final String changelog;
        @Nullable
        private final String htmlUrl;

        private UpdateResult(UpdateReason reason, String newestVersion, long age, String url, @Nullable String hashURL, @Nullable String changelog, String htmlUrl) {
            UpdateChecker.this.lastResult = this;
            this.reason = reason;
            this.newestVersion = newestVersion;
            this.age = age;
            this.url = url;
            this.hashURL = hashURL;
            this.changelog = changelog;
            this.htmlUrl = htmlUrl;
        }

        private UpdateResult(UpdateReason reason) {
            UpdateChecker.this.lastResult = this;
            Preconditions.checkArgument((reason != UpdateReason.NEW_UPDATE && reason != UpdateReason.UP_TO_DATE ? 1 : 0) != 0, (Object)"Reasons that might require updates must also provide the latest version String");
            this.reason = reason;
            this.newestVersion = UpdateChecker.this.plugin.getDescription().getVersion();
            this.age = -1L;
            this.url = "";
            this.hashURL = "";
            this.changelog = null;
            this.htmlUrl = null;
        }

        public UpdateReason getReason() {
            return this.reason;
        }

        @Nullable
        public String getChangelog() {
            return this.changelog;
        }

        @Nullable
        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public boolean requiresUpdate() {
            return this.reason == UpdateReason.NEW_UPDATE;
        }

        public String getNewestVersion() {
            return this.newestVersion;
        }

        public long getAge() {
            return this.age;
        }

        public String getDownloadUrl() {
            return this.url;
        }

        public String getHashURL() {
            return this.hashURL;
        }
    }

    public static enum UpdateReason {
        NEW_UPDATE,
        COULD_NOT_CONNECT,
        INVALID_JSON,
        INVALID_HASH,
        UNAUTHORIZED_QUERY,
        UNRELEASED_VERSION,
        UNKNOWN_ERROR,
        UNSUPPORTED_VERSION_SCHEME,
        UP_TO_DATE;

    }
}

