/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.codegeneration;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.codegeneration.ReflectionRepository;
import nl.pim16aap2.bigDoors.lib.asm.tree.AbstractInsnNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.FieldInsnNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.MethodNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.VarInsnNode;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import nl.pim16aap2.bigDoors.reflection.asm.ASMUtil;
import org.jetbrains.annotations.NotNull;

class EntityFallingBlockClassAnalyzer {
    EntityFallingBlockClassAnalyzer() {
    }

    @NotNull
    Field getHurtEntitiesField() throws IOException {
        String fieldName = Objects.requireNonNull(this.getFieldName(ReflectionRepository.methodHurtEntities, ReflectionRepository.classEntityFallingBlock), "Failed to find name of HurtEntities variable in hurt entities method!");
        return ReflectionBuilder.findField().inClass(ReflectionRepository.classEntityFallingBlock).withName(fieldName).get();
    }

    @NotNull
    Field getNoClipField() throws IOException {
        String fieldName = Objects.requireNonNull(this.getFieldName(ReflectionRepository.methodMove, ReflectionRepository.classNMSEntity), "Failed to find name of noClip variable in move method!");
        return ReflectionBuilder.findField().inClass(ReflectionRepository.classNMSEntity).withName(fieldName).ofType(Boolean.TYPE).get();
    }

    @Nullable
    private String getFieldName(@NotNull Method method, @NotNull Class<?> clz) throws IOException {
        FieldFinder fieldFinder = ASMUtil.processMethod(method, null, (a, n, d, s, e) -> FieldFinder.create(a, n, d, s, e, clz));
        if (fieldFinder == null) {
            throw new IllegalStateException("Failed to create location method analyzer using method: " + method + " in class: " + clz.getName());
        }
        return fieldFinder.fieldName;
    }

    private static final class FieldFinder
    extends MethodNode {
        private final String fieldOwner;
        @Nullable
        private String fieldName;

        public FieldFinder(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, Class<?> fieldOwner) {
            super(589824, access, name, desc, signature, exceptions);
            this.fieldOwner = ASMUtil.getClassName(fieldOwner);
        }

        public static FieldFinder create(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, Class<?> fieldOwner) {
            return new FieldFinder(access, name, desc, signature, exceptions, fieldOwner);
        }

        @Override
        public void visitEnd() {
            for (AbstractInsnNode node : this.instructions) {
                if (node.getOpcode() != 25 || ((VarInsnNode)node).var != 0 || node.getNext() == null || node.getNext().getOpcode() != 180) continue;
                FieldInsnNode next = (FieldInsnNode)node.getNext();
                if (!next.owner.equals(this.fieldOwner) || !next.desc.equals("Z")) continue;
                this.fieldName = next.name;
                break;
            }
        }
    }
}

