/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.codegeneration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.MethodFinder;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import nl.pim16aap2.bigDoors.reflection.asm.ASMUtil;
import org.bukkit.Location;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.Nullable;

final class ReflectionASMAnalyzers {
    private ReflectionASMAnalyzers() {
    }

    static Method[] getEntityLocationMethods(Class<?> classCraftEntity, Class<?> classNMSEntity) {
        Method methodLocation = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classCraftEntity).withName("getLocation").withParameters(Location.class)).get();
        String[] names = ASMUtil.getMethodNamesFromMethodCall(methodLocation, 3, classNMSEntity, Double.TYPE, new Class[0]);
        Method[] ret = new Method[names.length];
        for (int idx = 0; idx < names.length; ++idx) {
            String name = Objects.requireNonNull(names[idx], "Name at pos " + idx + " was null! This is not allowed!");
            ret[idx] = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(name).withoutParameters()).get();
        }
        return ret;
    }

    static Method getSetNoGravity(Class<?> classCraftEntity, Class<?> classNMSEntity) {
        Method craftMethod = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classCraftEntity).withName("setGravity").withParameters(Boolean.TYPE)).get();
        String methodName = ASMUtil.getMethodNameFromMethodCall(craftMethod, classNMSEntity, Void.TYPE, Boolean.TYPE);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(methodName).withParameters(Boolean.TYPE)).get();
    }

    public static Method getSetPosition(Class<?> classNMSEntity) {
        String nameSetPosition = ASMUtil.getMethodNameFromMethodCall((Executable)ReflectionBuilder.findConstructor().inClass(classNMSEntity).get(), classNMSEntity, Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(nameSetPosition).withParameters(Double.TYPE, Double.TYPE, Double.TYPE)).get();
    }

    public static Method getSetMotVecMethod(Class<?> classCraftEntity, Class<?> classNMSEntity, Class<?> classVec3D) {
        Method sourceMethod = ReflectionBuilder.findMethod().inClass(classCraftEntity).withName("setVelocity").get();
        String methodName = ASMUtil.getMethodNameFromMethodCall(sourceMethod, classNMSEntity, Void.TYPE, classVec3D);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(methodName).withParameters(classVec3D)).get();
    }

    public static Method getGetMotMethod(Class<?> classCraftEntity, Class<?> classNMSEntity, Class<?> classVec3D) {
        Method sourceMethod = ReflectionBuilder.findMethod().inClass(classCraftEntity).withName("getVelocity").get();
        String methodName = ASMUtil.getMethodNameFromMethodCall(sourceMethod, classNMSEntity, classVec3D, new Class[0]);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(methodName).withoutParameters()).get();
    }

    public static Method getIsAirMethod(Method methodTick, Class<?> classIBlockData, Class<?> classBlockData) {
        String methodName = ASMUtil.getMethodNameFromMethodCall(methodTick, classIBlockData, Boolean.TYPE, new Class[0]);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classBlockData).withName(methodName).withoutParameters()).get();
    }

    public static Method getCraftEntityDieMethod(Class<?> classCraftEntity, Class<?> classNMSEntity, @Nullable Class<?> classEntityRemoveEventCause) {
        Method sourceMethod = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classCraftEntity).withName("remove").withoutParameters()).get();
        String methodName = ASMUtil.getMethodNameFromMethodCall(sourceMethod, classNMSEntity, Void.TYPE, classEntityRemoveEventCause);
        Objects.requireNonNull(methodName, "Failed to find name of method call in remove method!");
        MethodFinder.NamedMethodFinder methodFinder = ReflectionBuilder.findMethod().inClass(classNMSEntity).withName(methodName);
        if (classEntityRemoveEventCause != null) {
            methodFinder.withParameters(classEntityRemoveEventCause);
        } else {
            methodFinder.withoutParameters();
        }
        return methodFinder.get();
    }

    public static Method getNMSAddEntityMethod(Class<?> classNMSWorldServer, Class<?> classNMSEntity) {
        Object candidates = ((MethodFinder.MultipleMethodsFinder)ReflectionBuilder.findMethod().inClass(classNMSWorldServer).findMultiple().withReturnType(Boolean.TYPE).withParameters(classNMSEntity, CreatureSpawnEvent.SpawnReason.class)).get();
        Method privateMethod = ((MethodFinder.TypedMethodFinder)((MethodFinder.TypedMethodFinder)ReflectionBuilder.findMethod().inClass(classNMSWorldServer).withReturnType(Boolean.TYPE).withParameters(classNMSEntity, CreatureSpawnEvent.SpawnReason.class)).withModifiers(2)).get();
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!ASMUtil.executableContainsMethodCall(method, privateMethod)) continue;
            return method;
        }
        throw new IllegalStateException("Could not find method with call to " + privateMethod.toGenericString() + " among candidates: " + candidates);
    }

    public static Method getGetIBlockDataHolderStateMethod(Class<?> classCraftBlockData, Class<?> classBlockStateEnum, Class<?> classIBlockData, Class<?> classIBlockState, Class<?> classIBlockDataHolder) {
        Method sourceMethod = (Method)ReflectionBuilder.findMethod().inClass(classCraftBlockData).findMultiple().withReturnType((Type)((Object)Enum.class)).withName("get").exactCount(1).get().getFirst();
        String methodName = ASMUtil.getMethodNameFromMethodCall(sourceMethod, classIBlockData, Comparable.class, classIBlockState);
        return ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(classIBlockDataHolder).withName(methodName).withParameters(classIBlockState)).get();
    }

    public static Field getEntityTypeFallingBlock(Class<?> classEntityTypes, Constructor<?> cTorPrivateNMSFallingBlockEntity) {
        String fieldName = ASMUtil.getStaticFieldAccess(classEntityTypes, cTorPrivateNMSFallingBlockEntity);
        return ReflectionBuilder.findField().inClass(classEntityTypes).withName(fieldName).get();
    }
}

