/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.pim16aap2.bigDoors.compatibility.GriefDefender1ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.GriefDefender2ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.GriefPreventionProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.compatibility.LandsProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.MedievalFactionsProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.PlotSquared3ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.PlotSquared4ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.PlotSquared5ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.PlotSquared6ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.PlotSquared7ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.RedProtectProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.TownyProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.WorldGuard6ProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.WorldGuard7ProtectionCompat;
import org.bukkit.Bukkit;

public abstract class ProtectionCompatDefinition
implements IProtectionCompatDefinition {
    public static final IProtectionCompatDefinition TOWNY = new ProtectionCompatDefinition("Towny"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            return TownyProtectionCompat.class;
        }
    };
    public static final IProtectionCompatDefinition PLOTSQUARED = new ProtectionCompatDefinition("PlotSquared"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            String majorVersion;
            if (version.length() < 2) {
                return null;
            }
            switch (majorVersion = version.substring(0, 2)) {
                case "20": 
                case "3.": {
                    return PlotSquared3ProtectionCompat.class;
                }
                case "4.": {
                    return PlotSquared4ProtectionCompat.class;
                }
                case "5.": {
                    return PlotSquared5ProtectionCompat.class;
                }
                case "6.": {
                    return PlotSquared6ProtectionCompat.class;
                }
                case "7.": {
                    return PlotSquared7ProtectionCompat.class;
                }
            }
            ProtectionCompatDefinition.logUnsupportedVersion("PlotSquared", version);
            return null;
        }
    };
    public static final IProtectionCompatDefinition WORLDGUARD = new ProtectionCompatDefinition("WorldGuard"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            if (version.length() < 2) {
                return null;
            }
            if (version.startsWith("7.")) {
                return WorldGuard7ProtectionCompat.class;
            }
            if (version.startsWith("6.")) {
                return WorldGuard6ProtectionCompat.class;
            }
            ProtectionCompatDefinition.logUnsupportedVersion("WorldGuard", version);
            return null;
        }
    };
    public static final IProtectionCompatDefinition GRIEFPREVENTION = new ProtectionCompatDefinition("GriefPrevention"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            return GriefPreventionProtectionCompat.class;
        }
    };
    public static final IProtectionCompatDefinition LANDS = new ProtectionCompatDefinition("Lands"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            return LandsProtectionCompat.class;
        }
    };
    public static final IProtectionCompatDefinition MEDIEVAL_FACTIONS = new ProtectionCompatDefinition("MedievalFactions"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            return MedievalFactionsProtectionCompat.class;
        }
    };
    public static final IProtectionCompatDefinition REDPROTECT = new ProtectionCompatDefinition("RedProtect"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            return RedProtectProtectionCompat.class;
        }
    };
    public static final IProtectionCompatDefinition GRIEF_DEFENDER = new ProtectionCompatDefinition("GriefDefender"){

        @Override
        public Class<? extends IProtectionCompat> getClass(String version) {
            if (version.startsWith("1")) {
                return GriefDefender1ProtectionCompat.class;
            }
            if (version.startsWith("2")) {
                return GriefDefender2ProtectionCompat.class;
            }
            ProtectionCompatDefinition.logUnsupportedVersion("GriefDefender", version);
            return null;
        }
    };
    public static final List<IProtectionCompatDefinition> DEFAULT_COMPAT_DEFINITIONS = Collections.unmodifiableList(Arrays.asList(TOWNY, PLOTSQUARED, WORLDGUARD, GRIEFPREVENTION, LANDS, MEDIEVAL_FACTIONS, REDPROTECT, GRIEF_DEFENDER));
    private final String name;

    private ProtectionCompatDefinition(String name) {
        this.name = name;
    }

    private static void logUnsupportedVersion(String hook, String version) {
        Bukkit.getLogger().severe("[BigDoors] No hook exists for '" + hook + "' version '" + version + "'");
    }

    @Override
    public String getName() {
        return this.name;
    }
}

