/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.compatibility.FakePlayerCreator;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.compatibility.ProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ProtectionCompatManager
implements Listener {
    private static final String BYPASS_PERMISSION = "bigdoors.admin.bypasscompat";
    private final Map<String, IProtectionCompatDefinition> registeredDefinitions;
    private final List<IProtectionCompat> protectionCompats;
    private final FakePlayerCreator fakePlayerCreator;
    private final BigDoors plugin;

    public ProtectionCompatManager(BigDoors plugin) {
        this.plugin = plugin;
        this.registeredDefinitions = this.registerDefaultProtectionCompatDefinitions();
        this.fakePlayerCreator = plugin.getFakePlayerCreator();
        this.protectionCompats = new CopyOnWriteArrayList<IProtectionCompat>();
        this.restart();
    }

    public void restart() {
        this.protectionCompats.clear();
        for (Plugin p : this.plugin.getServer().getPluginManager().getPlugins()) {
            this.loadFromPluginName(p.getName());
        }
    }

    private CompletableFuture<Boolean> canBypass(Player player) {
        if (player.isOp()) {
            return CompletableFuture.completedFuture(true);
        }
        if (!player.hasMetadata("isBigDoorsFakePlayer")) {
            return CompletableFuture.completedFuture(player.hasPermission(BYPASS_PERMISSION));
        }
        return this.plugin.getVaultManager().hasPermission((OfflinePlayer)player, BYPASS_PERMISSION, player.getWorld().getName());
    }

    @Nullable
    private Player getPlayer(UUID playerUUID, Location location) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null) {
            return player;
        }
        return this.fakePlayerCreator.getFakePlayer(Bukkit.getOfflinePlayer((UUID)playerUUID), location);
    }

    @Nullable
    private String canBreakBlockSync(Player fakePlayer, Location loc) {
        for (IProtectionCompat compat : this.protectionCompats) {
            try {
                if (compat.canBreakBlock(fakePlayer, loc)) continue;
                return compat.getName();
            }
            catch (Exception e) {
                this.plugin.getMyLogger().warn("Failed to use \"" + compat.getName() + "\"! Please send this error to pim16aap2:");
                e.printStackTrace();
                this.plugin.getMyLogger().logMessageToLogFile(compat.getName() + "\n" + Util.throwableToString(e));
            }
        }
        return null;
    }

    @Nullable
    private String canBreakBlocksBetweenLocsSync(Player fakePlayer, World world, Location loc1, Location loc2) {
        loc1 = loc1.clone();
        loc2 = loc2.clone();
        loc1.setWorld(world);
        loc2.setWorld(world);
        for (IProtectionCompat compat : this.protectionCompats) {
            try {
                if (compat.canBreakBlocksBetweenLocs(fakePlayer, loc1, loc2)) continue;
                return compat.getName();
            }
            catch (Exception e) {
                this.plugin.getMyLogger().warn("Failed to use \"" + compat.getName() + "\"! Please send this error to pim16aap2:");
                e.printStackTrace();
                this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            }
        }
        return null;
    }

    private static <T> CompletableFuture<T> callSyncMethod(Location location, Callable<T> callable) {
        CompletableFuture ret = new CompletableFuture();
        BigDoors.getScheduler().runTask(location, () -> {
            try {
                ret.complete(callable.call());
            }
            catch (Exception e) {
                ret.completeExceptionally(e);
            }
        });
        return ret;
    }

    private CompletableFuture<@Nullable String> checkForPlayer(Location location, Player fakePlayer, Callable<@Nullable String> callable) {
        return this.canBypass(fakePlayer).thenApplyAsync(canBypass -> {
            if (canBypass.booleanValue()) {
                return null;
            }
            try {
                return (String)ProtectionCompatManager.callSyncMethod(location, callable).get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.plugin.getMyLogger().log("Interrupted while checking permissions for offline player: " + fakePlayer, e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Timed out checking permissions for offline player: " + fakePlayer, e);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to check permissions for offline player: " + fakePlayer, e);
            }
            return "ERROR";
        });
    }

    public int registeredCompatsCount() {
        return this.protectionCompats.size();
    }

    private CompletableFuture<@Nullable String> checkForPlayer(Location regionLocation, UUID playerUUID, Function<Player, @Nullable String> function) {
        if (this.protectionCompats.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        @Nullable Player fakePlayer = this.getPlayer(playerUUID, regionLocation);
        if (fakePlayer == null) {
            return CompletableFuture.completedFuture("InvalidFakePlayer");
        }
        return this.checkForPlayer(regionLocation, fakePlayer, () -> (String)function.apply(fakePlayer));
    }

    public CompletableFuture<@Nullable String> canBreakBlock(UUID playerUUID, String playerName, Location loc) {
        return this.checkForPlayer(loc, playerUUID, (Player fakePlayer) -> this.canBreakBlockSync((Player)fakePlayer, loc)).exceptionally(ex -> {
            this.plugin.getMyLogger().log("Failed to check if player '" + playerName + "' could break the block at location: " + loc + ", With active protection hooks: " + this.getActiveHookNames(), (Throwable)ex);
            return "ERROR";
        });
    }

    public CompletableFuture<@Nullable String> canBreakBlocksBetweenLocs(UUID playerUUID, String playerName, World world, Location loc1, Location loc2) {
        return this.checkForPlayer(loc1, playerUUID, (Player fakePlayer) -> this.canBreakBlocksBetweenLocsSync((Player)fakePlayer, world, loc1, loc2)).exceptionally(ex -> {
            this.plugin.getMyLogger().log("Failed to check if player '" + playerName + "' could break the blocks between location " + loc1 + " and " + loc2 + ", With active protection hooks: " + this.getActiveHookNames(), (Throwable)ex);
            return "ERROR";
        });
    }

    private boolean protectionAlreadyLoaded(Class<? extends IProtectionCompat> compatClass) {
        for (IProtectionCompat compat : this.protectionCompats) {
            if (!compat.getClass().equals(compatClass)) continue;
            return true;
        }
        return false;
    }

    private void addProtectionCompat(IProtectionCompat hook) {
        if (hook.success()) {
            this.protectionCompats.add(hook);
            this.plugin.getMyLogger().logMessage(Level.INFO, "Successfully hooked into \"" + hook.getName() + "\"!");
        } else {
            this.plugin.getMyLogger().logMessage(Level.INFO, "Failed to hook into \"" + hook.getName() + "\"!");
        }
    }

    @EventHandler
    protected void onPluginEnable(PluginEnableEvent event) {
        this.loadFromPluginName(event.getPlugin().getName());
    }

    private void loadFromPluginName(String compatName) {
        @Nullable IProtectionCompatDefinition compatDefinition = this.registeredDefinitions.get(compatName);
        if (compatDefinition == null) {
            return;
        }
        if (!this.plugin.getConfigLoader().isHookEnabled(compatDefinition)) {
            return;
        }
        @Nullable String version = null;
        try {
            version = this.plugin.getServer().getPluginManager().getPlugin(compatDefinition.getName()).getDescription().getVersion();
            Class<? extends IProtectionCompat> compatClass = Objects.requireNonNull(compatDefinition.getClass(version), "Compat class cannot be null for compat \"" + compatName + "\" (version \"" + version + "\")!");
            if (this.protectionAlreadyLoaded(compatClass)) {
                return;
            }
            HookContext hookContext = new HookContext(this.plugin, compatDefinition, this.plugin.getVaultManager());
            this.addProtectionCompat(compatClass.getConstructor(HookContext.class).newInstance(hookContext));
        }
        catch (Exception | NoClassDefFoundError e) {
            this.plugin.getMyLogger().logMessageToConsole("Failed to initialize the \"" + compatName + "\" (version \"" + version + "\") compatibility hook!");
            this.plugin.getMyLogger().logMessageToConsole("Now resuming normal startup with the \"" + compatName + "\" Compatibility Hook disabled!");
            this.plugin.getMyLogger().logMessage(Util.throwableToString(e), true, true);
        }
    }

    private Map<String, IProtectionCompatDefinition> registerDefaultProtectionCompatDefinitions() {
        HashMap<String, IProtectionCompatDefinition> ret = new HashMap<String, IProtectionCompatDefinition>(ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS.size());
        for (IProtectionCompatDefinition compatDefinition : ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS) {
            ret.put(compatDefinition.getName(), compatDefinition);
        }
        return ret;
    }

    public void registerProtectionCompatDefinition(IProtectionCompatDefinition compatDefinition) {
        this.registeredDefinitions.put(compatDefinition.getName(), compatDefinition);
    }

    private String getActiveHookNames() {
        if (this.protectionCompats.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (IProtectionCompat compat : this.protectionCompats) {
            sb.append(compat.getName()).append(", ");
        }
        return sb.substring(0, sb.length() - 2) + "]";
    }
}

