/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class WorldGuard7ProtectionCompat
implements IProtectionCompat {
    private static final StateFlag[] FLAGS = new StateFlag[]{Flags.BLOCK_BREAK, Flags.BLOCK_PLACE, Flags.BUILD};
    private final WorldGuard worldGuard = WorldGuard.getInstance();
    private final WorldGuardPlugin worldGuardPlugin;
    private boolean success = false;

    public WorldGuard7ProtectionCompat(HookContext hookContext) {
        Plugin wgPlugin = Bukkit.getServer().getPluginManager().getPlugin(hookContext.getProtectionCompatDefinition().getName());
        if (!(wgPlugin instanceof WorldGuardPlugin)) {
            this.worldGuardPlugin = null;
            return;
        }
        this.worldGuardPlugin = (WorldGuardPlugin)wgPlugin;
        this.success = true;
    }

    private boolean enabledInWorld(World world) {
        RegionManager regionManager = this.worldGuard.getPlatform().getRegionContainer().get(world);
        return regionManager != null && regionManager.size() > 0;
    }

    private World toWorldGuardWorld(@Nullable org.bukkit.World world) {
        return BukkitAdapter.adapt((org.bukkit.World)Objects.requireNonNull(world, "World cannot be null!"));
    }

    private RegionAssociable regionAssociableFromPlayer(Player player) {
        if (Bukkit.getPlayer((UUID)player.getUniqueId()) == null) {
            return this.worldGuardPlugin.wrapOfflinePlayer((OfflinePlayer)player);
        }
        return new BukkitPlayer(this.worldGuardPlugin, player);
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        if (!this.enabledInWorld(this.toWorldGuardWorld(loc.getWorld()))) {
            return true;
        }
        RegionQuery query = this.worldGuard.getPlatform().getRegionContainer().createQuery();
        World world = this.toWorldGuardWorld(loc.getWorld());
        com.sk89q.worldedit.util.Location wgLoc = new com.sk89q.worldedit.util.Location((Extent)world, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ());
        return query.testState(wgLoc, this.regionAssociableFromPlayer(player), FLAGS);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        World world = this.toWorldGuardWorld(loc1.getWorld());
        if (!this.enabledInWorld(world)) {
            return true;
        }
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        RegionQuery query = this.worldGuard.getPlatform().getRegionContainer().createQuery();
        RegionAssociable regionAssociable = this.regionAssociableFromPlayer(player);
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int yPos = y1; yPos <= y2; ++yPos) {
                for (int zPos = z1; zPos <= z2; ++zPos) {
                    com.sk89q.worldedit.util.Location wgLoc = new com.sk89q.worldedit.util.Location((Extent)world, (double)xPos, (double)yPos, (double)zPos);
                    if (query.testState(wgLoc, regionAssociable, FLAGS)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getName() {
        return this.worldGuardPlugin.getName();
    }
}

