/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedstoneHandler
implements Listener {
    private static final List<BlockFace> FACES = Collections.unmodifiableList(Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN));
    private final BigDoors plugin;

    public RedstoneHandler(BigDoors plugin) {
        this.plugin = plugin;
    }

    private void checkDoor(Location loc) {
        Door door = this.plugin.getCommander().doorFromPowerBlockLoc(loc);
        if (door != null && !door.isLocked()) {
            this.plugin.getDoorOpener(door.getType()).openDoorFuture(door, 0.0, false, true).exceptionally(Util::exceptionally);
        }
    }

    private void checkAroundLocation(Block block) {
        for (BlockFace dir : FACES) {
            Block relative = block.getRelative(dir);
            if (!this.plugin.getConfigLoader().getPowerBlockTypes().contains(relative.getType())) continue;
            this.checkDoor(relative.getLocation());
        }
    }

    private void checkAroundLocation(Location location) {
        this.checkAroundLocation(location.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        block3: {
            try {
                Block block = event.getBlock();
                if (event.getOldCurrent() != 0 && event.getNewCurrent() != 0) {
                    return;
                }
                this.checkAroundLocation(block);
            }
            catch (Exception e) {
                this.plugin.getMyLogger().logMessage("Exception thrown while handling redstone event!", true, false);
                this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
                if (!ConfigLoader.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private void handleBlocksMovedByPiston(BlockFace direction, List<Block> blocks) {
        HashSet<Location> addedPositions = new HashSet<Location>();
        HashSet<Location> removedPositions = new HashSet<Location>();
        for (Block block : blocks) {
            if (block.getType() != Material.REDSTONE_BLOCK) continue;
            Location oldLocation = block.getLocation();
            Block newBlock = block.getRelative(direction);
            Location newLocation = newBlock.getLocation();
            if (addedPositions.contains(oldLocation)) {
                addedPositions.remove(oldLocation);
            } else {
                removedPositions.add(oldLocation);
            }
            if (removedPositions.contains(newLocation)) {
                removedPositions.remove(newLocation);
                continue;
            }
            addedPositions.add(newLocation);
        }
        addedPositions.forEach(this::checkAroundLocation);
        removedPositions.forEach(this::checkAroundLocation);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        this.handleBlocksMovedByPiston(event.getDirection(), event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        this.handleBlocksMovedByPiston(event.getDirection(), event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(block.getType())) {
            this.checkAroundLocation(block);
        }
    }
}

