/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.WorldHeightManager;
import nl.pim16aap2.bigDoors.events.DoorEventToggle;
import nl.pim16aap2.bigDoors.events.DoorEventTogglePrepare;
import nl.pim16aap2.bigDoors.events.DoorEventToggleStart;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector2D;
import nl.pim16aap2.bigDoors.util.WorldHeightLimits;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Opener {
    default public boolean hasValidCoordinates(Door door) {
        if (door.getWorld() != null) {
            return true;
        }
        BigDoors.get().getMyLogger().logMessage("World is null for door " + door.toSimpleString() + "!", true, false);
        return false;
    }

    public Pair<Vector2D, Vector2D> getChunkRange(Door var1);

    default public Pair<Vector2D, Vector2D> getCurrentChunkRange(Door door) {
        return ChunkUtils.getChunkRangeBetweenCoords(door.getMinimum(), door.getMaximum());
    }

    default public ChunkUtils.ChunkLoadResult chunksLoaded(Door door, ChunkUtils.ChunkLoadMode mode) {
        if (!this.hasValidCoordinates(door)) {
            return ChunkUtils.ChunkLoadResult.FAIL;
        }
        return ChunkUtils.checkChunks(door.getWorld(), this.getCurrentChunkRange(door), mode);
    }

    @NotNull
    default public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door door, boolean bypassProtectionHooks) {
        return this.openDoorFuture(door, 0.0, false, false, this.getChunkLoadMode(door), bypassProtectionHooks).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    @NotNull
    default public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door door, double time) {
        return this.openDoorFuture(door, time, false, false).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    @NotNull
    default public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door door, double time, boolean instantOpen) {
        return this.openDoorFuture(door, time, instantOpen, false).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    @NotNull
    default public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door door, double time, boolean instantOpen, boolean silent) {
        return this.openDoorFuture(door, time, instantOpen, silent, this.getChunkLoadMode(door)).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    @NotNull
    default public ChunkUtils.ChunkLoadMode getChunkLoadMode(@NotNull Door door) {
        ChunkUtils.ChunkLoadMode mode = BigDoors.get().getConfigLoader().getChunkLoadMode();
        if (mode == ChunkUtils.ChunkLoadMode.ATTEMPT_LOAD && !door.isOpen() && BigDoors.get().getConfigLoader().skipUnloadedAutoCloseToggle() && door.getAutoClose() > 0) {
            mode = ChunkUtils.ChunkLoadMode.VERIFY_LOADED;
        }
        return mode;
    }

    @NotNull
    default public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door door, double time, boolean instantOpen, boolean silent, @NotNull ChunkUtils.ChunkLoadMode mode) {
        return this.openDoorFuture(door, time, instantOpen, silent, mode, false).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    @NotNull
    public CompletableFuture<DoorOpenResult> openDoorFuture(@NotNull Door var1, double var2, boolean var4, boolean var5, @NotNull ChunkUtils.ChunkLoadMode var6, boolean var7);

    default public DoorOpenResult abort(DoorOpenResult reason, long doorUID) {
        if (ConfigLoader.DEBUG) {
            BigDoors.get().getMyLogger().info("Aborted toggle for door " + doorUID + ". Reason: " + reason.name());
        }
        if (reason != DoorOpenResult.BUSY) {
            BigDoors.get().getCommander().setDoorAvailable(doorUID);
        }
        return reason;
    }

    public static DoorOpenResult processFutureResult(CompletableFuture<DoorOpenResult> result) {
        return result.getNow(DoorOpenResult.ERROR);
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        return Opener.processFutureResult(this.openDoorFuture(door, time, instantOpen, silent, mode, bypassProtectionHooks));
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode) {
        return this.openDoor(door, time, instantOpen, silent, mode, false);
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, boolean bypassProtectionHooks) {
        return this.openDoor(door, 0.0, false, false, this.getChunkLoadMode(door), bypassProtectionHooks);
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, double time) {
        return this.openDoor(door, time, false, false);
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, double time, boolean instantOpen) {
        return this.openDoor(door, time, instantOpen, false);
    }

    @Deprecated
    @Nonnull
    default public DoorOpenResult openDoor(@Nonnull Door door, double time, boolean instantOpen, boolean silent) {
        return this.openDoor(door, time, instantOpen, silent, this.getChunkLoadMode(door));
    }

    default public int getDistanceToWorldLimit(Door door, WorldHeightManager worldHeightManager, RotateDirection upDown) {
        WorldHeightLimits worldLimits = worldHeightManager.getWorldHeightLimits(door.getWorld());
        if (upDown.equals((Object)RotateDirection.UP)) {
            return worldLimits.getUpperLimit() - door.getMaximum().getBlockY();
        }
        if (upDown.equals((Object)RotateDirection.DOWN)) {
            return door.getMinimum().getBlockY() - worldLimits.getLowerLimit();
        }
        throw new IllegalArgumentException("Cannot check distance to world limit in direction: " + upDown.name());
    }

    public RotateDirection getRotateDirection(Door var1);

    default public boolean isValidOpenDirection(@Nullable RotateDirection rotateDirection) {
        if (rotateDirection == null) {
            return false;
        }
        return this.getValidRotateDirections().contains((Object)rotateDirection);
    }

    default public boolean isRotateDirectionValid(@NotNull Door door) {
        return this.isValidOpenDirection(door.getOpenDir());
    }

    @NotNull
    public Optional<Pair<Location, Location>> getNewCoordinates(@NotNull Door var1);

    default public int getSizeLimit(Door door) {
        int globalLimit = BigDoors.get().getConfigLoader().maxDoorSize();
        Player player = Bukkit.getPlayer((UUID)door.getPlayerUUID());
        int personalLimit = player == null ? -1 : Util.getMaxDoorSizeForPlayer(player);
        return Util.minPositive(personalLimit, globalLimit);
    }

    default public boolean isPosFree(long doorUID, @NotNull World world, @NotNull Location min, @NotNull Location max) {
        WorldHeightLimits worldLimits = BigDoors.get().getWorldHeightManager().getWorldHeightLimits(world);
        if (min.getBlockY() < worldLimits.getLowerLimit() || max.getBlockY() > worldLimits.getUpperLimit()) {
            BigDoors.get().getMyLogger().info(String.format("Door %d with y bounds [%d, %d] exceeds world limits: [%d, %d]", doorUID, min.getBlockY(), max.getBlockY(), worldLimits.getLowerLimit(), worldLimits.getUpperLimit()));
            return false;
        }
        for (int xAxis = min.getBlockX(); xAxis <= max.getBlockX(); ++xAxis) {
            for (int yAxis = min.getBlockY(); yAxis <= max.getBlockY(); ++yAxis) {
                for (int zAxis = min.getBlockZ(); zAxis <= max.getBlockZ(); ++zAxis) {
                    Material mat = world.getBlockAt(xAxis, yAxis, zAxis).getType();
                    if (Util.canOverwriteMaterial(mat)) continue;
                    BigDoors.get().getMyLogger().info("Found a block of material " + mat.name() + " in the way when toggling door " + doorUID);
                    return false;
                }
            }
        }
        return true;
    }

    default public boolean isPosFree(long doorUID, @NotNull World world, @NotNull Pair<Location, Location> locations) {
        return this.isPosFree(doorUID, world, (Location)locations.first, (Location)locations.second);
    }

    default public CompletableFuture<Boolean> hasAccessToLocations(@NotNull Door door, @NotNull Location newMin, @NotNull Location newMax) {
        if (BigDoors.get().getProtectionCompatManager().registeredCompatsCount() == 0) {
            return CompletableFuture.completedFuture(true);
        }
        if (door.bypassProtections()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<@Nullable String> oldLoc = BigDoors.get().canBreakBlocksBetweenLocs(door.getPlayerUUID(), door.getPlayerName(), door.getWorld(), door.getMinimum(), door.getMaximum());
        CompletableFuture<@Nullable String> newLoc = BigDoors.get().canBreakBlocksBetweenLocs(door.getPlayerUUID(), door.getPlayerName(), door.getWorld(), newMin, newMax);
        return ((CompletableFuture)Util.getAllCompletableFutureResults(oldLoc, newLoc).thenApply(lst -> {
            @Nullable String canBreakOldBlocks = (String)lst.get(0);
            if (canBreakOldBlocks != null) {
                BigDoors.get().getMyLogger().logMessageToLogFile("Toggle denied because access to new location was prevented by " + canBreakOldBlocks + " for door: " + door);
                return false;
            }
            @Nullable String canBreakNewBlocks = (String)lst.get(1);
            if (canBreakNewBlocks != null) {
                BigDoors.get().getMyLogger().logMessageToLogFile("Toggle denied because access to old location was prevented by " + canBreakNewBlocks + " for door: " + door);
                return false;
            }
            return true;
        })).exceptionally(throwable -> Util.exceptionally(throwable, false));
    }

    default public boolean fireDoorEventTogglePrepare(Door door, boolean instantOpen) {
        DoorEventToggle.ToggleType toggleType = door.isOpen() ? DoorEventToggle.ToggleType.CLOSE : DoorEventToggle.ToggleType.OPEN;
        DoorEventTogglePrepare preparationEvent = new DoorEventTogglePrepare(door, toggleType, instantOpen);
        Bukkit.getPluginManager().callEvent((Event)preparationEvent);
        return preparationEvent.isCancelled();
    }

    default public void fireDoorEventToggleStart(Door door, boolean instantOpen) {
        DoorEventToggle.ToggleType toggleType = door.isOpen() ? DoorEventToggle.ToggleType.CLOSE : DoorEventToggle.ToggleType.OPEN;
        DoorEventToggleStart startEvent = new DoorEventToggleStart(door, toggleType, instantOpen);
        Bukkit.getPluginManager().callEvent((Event)startEvent);
    }

    @NotNull
    public List<RotateDirection> getValidRotateDirections();
}

