/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.moveBlocks.OpenerUtil;
import nl.pim16aap2.bigDoors.moveBlocks.SlidingMover;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector2D;
import org.bukkit.Location;
import org.bukkit.World;

public class SlidingDoorOpener
implements Opener {
    private static final List<RotateDirection> VALID_ROTATE_DIRECTIONS = Collections.unmodifiableList(Arrays.asList(RotateDirection.NORTH, RotateDirection.EAST, RotateDirection.SOUTH, RotateDirection.WEST));
    private final BigDoors plugin;

    public SlidingDoorOpener(BigDoors plugin) {
        this.plugin = plugin;
    }

    @Override
    @Nonnull
    public List<RotateDirection> getValidRotateDirections() {
        return VALID_ROTATE_DIRECTIONS;
    }

    @Override
    public Pair<Vector2D, Vector2D> getChunkRange(Door door) {
        int blocksToMove;
        RotateDirection openDirection = door.getOpenDir();
        if (openDirection == null || openDirection.equals((Object)RotateDirection.NONE) || !this.isRotateDirectionValid(door)) {
            return null;
        }
        boolean NS = openDirection.equals((Object)RotateDirection.NORTH) || openDirection.equals((Object)RotateDirection.SOUTH);
        int n = blocksToMove = door.getBlocksToMove() > 0 ? door.getBlocksToMove() : this.getLengthInDir(door, NS);
        if (door.isOpen()) {
            switch (openDirection) {
                case NORTH: {
                    openDirection = RotateDirection.SOUTH;
                    break;
                }
                case EAST: {
                    openDirection = RotateDirection.WEST;
                    break;
                }
                case SOUTH: {
                    openDirection = RotateDirection.NORTH;
                    break;
                }
                case WEST: {
                    openDirection = RotateDirection.EAST;
                    break;
                }
            }
        }
        return this.getChunkRange(door, new MovementSpecification(blocksToMove, openDirection, NS));
    }

    private Pair<Vector2D, Vector2D> getChunkRange(Door door, MovementSpecification movement) {
        int blocksToMove = movement.getBlocks();
        if (movement.getRotateDirection().equals((Object)RotateDirection.NORTH) || movement.getRotateDirection().equals((Object)RotateDirection.WEST)) {
            blocksToMove *= -1;
        }
        int moveX = 0;
        int moveZ = 0;
        if (movement.NS) {
            moveZ = blocksToMove;
        } else {
            moveX = blocksToMove;
        }
        Location newMin = door.getMinimum().add((double)moveX, 0.0, (double)moveZ);
        Location newMax = door.getMaximum().add((double)moveX, 0.0, (double)moveZ);
        return ChunkUtils.getChunkRangeBetweenCoords(newMin, newMax, door.getMinimum(), door.getMaximum());
    }

    @Override
    public boolean isRotateDirectionValid(@Nonnull Door door) {
        return door.getOpenDir().equals((Object)RotateDirection.NORTH) || door.getOpenDir().equals((Object)RotateDirection.EAST) || door.getOpenDir().equals((Object)RotateDirection.SOUTH) || door.getOpenDir().equals((Object)RotateDirection.WEST);
    }

    @Override
    public RotateDirection getRotateDirection(Door door) {
        if (this.isRotateDirectionValid(door)) {
            return door.getOpenDir();
        }
        RotateDirection openDir = this.getBlocksToMove(door).getRotateDirection();
        if (openDir.equals((Object)RotateDirection.NONE)) {
            return door.getMinimum().getBlockX() == door.getMaximum().getBlockX() ? RotateDirection.NORTH : RotateDirection.EAST;
        }
        return openDir;
    }

    private int getLengthInDir(Door door, boolean NS) {
        if (NS) {
            return 1 + door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ();
        }
        return 1 + door.getMaximum().getBlockX() - door.getMinimum().getBlockX();
    }

    private void getNewCoords(Location min, Location max, MovementSpecification blocksToMove) {
        int addX = 0;
        int addY = 0;
        int addZ = 0;
        switch (blocksToMove.getRotateDirection()) {
            case DOWN: {
                addY = -1 * blocksToMove.getBlocks();
                break;
            }
            case EAST: {
                addX = 1 * blocksToMove.getBlocks();
                break;
            }
            case NORTH: {
                addZ = -1 * blocksToMove.getBlocks();
                break;
            }
            case SOUTH: {
                addZ = 1 * blocksToMove.getBlocks();
                break;
            }
            case UP: {
                addY = 1 * blocksToMove.getBlocks();
                break;
            }
            case WEST: {
                addX = -1 * blocksToMove.getBlocks();
                break;
            }
        }
        min.add((double)addX, (double)addY, (double)addZ);
        max.add((double)addX, (double)addY, (double)addZ);
    }

    @Override
    @Nonnull
    public Optional<Pair<Location, Location>> getNewCoordinates(@Nonnull Door door) {
        if (door.getBlocksToMove() > this.plugin.getConfigLoader().getMaxBlocksToMove()) {
            this.plugin.getMyLogger().warn("blocksToMove value of " + door.getBlocksToMove() + " exceeds limit of " + this.plugin.getConfigLoader().getMaxBlocksToMove() + " for sliding door: " + door);
            return Optional.empty();
        }
        int maxDoorSize = this.getSizeLimit(door);
        if (maxDoorSize > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().warn("Size " + door.getBlockCount() + " exceeds limit of " + maxDoorSize + " for sliding door: " + door);
            return Optional.empty();
        }
        MovementSpecification blocksToMove = this.getBlocksToMove(door);
        if (blocksToMove.getBlocks() == 0) {
            this.plugin.getMyLogger().warn("Received invalid blocksToMove value of 0 for sliding door: " + door);
            return Optional.empty();
        }
        Location newMin = door.getMinimum();
        Location newMax = door.getMaximum();
        this.getNewCoords(newMin, newMax, blocksToMove);
        return Optional.of(new Pair<Location, Location>(newMin, newMax));
    }

    @Override
    @Nonnull
    public CompletableFuture<DoorOpenResult> openDoorFuture(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        return OpenerUtil.rescheduleTaskForLocationIfNeeded(door, () -> this.openDoorFuture0(door, time, instantOpen, silent, mode, bypassProtectionHooks));
    }

    @Nonnull
    private CompletableFuture<DoorOpenResult> openDoorFuture0(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        int maxDoorSize;
        this.plugin.assertSchedulerRunning();
        if (!this.plugin.getCommander().canGo()) {
            this.plugin.getMyLogger().info("Failed to toggle: " + door.toSimpleString() + ", as door toggles are currently disabled!");
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (this.plugin.getCommander().isDoorBusyRegisterIfNot(door.getDoorUID())) {
            if (!silent) {
                this.plugin.getMyLogger().myLogger(Level.INFO, "Sliding Door " + door.toSimpleString() + " is not available right now!");
            }
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.BUSY, door.getDoorUID()));
        }
        ChunkUtils.ChunkLoadResult chunkLoadResult = this.chunksLoaded(door, mode);
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.FAIL) {
            this.plugin.getMyLogger().logMessage("Chunks for sliding door " + door.toSimpleString() + " are not loaded!", true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CHUNKSNOTLOADED, door.getDoorUID()));
        }
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.REQUIRED_LOAD) {
            instantOpen = true;
        }
        if ((maxDoorSize = this.getSizeLimit(door)) > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().logMessage("Sliding Door " + door.toSimpleString() + " Exceeds the size limit: " + maxDoorSize, true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.ERROR, door.getDoorUID()));
        }
        if (door.getBlocksToMove() > BigDoors.get().getConfigLoader().getMaxBlocksToMove()) {
            this.plugin.getMyLogger().logMessage("Sliding Door " + door.toSimpleString() + " Exceeds blocksToMove limit: " + door.getBlocksToMove() + ". Limit = " + BigDoors.get().getConfigLoader().getMaxBlocksToMove(), true, false);
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.BLOCKSTOMOVEINVALID, door.getDoorUID()));
        }
        MovementSpecification blocksToMove = this.getBlocksToMove(door);
        if (blocksToMove.getBlocks() == 0) {
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NODIRECTION, door.getDoorUID()));
        }
        if (!this.isRotateDirectionValid(door)) {
            RotateDirection newRotDir = blocksToMove.getRotateDirection();
            if (door.isOpen()) {
                newRotDir = newRotDir.equals((Object)RotateDirection.NORTH) ? RotateDirection.SOUTH : (newRotDir.equals((Object)RotateDirection.SOUTH) ? RotateDirection.NORTH : (newRotDir.equals((Object)RotateDirection.EAST) ? RotateDirection.WEST : RotateDirection.EAST));
            }
            this.plugin.getMyLogger().logMessage("Updating openDirection of sliding door " + door.toSimpleString() + " to " + newRotDir.name() + ". If this is undesired, change it via the GUI.", true, false);
            this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), newRotDir);
        }
        Location newMin = door.getMinimum();
        Location newMax = door.getMaximum();
        this.getNewCoords(newMin, newMax, blocksToMove);
        if (this.fireDoorEventTogglePrepare(door, instantOpen)) {
            return CompletableFuture.completedFuture(this.abort(DoorOpenResult.CANCELLED, door.getDoorUID()));
        }
        if (bypassProtectionHooks) {
            return CompletableFuture.completedFuture(this.openDoor0(door, time, instantOpen, blocksToMove));
        }
        boolean instantOpen0 = instantOpen;
        return ((CompletableFuture)this.hasAccessToLocations(door, newMin, newMax).thenCompose(hasAccess -> {
            if (!hasAccess.booleanValue()) {
                return CompletableFuture.completedFuture(this.abort(DoorOpenResult.NOPERMISSION, door.getDoorUID()));
            }
            return Util.runSync(() -> this.openDoor0(door, time, instantOpen0, blocksToMove), 1L, TimeUnit.SECONDS, DoorOpenResult.ERROR);
        })).exceptionally(throwable -> Util.exceptionally(throwable, DoorOpenResult.ERROR));
    }

    private DoorOpenResult openDoor0(Door door, double time, boolean instantOpen, MovementSpecification blocksToMove) {
        this.plugin.getCommander().addBlockMover(new SlidingMover(this.plugin, door.getWorld(), time, door, instantOpen, blocksToMove.getBlocks(), blocksToMove.getRotateDirection(), this.plugin.getConfigLoader().sdMultiplier()));
        this.fireDoorEventToggleStart(door, instantOpen);
        return DoorOpenResult.SUCCESS;
    }

    private int getBlocksInDir(Door door, RotateDirection slideDir) {
        int endX;
        int startX;
        int endZ;
        int startZ;
        int moveBlocks = 0;
        int xMin = door.getMinimum().getBlockX();
        int yMin = door.getMinimum().getBlockY();
        int zMin = door.getMinimum().getBlockZ();
        int xMax = door.getMaximum().getBlockX();
        int yMax = door.getMaximum().getBlockY();
        int zMax = door.getMaximum().getBlockZ();
        int xLen = Math.abs(xMax - xMin) + 1;
        int zLen = Math.abs(zMax - zMin) + 1;
        xLen = door.getOpenDir() == RotateDirection.NONE || door.getBlocksToMove() < 1 ? xLen : door.getBlocksToMove();
        zLen = door.getOpenDir() == RotateDirection.NONE || door.getBlocksToMove() < 1 ? zLen : door.getBlocksToMove();
        int sizeLimit = BigDoors.get().getConfigLoader().getMaxBlocksToMove();
        xLen = Util.minPositive(sizeLimit, xLen);
        zLen = Util.minPositive(sizeLimit, zLen);
        if (xLen <= 0 && zLen <= 0) {
            return 0;
        }
        int step = slideDir == RotateDirection.NORTH || slideDir == RotateDirection.WEST ? -1 : 1;
        int startY = yMin;
        int endY = yMax;
        if (slideDir == RotateDirection.NORTH) {
            startZ = zMin - 1;
            endZ = zMin - zLen - 1;
            startX = xMin;
            endX = xMax;
        } else if (slideDir == RotateDirection.SOUTH) {
            startZ = zMax + 1;
            endZ = zMax + zLen + 1;
            startX = xMin;
            endX = xMax;
        } else if (slideDir == RotateDirection.WEST) {
            startZ = zMin;
            endZ = zMax;
            startX = xMin - 1;
            endX = xMin - xLen - 1;
        } else if (slideDir == RotateDirection.EAST) {
            startZ = zMin;
            endZ = zMax;
            startX = xMax + 1;
            endX = xMax + xLen + 1;
        } else {
            return 0;
        }
        World world = door.getWorld();
        if (slideDir == RotateDirection.NORTH || slideDir == RotateDirection.SOUTH) {
            for (int zAxis = startZ; zAxis != endZ; zAxis += step) {
                for (int xAxis = startX; xAxis != endX + 1; ++xAxis) {
                    for (int yAxis = startY; yAxis != endY + 1; ++yAxis) {
                        if (Util.canOverwriteMaterial(world.getBlockAt(xAxis, yAxis, zAxis).getType())) continue;
                        return moveBlocks;
                    }
                }
                moveBlocks += step;
            }
        } else {
            for (int xAxis = startX; xAxis != endX; xAxis += step) {
                for (int zAxis = startZ; zAxis != endZ + 1; ++zAxis) {
                    for (int yAxis = startY; yAxis != endY + 1; ++yAxis) {
                        if (Util.canOverwriteMaterial(world.getBlockAt(xAxis, yAxis, zAxis).getType())) continue;
                        return moveBlocks;
                    }
                }
                moveBlocks += step;
            }
        }
        return moveBlocks;
    }

    private MovementSpecification getBlocksToMove(Door door) {
        int blocksNorth = 0;
        int blocksEast = 0;
        int blocksSouth = 0;
        int blocksWest = 0;
        if (door.getOpenDir().equals((Object)RotateDirection.NONE)) {
            blocksNorth = this.getBlocksInDir(door, RotateDirection.NORTH);
            blocksSouth = this.getBlocksInDir(door, RotateDirection.SOUTH);
            blocksEast = this.getBlocksInDir(door, RotateDirection.EAST);
            blocksWest = this.getBlocksInDir(door, RotateDirection.WEST);
        } else if (door.getOpenDir().equals((Object)RotateDirection.NORTH) && !door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.SOUTH) && door.isOpen()) {
            blocksNorth = this.getBlocksInDir(door, RotateDirection.NORTH);
        } else if (door.getOpenDir().equals((Object)RotateDirection.NORTH) && door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.SOUTH) && !door.isOpen()) {
            blocksSouth = this.getBlocksInDir(door, RotateDirection.SOUTH);
        } else if (door.getOpenDir().equals((Object)RotateDirection.EAST) && !door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.WEST) && door.isOpen()) {
            blocksEast = this.getBlocksInDir(door, RotateDirection.EAST);
        } else if (door.getOpenDir().equals((Object)RotateDirection.EAST) && door.isOpen() || door.getOpenDir().equals((Object)RotateDirection.WEST) && !door.isOpen()) {
            blocksWest = this.getBlocksInDir(door, RotateDirection.WEST);
        } else {
            return new MovementSpecification(0, RotateDirection.NONE);
        }
        int maxVal = Math.max(Math.abs(blocksNorth), Math.max(blocksEast, Math.max(blocksSouth, Math.abs(blocksWest))));
        if (Math.abs(blocksNorth) == maxVal) {
            return new MovementSpecification(blocksNorth, RotateDirection.NORTH);
        }
        if (blocksEast == maxVal) {
            return new MovementSpecification(blocksEast, RotateDirection.EAST);
        }
        if (blocksSouth == maxVal) {
            return new MovementSpecification(blocksSouth, RotateDirection.SOUTH);
        }
        if (Math.abs(blocksWest) == maxVal) {
            return new MovementSpecification(blocksWest, RotateDirection.WEST);
        }
        return new MovementSpecification(0, RotateDirection.NONE);
    }

    private static final class MovementSpecification {
        private final int blocks;
        private final RotateDirection rotateDirection;
        private final boolean NS;

        MovementSpecification(int blocks, RotateDirection rotateDirection, boolean NS) {
            this.blocks = Math.abs(blocks);
            this.rotateDirection = rotateDirection;
            this.NS = NS;
        }

        MovementSpecification(int blocks, RotateDirection rotateDirection) {
            this(blocks, rotateDirection, rotateDirection == RotateDirection.NORTH || rotateDirection == RotateDirection.SOUTH);
        }

        public int getBlocks() {
            return this.blocks;
        }

        public RotateDirection getRotateDirection() {
            return this.rotateDirection;
        }
    }
}

