/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.ArrayList;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.NMS.CustomCraftFallingBlock;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalRunnable;
import nl.pim16aap2.bigDoors.lib.universalScheduler.UniversalScheduler;
import nl.pim16aap2.bigDoors.moveBlocks.BlockMover;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.MyBlockData;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class VerticalMover
extends BlockMover {
    private FallingBlockFactory fabf;
    private Door door;
    private double time;
    private World world;
    private BigDoors plugin;
    private int tickRate;
    private int blocksToMove;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int zMin;
    private int zMax;
    private int endCount;
    private UniversalRunnable animationRunnable;

    public VerticalMover(BigDoors plugin, World world, double time, Door door, boolean instantOpen, int blocksToMove, double multiplier) {
        super(plugin, door, instantOpen);
        this.plugin = plugin;
        this.world = world;
        this.door = door;
        this.fabf = plugin.getFABF();
        this.blocksToMove = blocksToMove;
        this.xMin = door.getMinimum().getBlockX();
        this.yMin = door.getMinimum().getBlockY();
        this.zMin = door.getMinimum().getBlockZ();
        this.xMax = door.getMaximum().getBlockX();
        this.yMax = door.getMaximum().getBlockY();
        this.zMax = door.getMaximum().getBlockZ();
        double speed = 1.0;
        double pcMult = multiplier;
        pcMult = pcMult == 0.0 ? 1.0 : pcMult;
        int maxSpeed = 6;
        if (time != 0.0) {
            speed = (double)Math.abs(blocksToMove) / time;
            this.time = time;
        }
        if (time == 0.0 || speed > (double)maxSpeed) {
            speed = (blocksToMove < 0 ? 1.7 : 0.8) * pcMult;
            speed = speed > (double)maxSpeed ? (double)maxSpeed : speed;
            this.time = (double)Math.abs(blocksToMove) / speed;
        }
        this.tickRate = Util.tickRateFromSpeed(speed);
        BigDoors.getScheduler().runTaskLater(door.getMinimum(), this::createAnimatedBlocks, 2L);
    }

    private void createAnimatedBlocks() {
        ArrayList<MyBlockData> newBlocks = new ArrayList<MyBlockData>(this.door.getBlockCount());
        ArrayList<NMSBlock> edges = new ArrayList<NMSBlock>(Math.min(this.door.getBlockCount(), (this.xMax - this.xMin + 1) * 2 + (this.yMax - this.yMin + 1) * 2 + (this.zMax - this.zMin + 1) * 2));
        FallingBlockFactory.Specification spec = VerticalMover.createBlockFactorySpec(this.plugin);
        int yAxis = this.yMin;
        do {
            int zAxis = this.zMin;
            do {
                for (int xAxis = this.xMin; xAxis <= this.xMax; ++xAxis) {
                    Location startLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    Location newFBlockLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    Block vBlock = this.world.getBlockAt(startLocation);
                    Material mat = vBlock.getType();
                    if (!Util.isAllowedBlock(mat)) continue;
                    byte matData = vBlock.getData();
                    BlockState bs = vBlock.getState();
                    MaterialData materialData = bs.getData();
                    NMSBlock block2 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                    if (!BigDoors.isOnFlattenedVersion() || UniversalScheduler.isFolia) {
                        vBlock.setType(Material.AIR);
                    }
                    CustomCraftFallingBlock fBlock = null;
                    if (!this.instantOpen) {
                        fBlock = this.fabf.createFallingBlockWithMetadata(spec, newFBlockLocation, block2, matData, mat);
                    }
                    newBlocks.add(new MyBlockData(mat, matData, fBlock, 0.0, materialData, block2, 0, startLocation));
                    if (xAxis != this.xMin && xAxis != this.xMax && yAxis != this.yMin && yAxis != this.yMax && zAxis != this.zMin && zAxis != this.zMax) continue;
                    edges.add(block2);
                }
            } while (++zAxis <= this.zMax);
        } while (++yAxis <= this.yMax);
        this.savedBlocks.addAll(newBlocks);
        if (BigDoors.isOnFlattenedVersion()) {
            this.savedBlocks.forEach(myBlockData -> myBlockData.getBlock().deleteOriginalBlock(false));
            edges.forEach(block -> block.deleteOriginalBlock(true));
        }
        if (!this.instantOpen) {
            this.rotateEntities();
        } else {
            this.putBlocks(false);
        }
    }

    @Override
    public synchronized void cancel(boolean onDisable) {
        if (this.animationRunnable == null) {
            return;
        }
        this.animationRunnable.cancel();
        this.putBlocks(onDisable);
    }

    @Override
    public synchronized void putBlocks(boolean onDisable) {
        super.putBlocks(onDisable, this.time, this.endCount, (__, x, y, z) -> this.getNewLocation(x, y, z), () -> VerticalMover.updateCoords(this.door, null, this.blocksToMove > 0 ? RotateDirection.UP : RotateDirection.DOWN, this.blocksToMove, false));
    }

    private Location getNewLocation(double xAxis, double yAxis, double zAxis) {
        return new Location(this.world, xAxis, yAxis + (double)this.blocksToMove, zAxis);
    }

    private void rotateEntities() {
        this.endCount = (int)((double)(20.0f / (float)this.tickRate) * this.time);
        this.animationRunnable = new UniversalRunnable(){
            double counter = 0.0;
            double step = (double)VerticalMover.access$000(VerticalMover.this) / (double)VerticalMover.access$100(VerticalMover.this);
            double stepSum = 0.0;
            int totalTicks = (int)((double)VerticalMover.access$100(VerticalMover.this) * 1.1);
            long startTime = System.nanoTime();
            long lastTime;
            long currentTime = System.nanoTime();
            final MyBlockData firstBlockData;
            {
                this.firstBlockData = VerticalMover.this.savedBlocks.stream().filter(block -> !block.getMat().equals((Object)Material.AIR)).findFirst().orElse(null);
            }

            @Override
            public void run() {
                if (this.counter == 0.0 || this.counter < (double)(VerticalMover.this.endCount - 27 / VerticalMover.this.tickRate) && this.counter % (double)(5 * VerticalMover.this.tickRate / 4) == 0.0) {
                    Util.playSound(VerticalMover.this.door.getEngine(), "bd.dragging2", 0.5f, 0.6f);
                }
                this.lastTime = this.currentTime;
                this.currentTime = System.nanoTime();
                long msSinceStart = (this.currentTime - this.startTime) / 1000000L;
                if (!VerticalMover.this.plugin.getCommander().isPaused()) {
                    this.counter = msSinceStart / (long)(50 * VerticalMover.this.tickRate);
                } else {
                    this.startTime += this.currentTime - this.lastTime;
                }
                this.stepSum = this.counter < (double)(VerticalMover.this.endCount - 1) ? this.step * this.counter : (double)VerticalMover.this.blocksToMove;
                if (!VerticalMover.this.plugin.getCommander().canGo() || this.counter > (double)this.totalTicks || this.firstBlockData == null) {
                    Util.playSound(VerticalMover.this.door.getEngine(), "bd.thud", 2.0f, 0.15f);
                    for (MyBlockData savedBlock : VerticalMover.this.savedBlocks) {
                        if (savedBlock.getMat().equals((Object)Material.AIR)) continue;
                        savedBlock.getFBlock().setVelocity(new Vector(0.0, 0.0, 0.0));
                    }
                    BigDoors.getScheduler().callSyncMethod(() -> {
                        VerticalMover.this.putBlocks(false);
                        return null;
                    });
                    this.cancel();
                } else {
                    Location loc = this.firstBlockData.getStartLocation();
                    loc.add(0.0, this.stepSum, 0.0);
                    Vector vec = loc.toVector().subtract(this.firstBlockData.getFBlock().getLocation().toVector());
                    vec.multiply(0.101);
                    for (MyBlockData block : VerticalMover.this.savedBlocks) {
                        if (block.getMat().equals((Object)Material.AIR)) continue;
                        block.getFBlock().setVelocity(vec);
                    }
                }
            }
        };
        this.animationRunnable.runTaskTimerAsynchronously((Plugin)this.plugin, 14L, this.tickRate);
    }

    public static void updateCoords(Door door, DoorDirection currentDirection, RotateDirection rotDirection, int moved, boolean shadow) {
        int xMin = door.getMinimum().getBlockX();
        int yMin = door.getMinimum().getBlockY();
        int zMin = door.getMinimum().getBlockZ();
        int xMax = door.getMaximum().getBlockX();
        int yMax = door.getMaximum().getBlockY();
        int zMax = door.getMaximum().getBlockZ();
        Location newMax = new Location(door.getWorld(), (double)xMax, (double)(yMax + moved), (double)zMax);
        Location newMin = new Location(door.getWorld(), (double)xMin, (double)(yMin + moved), (double)zMin);
        door.setMaximum(newMax);
        door.setMinimum(newMin);
        boolean isOpen = shadow ? door.isOpen() : !door.isOpen();
        BigDoors.get().getCommander().updateDoorCoords(door.getDoorUID(), isOpen, newMin.getBlockX(), newMin.getBlockY(), newMin.getBlockZ(), newMax.getBlockX(), newMax.getBlockY(), newMax.getBlockZ());
    }

    @Override
    public long getDoorUID() {
        return this.door.getDoorUID();
    }

    @Override
    public Door getDoor() {
        return this.door;
    }
}

