/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class BukkitReflectionUtil {
    public static final String NMS_BASE = BukkitReflectionUtil.findNMSBase();
    public static final String CRAFT_BASE = Bukkit.getServer().getClass().getPackage().getName() + ".";
    private static final Class<?> classNMSPlayer = ReflectionBuilder.findClass(NMS_BASE + "EntityPlayer", "net.minecraft.server.level.EntityPlayer").get();
    private static final Class<?> classPlayerConnection = ReflectionBuilder.findClass(NMS_BASE + "PlayerConnection", "net.minecraft.server.network.PlayerConnection").get();
    private static final Class<?> classVec3D;
    private static final Class<?> classCraftPlayer;
    private static final Field fieldPlayerConnection;
    private static final Field[] fieldsFlyingCounters;
    private static final Method methodGetHandle;

    private BukkitReflectionUtil() {
    }

    public static void resetFlyingCounters(Player player) {
        try {
            Object playerConnection = fieldPlayerConnection.get(methodGetHandle.invoke((Object)player, new Object[0]));
            fieldsFlyingCounters[0].setInt(playerConnection, 0);
            fieldsFlyingCounters[1].setInt(playerConnection, 0);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to get handle of player!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reset flying counters!", e);
        }
    }

    private static Field[] findFlyingCounters(Class<?> classPlayerConnection) throws NoSuchFieldException {
        Field[] fields = new Field[2];
        if (BigDoors.SERVER_VERSION.getMinor() != 19) {
            BukkitReflectionUtil.discoverFlyingCounters(classPlayerConnection, fields);
        } else {
            switch (BigDoors.SERVER_VERSION.getPatch()) {
                case 0: {
                    fields[0] = classPlayerConnection.getDeclaredField("F");
                    fields[1] = classPlayerConnection.getDeclaredField("H");
                    break;
                }
                case 1: 
                case 2: {
                    fields[0] = classPlayerConnection.getDeclaredField("G");
                    fields[1] = classPlayerConnection.getDeclaredField("I");
                    break;
                }
                case 3: 
                case 4: {
                    fields[0] = classPlayerConnection.getDeclaredField("H");
                    fields[1] = classPlayerConnection.getDeclaredField("J");
                    break;
                }
                default: {
                    BukkitReflectionUtil.discoverFlyingCounters(classPlayerConnection, fields);
                }
            }
        }
        for (Field field : fields) {
            field.setAccessible(true);
        }
        return fields;
    }

    private static void discoverFlyingCounters(Class<?> classPlayerConnection, Field[] fields) {
        boolean foundVec = false;
        int foundCount = 0;
        Field[] declaredFields = classPlayerConnection.getDeclaredFields();
        for (int idx = 0; idx < declaredFields.length; ++idx) {
            Field peek;
            Field field = declaredFields[idx];
            Class<?> type = field.getType();
            if (type == classVec3D) {
                foundVec = true;
                continue;
            }
            if (!foundVec || type != Boolean.TYPE) continue;
            if ((peek = declaredFields[++idx]).getType() != Integer.TYPE) {
                throw new IllegalStateException("Expected field type 'int' but found: '" + peek.getType().getName() + "'");
            }
            fields[foundCount++] = peek;
            if (foundCount == 2) break;
        }
    }

    public static void init() {
    }

    public static String findNMSBase() {
        String[] split = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        if (split.length < 4) {
            return "net.minecraft.server.";
        }
        return "net.minecraft.server." + split[3] + ".";
    }

    static {
        classCraftPlayer = ReflectionBuilder.findClass(CRAFT_BASE + "entity.CraftPlayer").get();
        classVec3D = ReflectionBuilder.findClass(NMS_BASE + "Vec3D", "net.minecraft.world.phys.Vec3D").get();
        fieldPlayerConnection = ReflectionBuilder.findField().inClass(classNMSPlayer).ofType(classPlayerConnection).get();
        try {
            fieldsFlyingCounters = BukkitReflectionUtil.findFlyingCounters(classPlayerConnection);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find flying counters!", e);
        }
        methodGetHandle = (Method)ReflectionBuilder.findMethod().inClass(classCraftPlayer).findMultiple().withName("getHandle").withReturnType(classNMSPlayer).atMost(1).get().get(0);
    }
}

