/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.IBoundedRetriever;
import nl.pim16aap2.bigDoors.reflection.ReflectionBackend;
import nl.pim16aap2.bigDoors.reflection.ReflectionFinder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodFinder {
    @Contract(value="_ -> new")
    public MethodFinderInSource inClass(@NotNull Class<?> source) {
        return new MethodFinderInSource(Objects.requireNonNull(source, "Source class cannot be null!"));
    }

    public final class MethodFinderInSource {
        @NotNull
        private final Class<?> source;

        private MethodFinderInSource(Class<?> source) {
            this.source = source;
        }

        @Contract(value="_ -> new")
        public NamedMethodFinder withName(@NotNull String name) {
            return new NamedMethodFinder(this.source, name);
        }

        @Contract(value="_ -> new")
        public TypedMethodFinder withReturnType(@NotNull Type returnType) {
            return new TypedMethodFinder(this.source, returnType);
        }

        public MultipleMethodsFinder findMultiple() {
            return new MultipleMethodsFinder(this.source);
        }
    }

    public final class MultipleMethodsFinder
    extends MethodFinderBase<List<Method>, MultipleMethodsFinder>
    implements IBoundedRetriever<List<Method>, MultipleMethodsFinder> {
        @Nullable
        private String name;
        @Nullable
        private Type returnType;
        private int expected;
        private int atMost;
        private int atLeast;

        private MultipleMethodsFinder(Class<?> source) {
            super(source);
            this.expected = -1;
            this.atMost = -1;
            this.atLeast = -1;
        }

        private MultipleMethodsFinder(MultipleMethodsFinder other) {
            super(other);
            this.expected = -1;
            this.atMost = -1;
            this.atLeast = -1;
            this.name = other.name;
            this.returnType = other.returnType;
            this.expected = other.expected;
            this.atMost = other.atMost;
            this.atLeast = other.atLeast;
        }

        @Contract(value="_ -> this")
        public MultipleMethodsFinder withName(@NotNull String name) {
            this.name = name;
            return this;
        }

        @Contract(value="_ -> this")
        public MultipleMethodsFinder withReturnType(@NotNull Type returnType) {
            this.returnType = returnType;
            return this;
        }

        @Override
        public List<Method> get() {
            List<Method> found = ReflectionBackend.findMethods(this.checkSuperClasses, this.checkInterfaces, this.source, this.name, this.modifiers, this.parameters, this.returnType);
            if (this.expected >= 0 && this.expected != found.size()) {
                return this.handleInvalid(found, String.format("Expected %d methods but found %d for input: ", this.expected, found.size()));
            }
            if (this.atMost >= 0 && found.size() > this.atMost) {
                return this.handleInvalid(found, String.format("Expected at most %d methods, but found %d for input: ", this.atMost, found.size()));
            }
            if (this.atLeast >= 0 && found.size() < this.atLeast) {
                return this.handleInvalid(found, String.format("Expected at least %d methods, but found %d for input: ", this.atLeast, found.size()));
            }
            return found;
        }

        private List<Method> handleInvalid(List<Method> found, @NotNull String str) {
            if (this.nonnull) {
                throw new IllegalStateException(str + ReflectionBackend.methodSearchRequestToString(this.checkSuperClasses, this.checkInterfaces, this.source, this.name, this.modifiers, this.parameters, this.returnType) + "\nFound methods: " + found);
            }
            return null;
        }

        @Override
        public MultipleMethodsFinder atLeast(int val) {
            this.atLeast = val;
            return this;
        }

        @Override
        public MultipleMethodsFinder atMost(int val) {
            this.atMost = val;
            return this;
        }

        @Override
        public MultipleMethodsFinder exactCount(int val) {
            this.expected = val;
            return this;
        }
    }

    public static final class TypedMethodFinder
    extends MethodFinderBase<Method, TypedMethodFinder> {
        @NotNull
        private final Type returnType;

        private TypedMethodFinder(Class<?> source, @NotNull Type returnType) {
            super(source);
            this.returnType = Objects.requireNonNull(returnType, "Return type of typed method cannot be null!");
        }

        @Override
        public Method get() {
            return ReflectionBackend.findMethod(this.nonnull, this.checkSuperClasses, this.checkInterfaces, this.source, null, this.modifiers, this.parameters, this.returnType);
        }
    }

    public static final class NamedMethodFinder
    extends MethodFinderBase<Method, NamedMethodFinder> {
        @NotNull
        private final String name;

        private NamedMethodFinder(Class<?> source, @NotNull String name) {
            super(source);
            this.name = Objects.requireNonNull(name, "Name of named method cannot be null!");
        }

        @Override
        public Method get() {
            return ReflectionBackend.findMethod(this.nonnull, this.checkSuperClasses, this.checkInterfaces, this.source, this.name, this.modifiers, this.parameters, null);
        }
    }

    public static abstract class MethodFinderBase<T, U extends MethodFinderBase<T, U>>
    extends ReflectionFinder.ReflectionFinderWithParameters<T, U> {
        @NotNull
        protected final Class<?> source;
        protected boolean checkSuperClasses = false;
        protected boolean checkInterfaces = false;

        private MethodFinderBase(Class<?> source) {
            this.source = Objects.requireNonNull(source, "Source class has not been set yet!");
        }

        private MethodFinderBase(@NotNull MethodFinderBase<T, U> other) {
            super((ReflectionFinder.ReflectionFinderWithParameters<?, ?>)other);
            this.source = other.source;
            this.checkSuperClasses = other.checkSuperClasses;
            this.checkInterfaces = other.checkInterfaces;
        }

        @Contract(value="-> this")
        public U checkSuperClasses() {
            this.checkSuperClasses = true;
            return (U)this;
        }

        @Contract(value="-> this")
        public U ignoreSuperClasses() {
            this.checkSuperClasses = false;
            return (U)this;
        }

        @Contract(value="-> this")
        public U checkInterfaces() {
            this.checkInterfaces = true;
            return (U)this;
        }

        @Contract(value="-> this")
        public U ignoreInterfaces() {
            this.checkInterfaces = false;
            return (U)this;
        }
    }
}

