/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.lib.asm.ClassReader;
import nl.pim16aap2.bigDoors.lib.asm.ClassVisitor;
import nl.pim16aap2.bigDoors.lib.asm.ClassWriter;
import nl.pim16aap2.bigDoors.lib.asm.MethodVisitor;
import nl.pim16aap2.bigDoors.lib.asm.Type;
import nl.pim16aap2.bigDoors.lib.asm.tree.AbstractInsnNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.FieldInsnNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.MethodInsnNode;
import nl.pim16aap2.bigDoors.lib.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;

public final class ASMUtil {
    private ASMUtil() {
    }

    public static String getClassName(Class<?> clz) {
        return clz.getName().replace('.', '/');
    }

    public static boolean executableContainsMethodCall(Executable executable, Method method) {
        try {
            return Objects.requireNonNull(ASMUtil.processMethod(executable, null, (a, n, d, s, e) -> MethodInCallFinder.create(a, n, d, s, e, method.getDeclaringClass(), Type.getType(method), 1))).methods.length > 0;
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to analyze executable: " + executable.toGenericString(), e2);
        }
    }

    public static String getStaticFieldAccess(Class<?> fieldType, Executable executable) {
        Type type;
        if (executable instanceof Method) {
            type = Type.getType((Method)executable);
        } else if (executable instanceof Constructor) {
            type = Type.getType((Constructor)executable);
        } else {
            throw new IllegalArgumentException("Input executable type '" + executable.toGenericString() + "' is not supported!");
        }
        try {
            return Objects.requireNonNull(ASMUtil.processMethod(executable, null, (a, n, d, s, e) -> StaticFieldFinder.create(a, n, d, s, e, fieldType, 1))).fields[0];
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to find method call in method of type: " + type, e2);
        }
    }

    public static String getMethodNameFromMethodCall(Executable executable, @Nullable Class<?> ownerClass, Class<?> returnType, Class<?> ... parameters) {
        return ASMUtil.getMethodNamesFromMethodCall(executable, 1, ownerClass, returnType, parameters)[0];
    }

    public static String[] getMethodNamesFromMethodCall(Executable executable, int limit, @Nullable Class<?> ownerClass, Class<?> returnType, Class<?> ... parameters) {
        Type[] paramTypesTmp = new Type[parameters.length];
        int skipped = 0;
        for (int idx = 0; idx < parameters.length; ++idx) {
            if (parameters[idx] == null) {
                ++skipped;
                continue;
            }
            paramTypesTmp[idx] = Type.getType(parameters[idx]);
        }
        Type[] paramTypes = Arrays.copyOf(paramTypesTmp, parameters.length - skipped);
        Type type = Type.getMethodType(Type.getType(returnType), paramTypes);
        try {
            return Objects.requireNonNull(ASMUtil.processMethod(executable, null, (a, n, d, s, e) -> MethodInCallFinder.create(a, n, d, s, e, ownerClass, type, limit))).methods;
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to find method call in method of type: " + type, e2);
        }
    }

    @Nullable
    public static <T extends MethodVisitor> T processMethod(Executable executable, @Nullable IMethodVisitorAppender methodVisitorAppender, @Nullable IMethodVisitorReplacer<T> methodVisitorReplacer) throws IOException {
        ClassReader cr = ASMUtil.getClassReader(executable.getDeclaringClass());
        ClassWriter cw = new ClassWriter(cr, 1);
        MyClassVisitor<T> cv = new MyClassVisitor<T>(cw, executable, methodVisitorAppender, methodVisitorReplacer);
        cr.accept(cv, 0);
        return (T)((MyClassVisitor)cv).replacementVisitor;
    }

    public static ClassReader getClassReader(Class<?> clz) throws IOException {
        String classAsPath = ASMUtil.getClassName(clz) + ".class";
        InputStream inputStream = Objects.requireNonNull(clz.getClassLoader().getResourceAsStream(classAsPath), "Failed to get " + clz + " class resources.");
        return new ClassReader(inputStream);
    }

    @FunctionalInterface
    public static interface IMethodVisitorReplacer<T extends MethodVisitor> {
        public T create(int var1, @NotNull String var2, @NotNull String var3, @Nullable String var4, @Nullable String[] var5);
    }

    @FunctionalInterface
    public static interface IMethodVisitorAppender {
        public MethodVisitor append(MethodVisitor var1);
    }

    private static final class MethodInCallFinder
    extends MethodNode {
        @Nullable
        private final String ownerClassName;
        private final Type type;
        private final int limit;
        private final String[] methods;

        public MethodInCallFinder(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, @Nullable Class<?> ownerClass, Type type, int limit) {
            super(589824, access, name, desc, signature, exceptions);
            this.type = type;
            this.limit = limit;
            this.ownerClassName = ownerClass == null ? null : ASMUtil.getClassName(ownerClass);
            this.methods = new String[limit];
        }

        public static MethodInCallFinder create(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, @Nullable Class<?> ownerClass, Type type, int limit) {
            return new MethodInCallFinder(access, name, desc, signature, exceptions, ownerClass, type, limit);
        }

        @Override
        public void visitEnd() {
            int idx = 0;
            for (AbstractInsnNode node : this.instructions) {
                if (idx >= this.limit) break;
                if (!(node instanceof MethodInsnNode) || node.getOpcode() != 182) continue;
                MethodInsnNode invoke = (MethodInsnNode)node;
                if (this.ownerClassName != null && !invoke.owner.equals(this.ownerClassName) || !Type.getType(invoke.desc).equals(this.type)) continue;
                this.methods[idx++] = invoke.name;
            }
        }
    }

    private static final class StaticFieldFinder
    extends MethodNode {
        @Nullable
        private final String fieldClassType;
        private final int limit;
        private final String[] fields;

        public StaticFieldFinder(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, Class<?> fieldClassType, int limit) {
            super(589824, access, name, desc, signature, exceptions);
            this.limit = limit;
            this.fieldClassType = fieldClassType == null ? null : ASMUtil.getClassName(fieldClassType);
            this.fields = new String[limit];
        }

        public static StaticFieldFinder create(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions, Class<?> fieldClassType, int limit) {
            return new StaticFieldFinder(access, name, desc, signature, exceptions, fieldClassType, limit);
        }

        @Override
        public void visitEnd() {
            int idx = 0;
            for (AbstractInsnNode node : this.instructions) {
                if (idx >= this.limit) break;
                if (!(node instanceof FieldInsnNode) || node.getOpcode() != 178) continue;
                FieldInsnNode fieldInvoke = (FieldInsnNode)node;
                if (!fieldInvoke.owner.equals(this.fieldClassType)) continue;
                this.fields[idx++] = fieldInvoke.name;
            }
        }
    }

    private static final class MyClassVisitor<T extends MethodVisitor>
    extends ClassVisitor {
        @NotNull
        private final Type type;
        @NotNull
        private final String executableName;
        @Nullable
        private final IMethodVisitorAppender methodVisitorAppender;
        @Nullable
        private final IMethodVisitorReplacer<T> methodVisitorReplacer;
        @Nullable
        private T replacementVisitor;
        private boolean hasVisited = false;

        public MyClassVisitor(@NotNull ClassWriter cw, @NotNull Executable executable, @Nullable IMethodVisitorAppender methodVisitorAppender, @Nullable IMethodVisitorReplacer<T> methodVisitorReplacer) {
            super(589824, cw);
            this.methodVisitorAppender = methodVisitorAppender;
            this.methodVisitorReplacer = methodVisitorReplacer;
            if (executable instanceof Constructor) {
                this.type = Type.getType((Constructor)executable);
                this.executableName = "<init>";
            } else {
                this.type = Type.getType((Method)executable);
                this.executableName = executable.getName();
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (!this.hasVisited && Type.getType(desc).equals(this.type) && name.equals(this.executableName)) {
                if (this.methodVisitorReplacer != null) {
                    this.replacementVisitor = this.methodVisitorReplacer.create(access, name, desc, signature, exceptions);
                    mv = this.replacementVisitor;
                }
                if (this.methodVisitorAppender != null) {
                    mv = this.methodVisitorAppender.append(mv);
                }
                this.hasVisited = true;
            }
            return mv;
        }
    }
}

