/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ParameterizedTypeImpl
implements ParameterizedType {
    @Nullable
    private final Type ownerType;
    private final Type rawType;
    private final Type[] typeArguments;

    public ParameterizedTypeImpl(@Nullable Type ownerType, Class<?> rawType, Type[] typeArguments) {
        this.ownerType = ownerType;
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArguments = typeArguments;
        if (typeArguments.length != rawType.getTypeParameters().length) {
            throw new IllegalArgumentException("Type arguments length does not match the number of type parameters of the raw type.");
        }
    }

    public ParameterizedTypeImpl(Class<?> rawType, Type ... typeArguments) {
        this((Type)null, rawType, typeArguments);
    }

    @Override
    public Type @NotNull [] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @NotNull
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    @Nullable
    public Type getOwnerType() {
        return this.ownerType;
    }

    public String toString() {
        return "ParameterizedTypeImpl{ownerType=" + this.ownerType + ", rawType=" + this.rawType + ", typeArguments=" + Stream.of(this.typeArguments).map(Type::getTypeName).collect(Collectors.joining(", ", "[", "]")) + '}';
    }

    public int hashCode() {
        return Objects.hash(this.ownerType, this.rawType, Arrays.hashCode(this.typeArguments));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedTypeImpl other = (ParameterizedTypeImpl)obj;
        return Objects.equals(this.ownerType, other.ownerType) && Objects.equals(this.rawType, other.rawType) && Arrays.equals(this.typeArguments, other.typeArguments);
    }
}

