/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.semver4j;

import java.util.ArrayList;
import java.util.List;
import nl.pim16aap2.bigDoors.semver4j.Range;
import nl.pim16aap2.bigDoors.semver4j.RangesList;
import nl.pim16aap2.bigDoors.semver4j.Semver;
import org.jetbrains.annotations.NotNull;

public class RangesExpression {
    @NotNull
    private final RangesList rangesList = new RangesList();
    @NotNull
    private final @NotNull List<@NotNull Range> andOperationRanges = new ArrayList<Range>();

    @NotNull
    public static RangesExpression equal(@NotNull String version) {
        return RangesExpression.equal(new Semver(version));
    }

    @NotNull
    public static RangesExpression equal(@NotNull Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.EQ));
    }

    @NotNull
    public static RangesExpression greater(@NotNull String version) {
        return RangesExpression.greater(new Semver(version));
    }

    @NotNull
    public static RangesExpression greater(@NotNull Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.GT));
    }

    @NotNull
    public static RangesExpression greaterOrEqual(@NotNull String version) {
        return RangesExpression.greaterOrEqual(new Semver(version));
    }

    @NotNull
    public static RangesExpression greaterOrEqual(@NotNull Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.GTE));
    }

    @NotNull
    public static RangesExpression less(@NotNull String version) {
        return RangesExpression.less(new Semver(version));
    }

    @NotNull
    public static RangesExpression less(@NotNull Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.LT));
    }

    @NotNull
    public static RangesExpression lessOrEqual(@NotNull String version) {
        return RangesExpression.lessOrEqual(new Semver(version));
    }

    @NotNull
    public static RangesExpression lessOrEqual(@NotNull Semver version) {
        return new RangesExpression(new Range(version, Range.RangeOperator.LTE));
    }

    RangesExpression(@NotNull Range range) {
        this.andOperationRanges.add(range);
    }

    @NotNull
    public RangesExpression and(@NotNull RangesExpression rangeExpression) {
        RangesList rangesList = rangeExpression.get();
        List<List<Range>> lists = rangesList.get();
        for (List<Range> list : lists) {
            this.andOperationRanges.addAll(list);
            if (lists.size() <= 1) continue;
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this;
    }

    @NotNull
    public RangesExpression or(@NotNull RangesExpression rangeExpression) {
        this.flushAndClearAndOperationRangesToRangesList();
        return this.and(rangeExpression);
    }

    @NotNull
    RangesList get() {
        if (!this.andOperationRanges.isEmpty()) {
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this.rangesList;
    }

    private void flushAndClearAndOperationRangesToRangesList() {
        this.rangesList.add(new ArrayList<Range>(this.andOperationRanges));
        this.andOperationRanges.clear();
    }
}

